/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestPerTableCFReplication {
    private static final Log LOG = LogFactory.getLog(TestPerTableCFReplication.class);
    private static Configuration conf1;
    private static Configuration conf2;
    private static Configuration conf3;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static HBaseTestingUtility utility3;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 100;
    private static final TableName tableName;
    private static final TableName tabAName;
    private static final TableName tabBName;
    private static final TableName tabCName;
    private static final byte[] famName;
    private static final byte[] f1Name;
    private static final byte[] f2Name;
    private static final byte[] f3Name;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] noRepfamName;
    private static final byte[] val;
    private static HTableDescriptor table;
    private static HTableDescriptor tabA;
    private static HTableDescriptor tabB;
    private static HTableDescriptor tabC;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setBoolean("hbase.replication", true);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{"org.apache.hadoop.hbase.replication.TestMasterReplication$CoprocessorCounter"});
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        new ZooKeeperWatcher(conf1, "cluster1", null, true);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf3 = new Configuration(conf1);
        conf3.set("zookeeper.znode.parent", "/3");
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf2, "cluster3", null, true);
        utility3 = new HBaseTestingUtility(conf3);
        utility3.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf3, "cluster3", null, true);
        table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        table.addFamily(fam);
        tabA = new HTableDescriptor(tabAName);
        fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        fam = new HColumnDescriptor(f3Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        tabB = new HTableDescriptor(tabBName);
        fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        fam = new HColumnDescriptor(f3Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        tabC = new HTableDescriptor(tabCName);
        fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabC.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabC.addFamily(fam);
        fam = new HColumnDescriptor(f3Name);
        fam.setScope(1);
        tabC.addFamily(fam);
        utility1.startMiniCluster();
        utility2.startMiniCluster();
        utility3.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility3.shutdownMiniCluster();
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Test
    public void testParseTableCFsFromConfig() {
        Map tabCFsMap = null;
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig(null);
        Assert.assertEquals(null, (Object)tabCFsMap);
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"");
        Assert.assertEquals(null, (Object)tabCFsMap);
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"   ");
        Assert.assertEquals(null, (Object)tabCFsMap);
        TableName tab1 = TableName.valueOf((String)"tab1");
        TableName tab2 = TableName.valueOf((String)"tab2");
        TableName tab3 = TableName.valueOf((String)"tab3");
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"tab1");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab1));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tab2));
        Assert.assertEquals(null, tabCFsMap.get(tab1));
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"tab2:cf1");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab2));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tab1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tab2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tab2)).get(0));
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"tab3 : cf1 , cf3");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab3));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tab1));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tab3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf3"));
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"tab1 ; tab2:cf1 ; tab3:cf1,cf3");
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab1));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab3));
        Assert.assertEquals(null, tabCFsMap.get(tab1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tab2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tab2)).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tab3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf3"));
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"tab1 ; ; tab2:cf1 ; tab3:cf1,,cf3 ;");
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab1));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab3));
        Assert.assertEquals(null, tabCFsMap.get(tab1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tab2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tab2)).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tab3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf3"));
        tabCFsMap = ReplicationSerDeHelper.parseTableCFsFromConfig((String)"tab1:tt:cf1 ; tab2::cf1 ; tab3:cf1,cf3");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tab1));
        Assert.assertFalse((boolean)tabCFsMap.containsKey(tab2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab3));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tab3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf3"));
    }

    @Test
    public void testTableCFsHelperConverter() {
        ZooKeeperProtos.TableCF[] tableCFs = null;
        Map tabCFsMap = null;
        Assert.assertNull((Object)ReplicationSerDeHelper.convert(tabCFsMap));
        tabCFsMap = new HashMap();
        tableCFs = ReplicationSerDeHelper.convert(tabCFsMap);
        Assert.assertEquals((long)0L, (long)tableCFs.length);
        TableName tab1 = TableName.valueOf((String)"tab1");
        TableName tab2 = TableName.valueOf((String)"tab2");
        TableName tab3 = TableName.valueOf((String)"tab3");
        tabCFsMap.clear();
        tabCFsMap.put(tab1, null);
        tableCFs = ReplicationSerDeHelper.convert(tabCFsMap);
        Assert.assertEquals((long)1L, (long)tableCFs.length);
        Assert.assertEquals((Object)tab1.toString(), (Object)tableCFs[0].getTableName().getQualifier().toStringUtf8());
        Assert.assertEquals((long)0L, (long)tableCFs[0].getFamiliesCount());
        tabCFsMap.clear();
        tabCFsMap.put(tab2, new ArrayList());
        ((List)tabCFsMap.get(tab2)).add("cf1");
        tableCFs = ReplicationSerDeHelper.convert(tabCFsMap);
        Assert.assertEquals((long)1L, (long)tableCFs.length);
        Assert.assertEquals((Object)tab2.toString(), (Object)tableCFs[0].getTableName().getQualifier().toStringUtf8());
        Assert.assertEquals((long)1L, (long)tableCFs[0].getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)tableCFs[0].getFamilies(0).toStringUtf8());
        tabCFsMap.clear();
        tabCFsMap.put(tab3, new ArrayList());
        ((List)tabCFsMap.get(tab3)).add("cf1");
        ((List)tabCFsMap.get(tab3)).add("cf3");
        tableCFs = ReplicationSerDeHelper.convert(tabCFsMap);
        Assert.assertEquals((long)1L, (long)tableCFs.length);
        Assert.assertEquals((Object)tab3.toString(), (Object)tableCFs[0].getTableName().getQualifier().toStringUtf8());
        Assert.assertEquals((long)2L, (long)tableCFs[0].getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)tableCFs[0].getFamilies(0).toStringUtf8());
        Assert.assertEquals((Object)"cf3", (Object)tableCFs[0].getFamilies(1).toStringUtf8());
        tabCFsMap.clear();
        tabCFsMap.put(tab1, null);
        tabCFsMap.put(tab2, new ArrayList());
        ((List)tabCFsMap.get(tab2)).add("cf1");
        tabCFsMap.put(tab3, new ArrayList());
        ((List)tabCFsMap.get(tab3)).add("cf1");
        ((List)tabCFsMap.get(tab3)).add("cf3");
        tableCFs = ReplicationSerDeHelper.convert(tabCFsMap);
        Assert.assertEquals((long)3L, (long)tableCFs.length);
        Assert.assertNotNull((Object)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab1.toString()));
        Assert.assertNotNull((Object)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab2.toString()));
        Assert.assertNotNull((Object)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab3.toString()));
        Assert.assertEquals((long)0L, (long)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab1.toString()).getFamiliesCount());
        Assert.assertEquals((long)1L, (long)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab2.toString()).getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab2.toString()).getFamilies(0).toStringUtf8());
        Assert.assertEquals((long)2L, (long)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab3.toString()).getFamiliesCount());
        Assert.assertEquals((Object)"cf1", (Object)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab3.toString()).getFamilies(0).toStringUtf8());
        Assert.assertEquals((Object)"cf3", (Object)ReplicationSerDeHelper.getTableCF((ZooKeeperProtos.TableCF[])tableCFs, (String)tab3.toString()).getFamilies(1).toStringUtf8());
        tabCFsMap = ReplicationSerDeHelper.convert2Map((ZooKeeperProtos.TableCF[])tableCFs);
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab1));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab2));
        Assert.assertTrue((boolean)tabCFsMap.containsKey(tab3));
        Assert.assertEquals(null, tabCFsMap.get(tab1));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get(tab2)).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get(tab2)).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get(tab3)).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get(tab3)).contains("cf3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testPerTableCFReplication() throws Exception {
        LOG.info((Object)"testPerTableCFReplication");
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(conf1);
        Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
        Connection connection3 = ConnectionFactory.createConnection((Configuration)conf3);
        try {
            Admin admin1 = connection1.getAdmin();
            Admin admin2 = connection2.getAdmin();
            Admin admin3 = connection3.getAdmin();
            admin1.createTable(tabA);
            admin1.createTable(tabB);
            admin1.createTable(tabC);
            admin2.createTable(tabA);
            admin2.createTable(tabB);
            admin2.createTable(tabC);
            admin3.createTable(tabA);
            admin3.createTable(tabB);
            admin3.createTable(tabC);
            Table htab1A = connection1.getTable(tabAName);
            Table htab2A = connection2.getTable(tabAName);
            Table htab3A = connection3.getTable(tabAName);
            Table htab1B = connection1.getTable(tabBName);
            Table htab2B = connection2.getTable(tabBName);
            Table htab3B = connection3.getTable(tabBName);
            Table htab1C = connection1.getTable(tabCName);
            Table htab2C = connection2.getTable(tabCName);
            Table htab3C = connection3.getTable(tabCName);
            ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
            rpc2.setClusterKey(utility2.getClusterKey());
            HashMap tableCFs = new HashMap();
            tableCFs.put(tabCName, null);
            tableCFs.put(tabBName, new ArrayList());
            ((List)tableCFs.get(tabBName)).add("f1");
            ((List)tableCFs.get(tabBName)).add("f3");
            replicationAdmin.addPeer("2", rpc2, tableCFs);
            ReplicationPeerConfig rpc3 = new ReplicationPeerConfig();
            rpc3.setClusterKey(utility3.getClusterKey());
            tableCFs.clear();
            tableCFs.put(tabAName, null);
            tableCFs.put(tabBName, new ArrayList());
            ((List)tableCFs.get(tabBName)).add("f1");
            ((List)tableCFs.get(tabBName)).add("f2");
            replicationAdmin.addPeer("3", rpc3, tableCFs);
            this.putAndWaitWithFamily(row1, f1Name, htab1A, htab3A);
            this.ensureRowNotReplicated(row1, f1Name, htab2A);
            this.deleteAndWaitWithFamily(row1, f1Name, htab1A, htab3A);
            this.putAndWaitWithFamily(row1, f2Name, htab1A, htab3A);
            this.ensureRowNotReplicated(row1, f2Name, htab2A);
            this.deleteAndWaitWithFamily(row1, f2Name, htab1A, htab3A);
            this.putAndWaitWithFamily(row1, f3Name, htab1A, htab3A);
            this.ensureRowNotReplicated(row1, f3Name, htab2A);
            this.deleteAndWaitWithFamily(row1, f3Name, htab1A, htab3A);
            this.putAndWaitWithFamily(row1, f1Name, htab1B, htab2B, htab3B);
            this.deleteAndWaitWithFamily(row1, f1Name, htab1B, htab2B, htab3B);
            this.putAndWaitWithFamily(row1, f2Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row1, f2Name, htab2B);
            this.deleteAndWaitWithFamily(row1, f2Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row1, f3Name, htab1B, htab2B);
            this.ensureRowNotReplicated(row1, f3Name, htab3B);
            this.deleteAndWaitWithFamily(row1, f3Name, htab1B, htab2B);
            this.putAndWaitWithFamily(row1, f1Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row1, f1Name, htab3C);
            this.deleteAndWaitWithFamily(row1, f1Name, htab1C, htab2C);
            this.putAndWaitWithFamily(row1, f2Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row1, f2Name, htab3C);
            this.deleteAndWaitWithFamily(row1, f2Name, htab1C, htab2C);
            this.putAndWaitWithFamily(row1, f3Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row1, f3Name, htab3C);
            this.deleteAndWaitWithFamily(row1, f3Name, htab1C, htab2C);
            tableCFs.clear();
            tableCFs.put(tabAName, new ArrayList());
            ((List)tableCFs.get(tabAName)).add("f1");
            ((List)tableCFs.get(tabAName)).add("f2");
            tableCFs.put(tabCName, new ArrayList());
            ((List)tableCFs.get(tabCName)).add("f2");
            ((List)tableCFs.get(tabCName)).add("f3");
            replicationAdmin.setPeerTableCFs("2", tableCFs);
            tableCFs.clear();
            tableCFs.put(tabBName, null);
            tableCFs.put(tabCName, new ArrayList());
            ((List)tableCFs.get(tabCName)).add("f3");
            replicationAdmin.setPeerTableCFs("3", tableCFs);
            this.putAndWaitWithFamily(row2, f1Name, htab1A, htab2A);
            this.ensureRowNotReplicated(row2, f1Name, htab3A);
            this.deleteAndWaitWithFamily(row2, f1Name, htab1A, htab2A);
            this.putAndWaitWithFamily(row2, f2Name, htab1A, htab2A);
            this.ensureRowNotReplicated(row2, f2Name, htab3A);
            this.deleteAndWaitWithFamily(row2, f2Name, htab1A, htab2A);
            this.putAndWaitWithFamily(row2, f3Name, htab1A, new Table[0]);
            this.ensureRowNotReplicated(row2, f3Name, htab2A, htab3A);
            this.deleteAndWaitWithFamily(row2, f3Name, htab1A, new Table[0]);
            this.putAndWaitWithFamily(row2, f1Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row2, f1Name, htab2B);
            this.deleteAndWaitWithFamily(row2, f1Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row2, f2Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row2, f2Name, htab2B);
            this.deleteAndWaitWithFamily(row2, f2Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row2, f3Name, htab1B, htab3B);
            this.ensureRowNotReplicated(row2, f3Name, htab2B);
            this.deleteAndWaitWithFamily(row2, f3Name, htab1B, htab3B);
            this.putAndWaitWithFamily(row2, f1Name, htab1C, new Table[0]);
            this.ensureRowNotReplicated(row2, f1Name, htab2C, htab3C);
            this.deleteAndWaitWithFamily(row2, f1Name, htab1C, new Table[0]);
            this.putAndWaitWithFamily(row2, f2Name, htab1C, htab2C);
            this.ensureRowNotReplicated(row2, f2Name, htab3C);
            this.deleteAndWaitWithFamily(row2, f2Name, htab1C, htab2C);
            this.putAndWaitWithFamily(row2, f3Name, htab1C, htab2C, htab3C);
            this.deleteAndWaitWithFamily(row2, f3Name, htab1C, htab2C, htab3C);
        }
        finally {
            connection1.close();
            connection2.close();
            connection3.close();
        }
    }

    private void ensureRowNotReplicated(byte[] row, byte[] fam, Table ... tables) throws IOException {
        Get get = new Get(row);
        get.addFamily(fam);
        for (Table table : tables) {
            Result res = table.get(get);
            Assert.assertEquals((long)0L, (long)res.size());
        }
    }

    private void deleteAndWaitWithFamily(byte[] row, byte[] fam, Table source, Table ... targets) throws Exception {
        Delete del = new Delete(row);
        del.deleteFamily(fam);
        source.delete(del);
        Get get = new Get(row);
        get.addFamily(fam);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            boolean removedFromAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.size() < 1) continue;
                LOG.info((Object)"Row not deleted");
                removedFromAll = false;
                break;
            }
            if (removedFromAll) break;
            Thread.sleep(500L);
        }
    }

    private void putAndWaitWithFamily(byte[] row, byte[] fam, Table source, Table ... targets) throws Exception {
        Put put = new Put(row);
        put.add(fam, row, val);
        source.put(put);
        Get get = new Get(row);
        get.addFamily(fam);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            boolean replicatedToAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.size() == 0) {
                    LOG.info((Object)"Row not available");
                    replicatedToAll = false;
                    break;
                }
                Assert.assertEquals((long)res.size(), (long)1L);
                Assert.assertArrayEquals((byte[])res.value(), (byte[])val);
            }
            if (replicatedToAll) break;
            Thread.sleep(500L);
        }
    }

    static {
        tableName = TableName.valueOf((String)"test");
        tabAName = TableName.valueOf((String)"TA");
        tabBName = TableName.valueOf((String)"TB");
        tabCName = TableName.valueOf((String)"TC");
        famName = Bytes.toBytes((String)"f");
        f1Name = Bytes.toBytes((String)"f1");
        f2Name = Bytes.toBytes((String)"f2");
        f3Name = Bytes.toBytes((String)"f3");
        row1 = Bytes.toBytes((String)"row1");
        row2 = Bytes.toBytes((String)"row2");
        noRepfamName = Bytes.toBytes((String)"norep");
        val = Bytes.toBytes((String)"myval");
    }
}

