/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MockStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestStripeStoreFileManager {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Path BASEDIR = TEST_UTIL.getDataTestDir(TestStripeStoreFileManager.class.getSimpleName());
    private static final Path CFDIR = HStore.getStoreHomedir((Path)BASEDIR, (String)"region", (byte[])Bytes.toBytes((String)"cf"));
    private static final byte[] KEY_A = Bytes.toBytes((String)"aaa");
    private static final byte[] KEY_B = Bytes.toBytes((String)"bbb");
    private static final byte[] KEY_C = Bytes.toBytes((String)"ccc");
    private static final byte[] KEY_D = Bytes.toBytes((String)"ddd");
    private static final KeyValue KV_A = new KeyValue(KEY_A, 0L);
    private static final KeyValue KV_B = new KeyValue(KEY_B, 0L);
    private static final KeyValue KV_C = new KeyValue(KEY_C, 0L);
    private static final KeyValue KV_D = new KeyValue(KEY_D, 0L);

    @Before
    public void setUp() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        if (!fs.mkdirs(CFDIR)) {
            throw new IOException("Cannot create test directory " + CFDIR);
        }
    }

    @After
    public void tearDown() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        if (fs.exists(CFDIR) && !fs.delete(CFDIR, true)) {
            throw new IOException("Cannot delete test directory " + CFDIR);
        }
    }

    @Test
    public void testInsertFilesIntoL0() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager();
        MockStoreFile sf = TestStripeStoreFileManager.createFile();
        manager.insertNewFiles(TestStripeStoreFileManager.al(sf));
        Assert.assertEquals((long)1L, (long)manager.getStorefileCount());
        Collection filesForGet = manager.getFilesForScanOrGet(KEY_A, true, KEY_A, true);
        Assert.assertEquals((long)1L, (long)filesForGet.size());
        Assert.assertTrue((boolean)filesForGet.contains((Object)sf));
        manager.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_B, StripeStoreFileManager.OPEN_KEY)));
        Assert.assertTrue((boolean)manager.getFilesForScanOrGet(KEY_A, true, KEY_A, true).contains((Object)sf));
        Assert.assertTrue((boolean)manager.getFilesForScanOrGet(KEY_C, true, KEY_C, true).contains((Object)sf));
    }

    @Test
    public void testClearFiles() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager();
        manager.insertNewFiles(TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile()));
        manager.insertNewFiles(TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile()));
        manager.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_B, StripeStoreFileManager.OPEN_KEY)));
        Assert.assertEquals((long)4L, (long)manager.getStorefileCount());
        ImmutableCollection allFiles = manager.clearFiles();
        Assert.assertEquals((long)4L, (long)allFiles.size());
        Assert.assertEquals((long)0L, (long)manager.getStorefileCount());
        Assert.assertEquals((long)0L, (long)manager.getStorefiles().size());
    }

    private static ArrayList<StoreFile> dumpIterator(Iterator<StoreFile> iter) {
        ArrayList<StoreFile> result = new ArrayList<StoreFile>();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    @Test
    public void testRowKeyBefore() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager();
        MockStoreFile l0File = TestStripeStoreFileManager.createFile();
        MockStoreFile l0File2 = TestStripeStoreFileManager.createFile();
        manager.insertNewFiles(TestStripeStoreFileManager.al(l0File));
        manager.insertNewFiles(TestStripeStoreFileManager.al(l0File2));
        Iterator sfs = manager.getCandidateFilesForRowKeyBefore(KV_B);
        sfs.next();
        sfs.remove();
        sfs = manager.updateCandidateFilesForRowKeyBefore(sfs, KV_B, (Cell)KV_A);
        Assert.assertTrue((boolean)sfs.hasNext());
        MockStoreFile stripe0a = TestStripeStoreFileManager.createFile(0L, 100L, StripeStoreFileManager.OPEN_KEY, KEY_B);
        MockStoreFile stripe1 = TestStripeStoreFileManager.createFile(KEY_B, StripeStoreFileManager.OPEN_KEY);
        manager.addCompactionResults(TestStripeStoreFileManager.al(l0File), TestStripeStoreFileManager.al(stripe0a, stripe1));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(l0File));
        ArrayList<StoreFile> sfsDump = TestStripeStoreFileManager.dumpIterator(manager.getCandidateFilesForRowKeyBefore(KV_A));
        Assert.assertEquals((long)2L, (long)sfsDump.size());
        Assert.assertTrue((boolean)sfsDump.contains((Object)stripe0a));
        Assert.assertFalse((boolean)sfsDump.contains((Object)stripe1));
        sfsDump = TestStripeStoreFileManager.dumpIterator(manager.getCandidateFilesForRowKeyBefore(KV_B));
        Assert.assertEquals((long)3L, (long)sfsDump.size());
        Assert.assertTrue((boolean)sfsDump.contains((Object)stripe1));
        sfsDump = TestStripeStoreFileManager.dumpIterator(manager.getCandidateFilesForRowKeyBefore(KV_D));
        Assert.assertEquals((long)3L, (long)sfsDump.size());
        sfs = manager.getCandidateFilesForRowKeyBefore(KV_D);
        sfs.next();
        sfs.remove();
        sfs = manager.updateCandidateFilesForRowKeyBefore(sfs, KV_D, (Cell)KV_C);
        Assert.assertEquals((Object)((Object)stripe1), sfs.next());
        Assert.assertFalse((boolean)sfs.hasNext());
        MockStoreFile stripe0b = TestStripeStoreFileManager.createFile(0L, 101L, StripeStoreFileManager.OPEN_KEY, KEY_B);
        manager.addCompactionResults(TestStripeStoreFileManager.al(l0File2), TestStripeStoreFileManager.al(stripe0b));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(l0File2));
        sfs = manager.getCandidateFilesForRowKeyBefore(KV_A);
        Assert.assertEquals((Object)((Object)stripe0b), sfs.next());
        sfs.remove();
        sfs = manager.updateCandidateFilesForRowKeyBefore(sfs, KV_A, (Cell)KV_A);
        Assert.assertEquals((Object)((Object)stripe0a), sfs.next());
    }

    @Test
    public void testGetSplitPointEdgeCases() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager();
        Assert.assertNull((Object)manager.getSplitPoint());
        MockStoreFile sf5 = TestStripeStoreFileManager.createFile(5L, 0L);
        sf5.splitPoint = new byte[1];
        manager.insertNewFiles(TestStripeStoreFileManager.al(sf5));
        manager.insertNewFiles(TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(1L, 0L)));
        Assert.assertArrayEquals((byte[])sf5.splitPoint, (byte[])manager.getSplitPoint());
        manager.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(2L, 0L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY)));
        Assert.assertArrayEquals((byte[])sf5.splitPoint, (byte[])manager.getSplitPoint());
        MockStoreFile sf6 = TestStripeStoreFileManager.createFile(6L, 0L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
        sf6.splitPoint = new byte[1];
        manager.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), TestStripeStoreFileManager.al(sf6));
        Assert.assertArrayEquals((byte[])sf6.splitPoint, (byte[])manager.getSplitPoint());
    }

    @Test
    public void testGetStripeBoundarySplits() throws Exception {
        this.verifySplitPointScenario(5, false, 0.0f, 2, 1, 1, 1, 1, 1, 10);
        this.verifySplitPointScenario(0, false, 0.0f, 6, 3, 1, 1, 2);
        this.verifySplitPointScenario(2, false, 0.0f, 1, 1, 1, 1, 2);
        this.verifySplitPointScenario(0, false, 0.0f, 5, 4);
        this.verifySplitPointScenario(2, false, 0.0f, 5, 2, 5, 5, 5);
    }

    @Test
    public void testGetUnbalancedSplits() throws Exception {
        this.verifySplitPointScenario(0, false, 2.1f, 4, 4, 4);
        this.verifySplitPointScenario(1, true, 1.5f, 4, 4, 4);
        this.verifySplitPointScenario(1, false, 1.1f, 3, 4, 1, 1, 2, 2);
        this.verifySplitPointScenario(1, false, 1.1f, 3, 6, 1, 1, 2, 2);
        this.verifySplitPointScenario(1, true, 1.1f, 3, 8, 1, 1, 2, 2);
        this.verifySplitPointScenario(3, false, 1.1f, 2, 2, 1, 1, 4, 3);
        this.verifySplitPointScenario(4, true, 1.1f, 2, 2, 1, 1, 8, 3);
        this.verifySplitPointScenario(0, true, 1.5f, 10, 4);
        this.verifySplitPointScenario(0, false, 1.4f, 6, 4);
        this.verifySplitPointScenario(1, true, 1.5f, 4, 10);
        this.verifySplitPointScenario(0, false, 1.4f, 4, 6);
    }

    private void verifySplitPointScenario(int splitPointAfter, boolean shouldSplitStripe, float splitRatioToVerify, int ... sizes) throws Exception {
        Assert.assertTrue((sizes.length > 1 ? 1 : 0) != 0);
        ArrayList<MockStoreFile> sfs = new ArrayList<MockStoreFile>();
        for (int sizeIx = 0; sizeIx < sizes.length; ++sizeIx) {
            byte[] startKey = sizeIx == 0 ? StripeStoreFileManager.OPEN_KEY : Bytes.toBytes((int)(sizeIx - 1));
            byte[] endKey = sizeIx == sizes.length - 1 ? StripeStoreFileManager.OPEN_KEY : Bytes.toBytes((int)sizeIx);
            MockStoreFile sf = TestStripeStoreFileManager.createFile(sizes[sizeIx], 0L, startKey, endKey);
            sf.splitPoint = Bytes.toBytes((int)(-sizeIx));
            sfs.add(sf);
        }
        Configuration conf = HBaseConfiguration.create();
        if (splitRatioToVerify != 0.0f) {
            conf.setFloat("hbase.store.stripe.region.split.max.imbalance", splitRatioToVerify);
        }
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager(TestStripeStoreFileManager.al(new StoreFile[0]), conf);
        manager.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), sfs);
        int result = Bytes.toInt((byte[])manager.getSplitPoint());
        Assert.assertEquals((long)(splitPointAfter * (shouldSplitStripe ? -1 : 1)), (long)result);
    }

    private static byte[] keyAfter(byte[] key) {
        return Arrays.copyOf(key, key.length + 1);
    }

    @Test
    public void testGetFilesForGetAndScan() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager();
        this.verifyGetAndScanScenario(manager, null, null, new StoreFile[0]);
        this.verifyGetAndScanScenario(manager, KEY_B, KEY_C, new StoreFile[0]);
        MockStoreFile sf0 = TestStripeStoreFileManager.createFile();
        manager.insertNewFiles(TestStripeStoreFileManager.al(sf0));
        this.verifyGetAndScanScenario(manager, null, null, sf0);
        this.verifyGetAndScanScenario(manager, null, KEY_C, sf0);
        this.verifyGetAndScanScenario(manager, KEY_B, null, sf0);
        this.verifyGetAndScanScenario(manager, KEY_B, KEY_C, sf0);
        MockStoreFile sfA = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_A);
        MockStoreFile sfB = TestStripeStoreFileManager.createFile(KEY_A, KEY_B);
        MockStoreFile sfC = TestStripeStoreFileManager.createFile(KEY_B, KEY_C);
        MockStoreFile sfD = TestStripeStoreFileManager.createFile(KEY_C, KEY_D);
        MockStoreFile sfE = TestStripeStoreFileManager.createFile(KEY_D, StripeStoreFileManager.OPEN_KEY);
        manager.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), TestStripeStoreFileManager.al(sfA, sfB, sfC, sfD, sfE));
        this.verifyGetAndScanScenario(manager, null, null, sf0, sfA, sfB, sfC, sfD, sfE);
        this.verifyGetAndScanScenario(manager, TestStripeStoreFileManager.keyAfter(KEY_A), null, sf0, sfB, sfC, sfD, sfE);
        this.verifyGetAndScanScenario(manager, null, TestStripeStoreFileManager.keyAfter(KEY_C), sf0, sfA, sfB, sfC, sfD);
        this.verifyGetAndScanScenario(manager, KEY_B, null, sf0, sfC, sfD, sfE);
        this.verifyGetAndScanScenario(manager, null, KEY_C, sf0, sfA, sfB, sfC, sfD);
        this.verifyGetAndScanScenario(manager, KEY_B, TestStripeStoreFileManager.keyAfter(KEY_B), sf0, sfC);
        this.verifyGetAndScanScenario(manager, TestStripeStoreFileManager.keyAfter(KEY_A), KEY_B, sf0, sfB, sfC);
        this.verifyGetAndScanScenario(manager, KEY_D, KEY_D, sf0, sfE);
        this.verifyGetAndScanScenario(manager, TestStripeStoreFileManager.keyAfter(KEY_B), TestStripeStoreFileManager.keyAfter(KEY_C), sf0, sfC, sfD);
    }

    private void verifyGetAndScanScenario(StripeStoreFileManager manager, byte[] start, byte[] end, StoreFile ... results) throws Exception {
        this.verifyGetOrScanScenario(manager, true, start, end, results);
        this.verifyGetOrScanScenario(manager, false, start, end, results);
    }

    @Test
    public void testLoadFilesWithRecoverableBadFiles() throws Exception {
        ArrayList<StoreFile> validStripeFiles = TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_B, KEY_C), TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY), TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY));
        ArrayList<StoreFile> filesToGoToL0 = TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(), TestStripeStoreFileManager.createFile(null, KEY_A), TestStripeStoreFileManager.createFile(KEY_D, null), TestStripeStoreFileManager.createFile(KEY_D, KEY_A), TestStripeStoreFileManager.createFile(TestStripeStoreFileManager.keyAfter(KEY_A), KEY_C), TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_D), TestStripeStoreFileManager.createFile(KEY_D, TestStripeStoreFileManager.keyAfter(KEY_D)));
        ArrayList<StoreFile> allFilesToGo = TestStripeStoreFileManager.flattenLists(validStripeFiles, filesToGoToL0);
        Collections.shuffle(allFilesToGo);
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager(allFilesToGo);
        List l0Files = manager.getLevel0Files();
        Assert.assertEquals((long)filesToGoToL0.size(), (long)l0Files.size());
        for (StoreFile sf : filesToGoToL0) {
            Assert.assertTrue((boolean)l0Files.contains(sf));
        }
        this.verifyAllFiles(manager, allFilesToGo);
    }

    @Test
    public void testLoadFilesWithBadStripe() throws Exception {
        ArrayList<StoreFile> allFilesToGo = TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_B, KEY_C), TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY), TestStripeStoreFileManager.createFile(KEY_B, TestStripeStoreFileManager.keyAfter(KEY_B)));
        Collections.shuffle(allFilesToGo);
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager(allFilesToGo);
        Assert.assertEquals((long)allFilesToGo.size(), (long)manager.getLevel0Files().size());
    }

    @Test
    public void testLoadFilesWithGaps() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager(TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY)));
        Assert.assertEquals((long)2L, (long)manager.getLevel0Files().size());
        manager = TestStripeStoreFileManager.createManager(TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY)));
        Assert.assertEquals((long)0L, (long)manager.getLevel0Files().size());
        Assert.assertEquals((long)1L, (long)manager.getStorefileCount());
    }

    @Test
    public void testLoadFilesAfterSplit() throws Exception {
        MockStoreFile sf = TestStripeStoreFileManager.createFile(KEY_B, KEY_C);
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager(TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), sf));
        Assert.assertEquals((long)0L, (long)manager.getLevel0Files().size());
        this.verifyInvalidCompactionScenario(manager, TestStripeStoreFileManager.al(sf), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(KEY_B, KEY_C)));
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(KEY_B, StripeStoreFileManager.OPEN_KEY)));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf));
        manager = TestStripeStoreFileManager.createManager(TestStripeStoreFileManager.al(sf, TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY)));
        this.verifyInvalidCompactionScenario(manager, TestStripeStoreFileManager.al(sf), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(KEY_B, KEY_C)));
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_C)));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf));
        manager = TestStripeStoreFileManager.createManager(TestStripeStoreFileManager.al(sf));
        this.verifyInvalidCompactionScenario(manager, TestStripeStoreFileManager.al(sf), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(KEY_B, KEY_C)));
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY)));
    }

    @Test
    public void testAddingCompactionResults() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager();
        MockStoreFile sf_L0_0a = TestStripeStoreFileManager.createFile();
        MockStoreFile sf_L0_0b = TestStripeStoreFileManager.createFile();
        manager.insertNewFiles(TestStripeStoreFileManager.al(sf_L0_0a, sf_L0_0b));
        this.verifyInvalidCompactionScenario(manager, TestStripeStoreFileManager.al(sf_L0_0a), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B)));
        this.verifyInvalidCompactionScenario(manager, TestStripeStoreFileManager.al(sf_L0_0a), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY)));
        this.verifyInvalidCompactionScenario(manager, TestStripeStoreFileManager.al(sf_L0_0a), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_B, StripeStoreFileManager.OPEN_KEY), TestStripeStoreFileManager.createFile(KEY_A, KEY_D)));
        this.verifyInvalidCompactionScenario(manager, TestStripeStoreFileManager.al(sf_L0_0a), TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_A, KEY_B), TestStripeStoreFileManager.createFile(KEY_B, StripeStoreFileManager.OPEN_KEY)));
        MockStoreFile sf_i2B_0 = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B);
        MockStoreFile sf_B2C_0 = TestStripeStoreFileManager.createFile(KEY_B, KEY_C);
        MockStoreFile sf_C2i_0 = TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_L0_0a), TestStripeStoreFileManager.al(sf_i2B_0, sf_B2C_0, sf_C2i_0));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_L0_0a));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_L0_0b, sf_i2B_0, sf_B2C_0, sf_C2i_0));
        MockStoreFile sf_L0_1 = TestStripeStoreFileManager.createFile();
        MockStoreFile sf_i2B_1 = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B);
        MockStoreFile sf_B2C_1 = TestStripeStoreFileManager.createFile(KEY_B, KEY_C);
        manager.insertNewFiles(TestStripeStoreFileManager.al(sf_L0_1));
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_L0_0b, sf_L0_1), TestStripeStoreFileManager.al(sf_i2B_1, sf_B2C_1));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_L0_0b, sf_L0_1));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_i2B_0, sf_B2C_0, sf_C2i_0, sf_i2B_1, sf_B2C_1));
        MockStoreFile sf_L0_2 = TestStripeStoreFileManager.createFile(null, null);
        manager.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), TestStripeStoreFileManager.al(sf_L0_2));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(new StoreFile[0]));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_i2B_0, sf_B2C_0, sf_C2i_0, sf_i2B_1, sf_B2C_1, sf_L0_2));
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_L0_2), TestStripeStoreFileManager.al(new StoreFile[0]));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_L0_2));
        MockStoreFile sf_i2B_3 = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_i2B_0, sf_i2B_1), TestStripeStoreFileManager.al(sf_i2B_3));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_i2B_0, sf_i2B_1));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_B2C_0, sf_C2i_0, sf_B2C_1, sf_i2B_3));
        MockStoreFile sf_B2D_4 = TestStripeStoreFileManager.createFile(KEY_B, KEY_D);
        MockStoreFile sf_D2i_4 = TestStripeStoreFileManager.createFile(KEY_D, StripeStoreFileManager.OPEN_KEY);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_B2C_0, sf_C2i_0, sf_B2C_1), TestStripeStoreFileManager.al(sf_B2D_4, sf_D2i_4));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_B2C_0, sf_C2i_0, sf_B2C_1));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_i2B_3, sf_B2D_4, sf_D2i_4));
        MockStoreFile sf_i2A_5 = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_A);
        MockStoreFile sf_A2B_5 = TestStripeStoreFileManager.createFile(KEY_A, KEY_B);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_i2B_3), TestStripeStoreFileManager.al(sf_i2A_5, sf_A2B_5));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_i2B_3));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_B2D_4, sf_D2i_4, sf_i2A_5, sf_A2B_5));
        MockStoreFile sf_B2C_6 = TestStripeStoreFileManager.createFile(KEY_B, KEY_C);
        MockStoreFile sf_C2D_6 = TestStripeStoreFileManager.createFile(KEY_C, KEY_D);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_B2D_4), TestStripeStoreFileManager.al(sf_B2C_6, sf_C2D_6));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_B2D_4));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_D2i_4, sf_i2A_5, sf_A2B_5, sf_B2C_6, sf_C2D_6));
        MockStoreFile sf_A2C_7 = TestStripeStoreFileManager.createFile(KEY_A, KEY_C);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_A2B_5, sf_B2C_6), TestStripeStoreFileManager.al(sf_A2C_7));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_A2B_5, sf_B2C_6));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_D2i_4, sf_i2A_5, sf_C2D_6, sf_A2C_7));
        MockStoreFile sf_i2C_8 = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_C);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_i2A_5, sf_A2C_7), TestStripeStoreFileManager.al(sf_i2C_8));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_i2A_5, sf_A2C_7));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_D2i_4, sf_C2D_6, sf_i2C_8));
        MockStoreFile sf_i2i_9 = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf_D2i_4, sf_C2D_6, sf_i2C_8), TestStripeStoreFileManager.al(sf_i2i_9));
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf_D2i_4, sf_C2D_6, sf_i2C_8));
        this.verifyAllFiles(manager, TestStripeStoreFileManager.al(sf_i2i_9));
    }

    @Test
    public void testCompactionAndFlushConflict() throws Exception {
        StripeStoreFileManager sfm = TestStripeStoreFileManager.createManager();
        Assert.assertEquals((long)0L, (long)sfm.getStripeCount());
        MockStoreFile sf_i2c = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_C);
        MockStoreFile sf_c2i = TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY);
        sfm.insertNewFiles(TestStripeStoreFileManager.al(sf_i2c, sf_c2i));
        Assert.assertEquals((long)2L, (long)sfm.getStripeCount());
        MockStoreFile sf_i2d = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_D);
        MockStoreFile sf_d2i = TestStripeStoreFileManager.createFile(KEY_D, StripeStoreFileManager.OPEN_KEY);
        sfm.insertNewFiles(TestStripeStoreFileManager.al(sf_i2d, sf_d2i));
        Assert.assertEquals((long)2L, (long)sfm.getStripeCount());
        Assert.assertEquals((long)2L, (long)sfm.getLevel0Files().size());
        this.verifyGetAndScanScenario(sfm, KEY_C, KEY_C, sf_i2d, sf_d2i, sf_c2i);
        sfm.addCompactionResults(TestStripeStoreFileManager.al(sf_i2d, sf_d2i), TestStripeStoreFileManager.al(new StoreFile[0]));
        sfm.removeCompactedFiles(TestStripeStoreFileManager.al(sf_i2d, sf_d2i));
        Assert.assertEquals((long)0L, (long)sfm.getLevel0Files().size());
        MockStoreFile sf_i2c_2 = TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_C);
        sfm.insertNewFiles(TestStripeStoreFileManager.al(sf_i2c_2));
        sfm.addCompactionResults(TestStripeStoreFileManager.al(sf_i2c, sf_c2i), TestStripeStoreFileManager.al(sf_i2d, sf_d2i));
        sfm.removeCompactedFiles(TestStripeStoreFileManager.al(sf_i2c, sf_c2i));
        Assert.assertEquals((long)1L, (long)sfm.getLevel0Files().size());
        this.verifyGetAndScanScenario(sfm, KEY_C, KEY_C, sf_i2d, sf_i2c_2);
    }

    @Test
    public void testEmptyResultsForStripes() throws Exception {
        StripeStoreFileManager manager = TestStripeStoreFileManager.createManager();
        MockStoreFile sf0a = TestStripeStoreFileManager.createFile();
        MockStoreFile sf0b = TestStripeStoreFileManager.createFile();
        manager.insertNewFiles(TestStripeStoreFileManager.al(sf0a));
        manager.insertNewFiles(TestStripeStoreFileManager.al(sf0b));
        ArrayList<StoreFile> compacted = TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_B, KEY_C), TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY));
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf0a), compacted);
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf0a));
        ArrayList<StoreFile> compacted2 = TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile(StripeStoreFileManager.OPEN_KEY, KEY_B), TestStripeStoreFileManager.createFile(KEY_C, StripeStoreFileManager.OPEN_KEY));
        manager.addCompactionResults(TestStripeStoreFileManager.al(sf0b), compacted2);
        manager.removeCompactedFiles(TestStripeStoreFileManager.al(sf0b));
        compacted.addAll(compacted2);
        this.verifyAllFiles(manager, compacted);
    }

    @Test
    public void testPriority() throws Exception {
        this.testPriorityScenario(5, 5, 0, 0, 0);
        this.testPriorityScenario(2, 5, 0, 0, 3);
        this.testPriorityScenario(4, 25, 5, 1, 0);
        this.testPriorityScenario(3, 25, 5, 1, 1);
        this.testPriorityScenario(3, 25, 5, 2, 0);
        this.testPriorityScenario(2, 25, 5, 4, 0);
        this.testPriorityScenario(2, 25, 5, 4, 4);
        this.testPriorityScenario(2, 25, 5, 1, 10);
        this.testPriorityScenario(0, 25, 5, 4, 5);
        this.testPriorityScenario(-5, 25, 5, 6, 0);
        this.testPriorityScenario(-1, 25, 0, 0, 26);
    }

    private void testPriorityScenario(int expectedPriority, int limit, int stripes, int filesInStripe, int l0Files) throws Exception {
        int i;
        byte[][] keys = new byte[][]{KEY_A, KEY_B, KEY_C, KEY_D};
        Assert.assertTrue((stripes <= keys.length + 1 ? 1 : 0) != 0);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.blockingStoreFiles", limit);
        StripeStoreFileManager sfm = TestStripeStoreFileManager.createManager(TestStripeStoreFileManager.al(new StoreFile[0]), conf);
        for (i = 0; i < l0Files; ++i) {
            sfm.insertNewFiles(TestStripeStoreFileManager.al(TestStripeStoreFileManager.createFile()));
        }
        for (i = 0; i < filesInStripe; ++i) {
            ArrayList<MockStoreFile> stripe = new ArrayList<MockStoreFile>();
            for (int j = 0; j < stripes; ++j) {
                stripe.add(TestStripeStoreFileManager.createFile(j == 0 ? StripeStoreFileManager.OPEN_KEY : keys[j - 1], j == stripes - 1 ? StripeStoreFileManager.OPEN_KEY : keys[j]));
            }
            sfm.addCompactionResults(TestStripeStoreFileManager.al(new StoreFile[0]), stripe);
        }
        Assert.assertEquals((long)expectedPriority, (long)sfm.getStoreCompactionPriority());
    }

    private void verifyInvalidCompactionScenario(StripeStoreFileManager manager, ArrayList<StoreFile> filesToCompact, ArrayList<StoreFile> filesToInsert) throws Exception {
        Collection allFiles = manager.getStorefiles();
        try {
            manager.addCompactionResults(filesToCompact, filesToInsert);
            Assert.fail((String)"Should have thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.verifyAllFiles(manager, allFiles);
    }

    private void verifyGetOrScanScenario(StripeStoreFileManager manager, boolean isGet, byte[] start, byte[] end, StoreFile ... results) throws Exception {
        this.verifyGetOrScanScenario(manager, isGet, start, end, Arrays.asList(results));
    }

    private void verifyGetOrScanScenario(StripeStoreFileManager manager, boolean isGet, byte[] start, byte[] end, Collection<StoreFile> results) throws Exception {
        start = start != null ? start : HConstants.EMPTY_START_ROW;
        end = end != null ? end : HConstants.EMPTY_END_ROW;
        Collection sfs = manager.getFilesForScanOrGet(start, true, end, true);
        Assert.assertEquals((long)results.size(), (long)sfs.size());
        for (StoreFile result : results) {
            Assert.assertTrue((boolean)sfs.contains(result));
        }
    }

    private void verifyAllFiles(StripeStoreFileManager manager, Collection<StoreFile> results) throws Exception {
        this.verifyGetOrScanScenario(manager, false, null, null, results);
    }

    private static MockStoreFile createFile(long size, long seqNum, byte[] startKey, byte[] endKey) throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path testFilePath = StoreFile.getUniqueFile((FileSystem)fs, (Path)CFDIR);
        fs.create(testFilePath).close();
        MockStoreFile sf = new MockStoreFile(TEST_UTIL, testFilePath, size, 0L, false, seqNum);
        if (startKey != null) {
            sf.setMetadataValue(StripeStoreFileManager.STRIPE_START_KEY, startKey);
        }
        if (endKey != null) {
            sf.setMetadataValue(StripeStoreFileManager.STRIPE_END_KEY, endKey);
        }
        return sf;
    }

    private static MockStoreFile createFile(long size, long seqNum) throws Exception {
        return TestStripeStoreFileManager.createFile(size, seqNum, null, null);
    }

    private static MockStoreFile createFile(byte[] startKey, byte[] endKey) throws Exception {
        return TestStripeStoreFileManager.createFile(0L, 0L, startKey, endKey);
    }

    private static MockStoreFile createFile() throws Exception {
        return TestStripeStoreFileManager.createFile(null, null);
    }

    private static StripeStoreFileManager createManager() throws Exception {
        return TestStripeStoreFileManager.createManager(new ArrayList<StoreFile>());
    }

    private static StripeStoreFileManager createManager(ArrayList<StoreFile> sfs) throws Exception {
        return TestStripeStoreFileManager.createManager(sfs, TEST_UTIL.getConfiguration());
    }

    private static StripeStoreFileManager createManager(ArrayList<StoreFile> sfs, Configuration conf) throws Exception {
        StripeStoreConfig config = new StripeStoreConfig(conf, (StoreConfigInformation)Mockito.mock(StoreConfigInformation.class));
        StripeStoreFileManager result = new StripeStoreFileManager(new KeyValue.KVComparator(), conf, config);
        result.loadFiles(sfs);
        return result;
    }

    private static ArrayList<StoreFile> al(StoreFile ... sfs) {
        return new ArrayList<StoreFile>(Arrays.asList(sfs));
    }

    private static ArrayList<StoreFile> flattenLists(ArrayList<StoreFile> ... sfls) {
        ArrayList<StoreFile> result = new ArrayList<StoreFile>();
        for (ArrayList<StoreFile> sfl : sfls) {
            result.addAll(sfl);
        }
        return result;
    }
}

