/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestStoreScannerClosure {
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    @Rule
    public TestName name = new TestName();
    private static final String CF_STR = "cf";
    private static HRegion region;
    private static final byte[] CF;
    static Configuration CONF;
    private static CacheConfig cacheConf;
    private static FileSystem fs;
    private static final HBaseTestingUtility TEST_UTIL;
    private ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, Integer.MAX_VALUE, Long.MAX_VALUE, KeepDeletedCells.FALSE, 0L, KeyValue.COMPARATOR);
    private static final byte[] fam;
    private static final KeyValue[] kvs;

    @BeforeClass
    public static void setUp() throws Exception {
        CONF = TEST_UTIL.getConfiguration();
        cacheConf = new CacheConfig(CONF);
        fs = TEST_UTIL.getTestFileSystem();
        TableName tableName = TableName.valueOf((String)"test");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(fam));
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        Path path = TEST_UTIL.getDataTestDir("test");
        region = HBaseTestingUtility.createRegionAndWAL(info, path, path, TEST_UTIL.getConfiguration(), htd);
    }

    @Test
    public void testScannerCloseAndUpdateReaders1() throws Exception {
        this.testScannerCloseAndUpdateReaderInternal(true, false);
    }

    @Test
    public void testScannerCloseAndUpdateReaders2() throws Exception {
        this.testScannerCloseAndUpdateReaderInternal(false, true);
    }

    private Path writeStoreFile() throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), "TestHFile");
        Path storeFilePath = new Path(storeFileParentDir, UUID.randomUUID().toString().replaceAll("-", ""));
        HFileContext meta = new HFileContextBuilder().withBlockSize(65536).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(CONF, cacheConf, fs).withFilePath(storeFilePath).withFileContext(meta).build();
        int rowLen = 32;
        Random RNG = new Random();
        for (int i = 0; i < 1000; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(RNG, i);
            byte[] v = RandomKeyValueUtil.randomValue(RNG);
            int cfLen = RNG.nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, RNG.nextLong(), TestStoreScannerClosure.generateKeyType(RNG), v, 0, v.length);
            writer.append((Cell)kv);
        }
        writer.close();
        return writer.getPath();
    }

    private static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". " + "Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    private StoreFile readStoreFile(Path storeFilePath, Configuration conf) throws Exception {
        StoreFile file = new StoreFile(fs, storeFilePath, conf, cacheConf, BloomType.NONE);
        return file;
    }

    private void testScannerCloseAndUpdateReaderInternal(final boolean awaitUpdate, final boolean awaitClose) throws IOException, InterruptedException {
        Path path = this.writeStoreFile();
        StoreFile file = null;
        final ArrayList<StoreFile> files = new ArrayList<StoreFile>();
        try {
            file = this.readStoreFile(path, CONF);
            files.add(file);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
        KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        try (final ExtendedStoreScanner scan = new ExtendedStoreScanner(region.getStore(fam), this.scanInfo, new Scan(), this.getCols("a", "d"), 100L);){
            Thread closeThread = new Thread(){

                @Override
                public void run() {
                    scan.close(awaitClose, true);
                }
            };
            closeThread.start();
            Thread updateThread = new Thread(){

                @Override
                public void run() {
                    try {
                        scan.updateReaders(awaitUpdate, files, Collections.emptyList());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            updateThread.start();
            closeThread.join();
            updateThread.join();
            if (file.getReader() != null) {
                int refCount = file.getReader().getRefCount();
                Assert.assertTrue((String)"The store scanner count should be 0", (refCount == 0 ? 1 : 0) != 0);
            }
        }
    }

    NavigableSet<byte[]> getCols(String ... strCols) {
        TreeSet<byte[]> cols = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (String col : strCols) {
            byte[] bytes = Bytes.toBytes((String)col);
            cols.add(bytes);
        }
        return cols;
    }

    static {
        CF = Bytes.toBytes((String)CF_STR);
        CONF = HBaseConfiguration.create();
        TEST_UTIL = new HBaseTestingUtility();
        fam = Bytes.toBytes((String)"cf_1");
        kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"f", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"h", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"i", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
    }

    private static class ExtendedStoreScanner
    extends StoreScanner {
        private CountDownLatch latch = new CountDownLatch(1);

        public ExtendedStoreScanner(Store store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
            super(store, scanInfo, scan, columns, readPt);
        }

        public void updateReaders(boolean await, List<StoreFile> sfs, List<KeyValueScanner> memStoreScanners) throws IOException {
            if (await) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            super.updateReaders(sfs, memStoreScanners);
            if (!await) {
                this.latch.countDown();
            }
        }

        public void close(boolean await, boolean dummy) {
            if (await) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            super.close();
            if (!await) {
                this.latch.countDown();
            }
        }
    }
}

