/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScannerCursor {
    private static final Log LOG = LogFactory.getLog(TestScannerCursor.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Table TABLE = null;
    private static TableName TABLE_NAME = TableName.valueOf((String)"TestScannerCursor");
    private static int NUM_ROWS = 5;
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[][] ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
    private static int NUM_FAMILIES = 2;
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
    private static int NUM_QUALIFIERS = 2;
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
    private static int VALUE_SIZE = 10;
    private static byte[] VALUE = Bytes.createMaxByteArray((int)VALUE_SIZE);
    private static final int TIMEOUT = 4000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.timeout.period", 4000);
        conf.setInt("hbase.rpc.timeout", 4000);
        conf.setLong("hbase.cells.scanned.per.heartbeat.check", 1L);
        TEST_UTIL.startMiniCluster(1);
        TABLE = TestScannerCursor.createTestTable(TABLE_NAME, ROWS, FAMILIES, QUALIFIERS, VALUE);
    }

    static Table createTestTable(TableName name, byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] cellValue) throws IOException {
        HTable ht = TEST_UTIL.createTable(name, families);
        ArrayList<Put> puts = TestScannerCursor.createPuts(rows, families, qualifiers, cellValue);
        ht.put(puts);
        return ht;
    }

    static ArrayList<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < rows.length; ++row) {
            Put put = new Put(rows[row]);
            for (int fam = 0; fam < families.length; ++fam) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(rows[row], families[fam], qualifiers[qual], (long)qual, value);
                    put.add((Cell)kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHeartbeatWithSparseFilter() throws Exception {
        Scan scan = new Scan();
        scan.setMaxResultSize(Long.MAX_VALUE);
        scan.setCaching(Integer.MAX_VALUE);
        scan.setNeedCursorResult(true);
        scan.setAllowPartialResults(true);
        scan.setFilter((Filter)new SparseFilter());
        try (ResultScanner scanner = TABLE.getScanner(scan);){
            Result r;
            int num = 0;
            while ((r = scanner.next()) != null) {
                if (num < (NUM_ROWS - 1) * NUM_FAMILIES * NUM_QUALIFIERS) {
                    Assert.assertTrue((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getCursor().getRow());
                } else {
                    Assert.assertFalse((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getRow());
                }
                ++num;
            }
        }
    }

    @Test
    public void testSizeLimit() throws IOException {
        Scan scan = new Scan();
        scan.setMaxResultSize(1L);
        scan.setCaching(Integer.MAX_VALUE);
        scan.setNeedCursorResult(true);
        try (ResultScanner scanner = TABLE.getScanner(scan);){
            Result r;
            int num = 0;
            while ((r = scanner.next()) != null) {
                if (num % (NUM_FAMILIES * NUM_QUALIFIERS) != NUM_FAMILIES * NUM_QUALIFIERS - 1) {
                    Assert.assertTrue((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getCursor().getRow());
                } else {
                    Assert.assertFalse((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getRow());
                }
                ++num;
            }
        }
    }

    public static class SparseFilter
    extends FilterBase {
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            Threads.sleep((long)2100L);
            return Bytes.equals((byte[])CellUtil.cloneRow((Cell)v), (byte[])ROWS[NUM_ROWS - 1]) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
        }

        public static Filter parseFrom(byte[] pbBytes) {
            return new SparseFilter();
        }
    }
}

