/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionInterrupt {
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestRegionInterrupt.class);
    static final byte[] FAMILY = Bytes.toBytes((String)"info");
    static long sleepTime;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.retries.number", 1);
        conf.setClass("hbase.hregion.impl", InterruptInterceptingHRegion.class, Region.class);
        conf.setBoolean("hbase.regionserver.close.wait.abort", true);
        long waitInterval = conf.getLong("hbase.regionserver.close.wait.interval.ms", 10000L);
        sleepTime = waitInterval * 2L;
        conf.setLong("hbase.regionserver.close.wait.time.ms", sleepTime * 2L);
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCloseInterruptScanning() throws Exception {
        TableName tableName = this.name.getTableName();
        LOG.info((Object)("Creating table " + tableName));
        try (HTable table = TEST_UTIL.createTable(tableName, FAMILY);){
            TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
            TEST_UTIL.loadTable((Table)table, FAMILY);
            AtomicBoolean expectedExceptionCaught = new AtomicBoolean(false);
            Thread scanner = new Thread(new Runnable((Table)table, expectedExceptionCaught){
                final /* synthetic */ Table val$table;
                final /* synthetic */ AtomicBoolean val$expectedExceptionCaught;
                {
                    this.val$table = table;
                    this.val$expectedExceptionCaught = atomicBoolean;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Scan scan = new Scan();
                    scan.addFamily(FAMILY);
                    scan.setFilter((Filter)new DelayingFilter());
                    try {
                        LOG.info((Object)"Starting scan");
                        try (ResultScanner rs = this.val$table.getScanner(scan);){
                            Result r;
                            do {
                                if ((r = rs.next()) == null) continue;
                                LOG.info((Object)("Scanned row " + Bytes.toStringBinary((byte[])r.getRow())));
                            } while (r != null);
                        }
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Scanner caught exception", (Throwable)e);
                        this.val$expectedExceptionCaught.set(true);
                    }
                    finally {
                        LOG.info((Object)"Finished scan");
                    }
                }
            });
            scanner.start();
            LOG.info((Object)"Waiting for scanner to start");
            Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return DelayingFilter.isSleeping();
                }
            });
            LOG.info((Object)("Offlining table " + tableName));
            TEST_UTIL.getHBaseAdmin().disableTable(tableName);
            scanner.join();
            Assert.assertTrue((String)"Region operations were not interrupted", (boolean)InterruptInterceptingHRegion.wasInterrupted());
            Assert.assertTrue((String)"Scanner did not catch expected exception", (boolean)expectedExceptionCaught.get());
        }
    }

    @Test
    public void testCloseInterruptMutation() throws Exception {
        TableName tableName = this.name.getTableName();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(FAMILY));
        htd.addCoprocessor(MutationDelayingCoprocessor.class.getName());
        LOG.info((Object)("Creating table " + tableName));
        admin.createTable(htd);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        LOG.info((Object)("Starting writes to table " + tableName));
        int NUM_ROWS = 100;
        AtomicBoolean expectedExceptionCaught = new AtomicBoolean(false);
        Thread inserter = new Thread(new Runnable((Admin)admin, tableName, expectedExceptionCaught){
            final /* synthetic */ Admin val$admin;
            final /* synthetic */ TableName val$tableName;
            final /* synthetic */ AtomicBoolean val$expectedExceptionCaught;
            {
                this.val$admin = admin;
                this.val$tableName = tableName;
                this.val$expectedExceptionCaught = atomicBoolean;
            }

            @Override
            public void run() {
                try (BufferedMutator t = this.val$admin.getConnection().getBufferedMutator(this.val$tableName);){
                    for (int i = 0; i < 100; ++i) {
                        LOG.info((Object)("Writing row " + i + " to " + this.val$tableName));
                        byte[] value = new byte[10];
                        byte[] row = Bytes.toBytes((String)Integer.toString(i));
                        Bytes.random((byte[])value);
                        t.mutate((Mutation)new Put(row).addColumn(FAMILY, HConstants.EMPTY_BYTE_ARRAY, value));
                        t.flush();
                    }
                }
                catch (IOException e) {
                    LOG.info((Object)"Inserter caught exception", (Throwable)e);
                    this.val$expectedExceptionCaught.set(true);
                }
            }
        });
        inserter.start();
        LOG.info((Object)"Waiting for mutations to start");
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return MutationDelayingCoprocessor.isSleeping();
            }
        });
        LOG.info((Object)("Offlining table " + tableName));
        admin.disableTable(tableName);
        inserter.join();
        Assert.assertTrue((String)"Region operations were not interrupted", (boolean)InterruptInterceptingHRegion.wasInterrupted());
        Assert.assertTrue((String)"Inserter did not catch expected exception", (boolean)expectedExceptionCaught.get());
    }

    public static class MutationDelayingCoprocessor
    extends BaseRegionObserver {
        static volatile boolean sleeping = false;

        public static boolean isSleeping() {
            return sleeping;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSleep(Region.Operation op) {
            LOG.info((Object)("Starting sleep for " + op));
            sleeping = true;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info((Object)("Interrupted during " + op));
            }
            finally {
                LOG.info((Object)"Done");
                sleeping = false;
            }
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            this.doSleep(Region.Operation.PUT);
            super.prePut(c, put, edit, durability);
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
            this.doSleep(Region.Operation.DELETE);
            super.preDelete(c, delete, edit, durability);
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
            this.doSleep(Region.Operation.APPEND);
            return super.preAppend(c, append);
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
            this.doSleep(Region.Operation.INCREMENT);
            return super.preIncrement(c, increment);
        }
    }

    public static class DelayingFilter
    extends FilterBase {
        static volatile boolean sleeping = false;

        public static boolean isSleeping() {
            return sleeping;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            LOG.info((Object)("Starting sleep on " + v));
            sleeping = true;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info((Object)("Interrupted during sleep on " + v));
            }
            finally {
                LOG.info((Object)("Done sleep on " + v));
                sleeping = false;
            }
            return Filter.ReturnCode.INCLUDE;
        }

        public static DelayingFilter parseFrom(byte[] pbBytes) throws DeserializationException {
            return new DelayingFilter();
        }
    }

    public static class InterruptInterceptingHRegion
    extends HRegion {
        private static boolean interrupted = false;

        public static boolean wasInterrupted() {
            return interrupted;
        }

        public InterruptInterceptingHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, conf, regionInfo, htd, rsServices);
        }

        public InterruptInterceptingHRegion(HRegionFileSystem fs, WAL wal, Configuration conf, HTableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, conf, htd, rsServices);
        }

        void checkInterrupt() throws NotServingRegionException, InterruptedIOException {
            try {
                super.checkInterrupt();
            }
            catch (InterruptedIOException | NotServingRegionException e) {
                interrupted = true;
                throw e;
            }
        }

        IOException throwOnInterrupt(Throwable t) {
            interrupted = true;
            return super.throwOnInterrupt(t);
        }
    }
}

