/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import com.google.common.collect.Iterables;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestQuotaAdmin {
    private static final Log LOG = LogFactory.getLog(TestQuotaAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testThrottleType() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)12L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        if (throttle.getSoftLimit() == 6L) {
                            Assert.assertEquals((Object)ThrottleType.READ_NUMBER, (Object)throttle.getThrottleType());
                        } else if (throttle.getSoftLimit() == 12L) {
                            Assert.assertEquals((Object)ThrottleType.WRITE_NUMBER, (Object)throttle.getThrottleType());
                        } else {
                            Assert.fail((String)"should not come here, because don't set quota with this limit");
                        }
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + settings.getQuotaType()));
            }
            Assert.assertEquals((long)2L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        this.assertNumResults(0, null);
    }

    @Test
    public void testSimpleScan() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                LOG.debug((Object)settings);
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals((long)6L, (long)throttle.getSoftLimit());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + settings.getQuotaType()));
            }
            Assert.assertEquals((long)1L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        this.assertNumResults(0, null);
    }

    @Test
    public void testQuotaRetrieverFilter() throws Exception {
        String[] users;
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        TableName[] tables = new TableName[]{TableName.valueOf((String)"T0"), TableName.valueOf((String)"T01"), TableName.valueOf((String)"NS0:T2")};
        String[] namespaces = new String[]{"NS0", "NS01", "NS2"};
        for (String string : users = new String[]{"User0", "User01", "User2"}) {
            admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)1L, (TimeUnit)TimeUnit.MINUTES));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (TableName)tableName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)2L, (TimeUnit)TimeUnit.MINUTES));
            }
            for (String string2 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (String)string2, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)3L, (TimeUnit)TimeUnit.MINUTES));
            }
        }
        this.assertNumResults(21, null);
        for (String string : tables) {
            admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        }
        this.assertNumResults(24, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)5L, (TimeUnit)TimeUnit.MINUTES));
        }
        this.assertNumResults(27, null);
        this.assertNumResults(7, new QuotaFilter().setUserFilter("User0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User"));
        this.assertNumResults(21, new QuotaFilter().setUserFilter("User.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("NS.*"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setTableFilter("T"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS"));
        this.assertNumResults(9, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS.*"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0").setNamespaceFilter("NS0"));
        this.assertNumResults(1, new QuotaFilter().setTableFilter("T0"));
        this.assertNumResults(0, new QuotaFilter().setTableFilter("T"));
        this.assertNumResults(2, new QuotaFilter().setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setTableFilter(".*T.*"));
        this.assertNumResults(1, new QuotaFilter().setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setNamespaceFilter("NS"));
        this.assertNumResults(3, new QuotaFilter().setNamespaceFilter("NS.*"));
        for (String string : users) {
            admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (TableName)tableName));
            }
            for (String string3 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (String)string3));
            }
        }
        this.assertNumResults(6, null);
        for (String string : tables) {
            admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)string));
        }
        this.assertNumResults(3, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)string));
        }
        this.assertNumResults(0, null);
    }

    private void assertNumResults(int expected, QuotaFilter filter) throws Exception {
        Assert.assertEquals((long)expected, (long)this.countResults(filter));
    }

    @Test
    public void testSetGetRemoveRPCQuota() throws Exception {
        this.testSetGetRemoveRPCQuota(ThrottleType.REQUEST_SIZE);
        this.testSetGetRemoveRPCQuota(ThrottleType.REQUEST_CAPACITY_UNIT);
    }

    private void testSetGetRemoveRPCQuota(ThrottleType throttleType) throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        TableName tn = TableName.valueOf((String)"sq_table1");
        QuotaSettings settings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)throttleType, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        this.verifyRecordPresentInQuotaTable(throttleType, 2L, TimeUnit.HOURS);
        this.verifyFetchableViaAPI((Admin)admin, throttleType, 2L, TimeUnit.HOURS);
        QuotaSettings removeQuota = QuotaSettingsFactory.unthrottleTable((TableName)tn);
        admin.setQuota(removeQuota);
        this.verifyRecordNotPresentInQuotaTable();
        this.verifyNotFetchableViaAPI((Admin)admin);
    }

    @Test
    public void testSetModifyRemoveRPCQuota() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        TableName tn = TableName.valueOf((String)"sq_table1");
        QuotaSettings settings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_SIZE, 2L, TimeUnit.HOURS);
        this.verifyFetchableViaAPI((Admin)admin, ThrottleType.REQUEST_SIZE, 2L, TimeUnit.HOURS);
        QuotaSettings newSettings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)3L, (TimeUnit)TimeUnit.DAYS);
        admin.setQuota(newSettings);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_SIZE, 3L, TimeUnit.DAYS);
        this.verifyFetchableViaAPI((Admin)admin, ThrottleType.REQUEST_SIZE, 3L, TimeUnit.DAYS);
        QuotaSettings removeQuota = QuotaSettingsFactory.unthrottleTable((TableName)tn);
        admin.setQuota(removeQuota);
        this.verifyRecordNotPresentInQuotaTable();
        this.verifyNotFetchableViaAPI((Admin)admin);
    }

    private void verifyRecordPresentInQuotaTable(ThrottleType type, long limit, TimeUnit tu) throws Exception {
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertRPCQuota(type, limit, tu, cells.current());
        }
    }

    private void verifyRecordNotPresentInQuotaTable() throws Exception {
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)scanner.next());
        }
    }

    private void verifyFetchableViaAPI(Admin admin, ThrottleType type, long limit, TimeUnit tu) throws Exception {
        try (QuotaRetriever quotaScanner = QuotaRetriever.open((Configuration)admin.getConfiguration());){
            this.assertRPCQuota(type, limit, tu, (QuotaSettings)Iterables.getOnlyElement((Iterable)quotaScanner));
        }
    }

    private void verifyNotFetchableViaAPI(Admin admin) throws Exception {
        try (QuotaRetriever quotaScanner = QuotaRetriever.open((Configuration)admin.getConfiguration());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)quotaScanner.next());
        }
    }

    private void assertRPCQuota(ThrottleType type, long limit, TimeUnit tu, Cell cell) throws Exception {
        QuotaProtos.Quotas q = QuotaTableUtil.quotasFromData((byte[])cell.getValue());
        Assert.assertTrue((String)"Quota should have rpc quota defined", (boolean)q.hasThrottle());
        QuotaProtos.Throttle rpcQuota = q.getThrottle();
        QuotaProtos.TimedQuota t = null;
        switch (type) {
            case REQUEST_SIZE: {
                Assert.assertTrue((boolean)rpcQuota.hasReqSize());
                t = rpcQuota.getReqSize();
                break;
            }
            case READ_NUMBER: {
                Assert.assertTrue((boolean)rpcQuota.hasReadNum());
                t = rpcQuota.getReadNum();
                break;
            }
            case READ_SIZE: {
                Assert.assertTrue((boolean)rpcQuota.hasReadSize());
                t = rpcQuota.getReadSize();
                break;
            }
            case REQUEST_NUMBER: {
                Assert.assertTrue((boolean)rpcQuota.hasReqNum());
                t = rpcQuota.getReqNum();
                break;
            }
            case WRITE_NUMBER: {
                Assert.assertTrue((boolean)rpcQuota.hasWriteNum());
                t = rpcQuota.getWriteNum();
                break;
            }
            case WRITE_SIZE: {
                Assert.assertTrue((boolean)rpcQuota.hasWriteSize());
                t = rpcQuota.getWriteSize();
                break;
            }
            case REQUEST_CAPACITY_UNIT: {
                Assert.assertTrue((boolean)rpcQuota.hasReqCapacityUnit());
                t = rpcQuota.getReqCapacityUnit();
                break;
            }
            case READ_CAPACITY_UNIT: {
                Assert.assertTrue((boolean)rpcQuota.hasReadCapacityUnit());
                t = rpcQuota.getReadCapacityUnit();
                break;
            }
            case WRITE_CAPACITY_UNIT: {
                Assert.assertTrue((boolean)rpcQuota.hasWriteCapacityUnit());
                t = rpcQuota.getWriteCapacityUnit();
                break;
            }
        }
        Assert.assertEquals((long)t.getSoftLimit(), (long)limit);
        Assert.assertEquals((Object)t.getTimeUnit(), (Object)ProtobufUtil.toProtoTimeUnit((TimeUnit)tu));
    }

    private void assertRPCQuota(ThrottleType type, long limit, TimeUnit tu, QuotaSettings actualSettings) throws Exception {
        Assert.assertTrue((String)("The actual QuotaSettings was not an instance of " + ThrottleSettings.class + " but of " + actualSettings.getClass()), (boolean)(actualSettings instanceof ThrottleSettings));
        QuotaProtos.ThrottleRequest throttleRequest = ((ThrottleSettings)actualSettings).getProto();
        Assert.assertEquals((long)limit, (long)throttleRequest.getTimedQuota().getSoftLimit());
        Assert.assertEquals((Object)ProtobufUtil.toProtoTimeUnit((TimeUnit)tu), (Object)throttleRequest.getTimedQuota().getTimeUnit());
        Assert.assertEquals((Object)ProtobufUtil.toProtoThrottleType((ThrottleType)type), (Object)throttleRequest.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countResults(QuotaFilter filter) throws Exception {
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration(), (QuotaFilter)filter);){
            int count = 0;
            for (QuotaSettings settings : scanner) {
                LOG.debug((Object)settings);
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

