/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.procedure.MasterProcedureManagerHost;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveTestingUtil;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestCatalogJanitor {
    private static final Log LOG = LogFactory.getLog(TestCatalogJanitor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanParent() throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        try {
            MockMasterServices services = new MockMasterServices(server);
            CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"table"));
            htd.addFamily(new HColumnDescriptor("f"));
            HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
            HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
            HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
            Result r = this.createResult(parent, splita, splitb);
            Path rootdir = services.getMasterFileSystem().getRootDir();
            Path tabledir = FSUtils.getTableDir((Path)rootdir, (TableName)htd.getTableName());
            Path storedir = HStore.getStoreHomedir((Path)tabledir, (HRegionInfo)splita, (byte[])htd.getColumnFamilies()[0].getName());
            Reference ref = Reference.createTopReference((byte[])Bytes.toBytes((String)"ccc"));
            long now = System.currentTimeMillis();
            Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
            FileSystem fs = services.getMasterFileSystem().getFileSystem();
            Path path = ref.write(fs, p);
            Assert.assertTrue((boolean)fs.exists(path));
            Assert.assertFalse((boolean)janitor.cleanParent(parent, r));
            Assert.assertTrue((boolean)fs.delete(p, true));
            Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        }
        finally {
            server.stop("shutdown");
        }
    }

    @Test
    public void testParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst("testParentCleanedEvenIfDaughterGoneFirst", Bytes.toBytes((String)"eee"));
    }

    @Test
    public void testLastParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst("testLastParentCleanedEvenIfDaughterGoneFirst", new byte[0]);
    }

    private void parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(String rootDir, byte[] lastEndKey) throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, rootDir);
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        HRegionInfo splitab = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ccc"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splitba = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        HRegionInfo splitbb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ddd"), lastEndKey);
        TreeMap<HRegionInfo, Result> regions = new TreeMap<HRegionInfo, Result>((Comparator<HRegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        regions.put(parent, this.createResult(parent, splita, splitb));
        regions.put(splitb, this.createResult(splitb, splitba, splitbb));
        regions.put(splita, this.createResult(splita, splitaa, splitab));
        int index = 0;
        for (Map.Entry e : regions.entrySet()) {
            if (index == 0) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(parent.getEncodedName()));
            } else if (index == 1) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splita.getEncodedName()));
            } else if (index == 2) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splitb.getEncodedName()));
            }
            ++index;
        }
        Path splitaRef = this.createReferences(services, htd, parent, splita, Bytes.toBytes((String)"ccc"), false);
        Assert.assertFalse((boolean)janitor.cleanParent(parent, (Result)regions.get(parent)));
        Assert.assertTrue((boolean)janitor.cleanParent(splitb, (Result)regions.get(splitb)));
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Path splitaaRef = this.createReferences(services, htd, splita, splitaa, Bytes.toBytes((String)"bbb"), false);
        Path splitabRef = this.createReferences(services, htd, splita, splitab, Bytes.toBytes((String)"bbb"), true);
        Assert.assertFalse((boolean)janitor.cleanParent(splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)fs.delete(splitaaRef, true));
        Assert.assertTrue((boolean)fs.delete(splitabRef, true));
        Assert.assertTrue((boolean)janitor.cleanParent(splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)janitor.cleanParent(parent, (Result)regions.get(parent)));
        services.stop("test finished");
        janitor.cancel(true);
    }

    @Test
    public void testScanDoesNotCleanRegionsWithExistingParents() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testScanDoesNotCleanRegionsWithExistingParents");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), new byte[0], true);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"), true);
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), false);
        HRegionInfo splitab = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), false);
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ccc"), new byte[0]);
        Thread.sleep(1001L);
        TreeMap<HRegionInfo, Result> splitParents = new TreeMap<HRegionInfo, Result>((Comparator<HRegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        splitParents.put(parent, this.createResult(parent, splita, splitb));
        splita.setOffline(true);
        splitParents.put(splita, this.createResult(splita, splitaa, splitab));
        TreeMap mergedRegions = new TreeMap();
        CatalogJanitor janitor = (CatalogJanitor)Mockito.spy((Object)new CatalogJanitor((Server)server, (MasterServices)services));
        ((CatalogJanitor)Mockito.doReturn((Object)new Triple((Object)10, mergedRegions, splitParents)).when((Object)janitor)).getMergedRegionsAndSplitParents();
        Path splitaRef = this.createReferences(services, htd, parent, splita, Bytes.toBytes((String)"ccc"), false);
        Assert.assertEquals((long)0L, (long)janitor.scan());
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Assert.assertEquals((long)2L, (long)janitor.scan());
        services.stop("test finished");
        janitor.cancel(true);
    }

    @Test
    public void testSplitParentFirstComparator() {
        CatalogJanitor.SplitParentFirstComparator comp = new CatalogJanitor.SplitParentFirstComparator();
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo rootRegion = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, true);
        HRegionInfo firstRegion = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"bbb"), true);
        HRegionInfo lastRegion = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"bbb"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare(rootRegion, rootRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, lastRegion) < 0 ? 1 : 0) != 0);
        HRegionInfo firstRegiona = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"aaa"), true);
        HRegionInfo firstRegionb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), true);
        HRegionInfo lastRegiona = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ddd"), true);
        HRegionInfo lastRegionb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ddd"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare(firstRegiona, firstRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, firstRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegionb, lastRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, lastRegionb) < 0 ? 1 : 0) != 0);
        HRegionInfo lastRegionaa = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), false);
        HRegionInfo lastRegionab = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), false);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionaa) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionab) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegionaa, lastRegionab) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testArchiveOldRegion() throws Exception {
        String table = "table";
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)table));
        htd.addFamily(new HColumnDescriptor("f"));
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result parentMetaRow = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Path rootdir = services.getMasterFileSystem().getRootDir();
        FSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = FSUtils.getTableDir((Path)rootdir, (TableName)htd.getTableName());
        Path storedir = HStore.getStoreHomedir((Path)tabledir, (HRegionInfo)parent, (byte[])htd.getColumnFamilies()[0].getName());
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)services.getConfiguration(), (HRegionInfo)parent, (Path)tabledir, (byte[])htd.getColumnFamilies()[0].getName());
        LOG.debug((Object)("Table dir:" + tabledir));
        LOG.debug((Object)("Store dir:" + storedir));
        LOG.debug((Object)("Store archive dir:" + storeArchive));
        FileStatus[] mockFiles = this.addMockStoreFiles(2, services, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        int index = 0;
        for (FileStatus file : storeFiles) {
            LOG.debug((Object)("Have store file:" + file.getPath()));
            Assert.assertEquals((String)"Got unexpected store file", (Object)mockFiles[index].getPath(), (Object)storeFiles[index].getPath());
            ++index;
        }
        Assert.assertTrue((boolean)janitor.cleanParent(parent, parentMetaRow));
        LOG.debug((Object)"Finished cleanup of parent region");
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        this.logFiles("archived files", storeFiles);
        this.logFiles("archived files", archivedStoreFiles);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        FSUtils.delete((FileSystem)fs, (Path)rootdir, (boolean)true);
        services.stop("Test finished");
        server.stop("Test finished");
        janitor.cancel(true);
    }

    private void logFiles(String description, FileStatus[] storeFiles) {
        LOG.debug((Object)("Current " + description + ": "));
        for (FileStatus file : storeFiles) {
            LOG.debug((Object)file.getPath());
        }
    }

    @Test
    public void testDuplicateHFileResolution() throws Exception {
        String table = "table";
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)table));
        htd.addFamily(new HColumnDescriptor("f"));
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result r = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Path rootdir = services.getMasterFileSystem().getRootDir();
        FSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = FSUtils.getTableDir((Path)rootdir, (TableName)parent.getTable());
        Path storedir = HStore.getStoreHomedir((Path)tabledir, (HRegionInfo)parent, (byte[])htd.getColumnFamilies()[0].getName());
        System.out.println("Old root:" + rootdir);
        System.out.println("Old table:" + tabledir);
        System.out.println("Old store:" + storedir);
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)services.getConfiguration(), (HRegionInfo)parent, (Path)tabledir, (byte[])htd.getColumnFamilies()[0].getName());
        System.out.println("Old archive:" + storeArchive);
        this.addMockStoreFiles(2, services, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        this.addMockStoreFiles(2, services, storedir);
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs, true);
        services.stop("Test finished");
        server.stop("shutdown");
        janitor.cancel(true);
    }

    @Test
    public void testAlreadyRunningStatus() throws Exception {
        int i;
        int numberOfThreads = 2;
        final ArrayList gcValues = new ArrayList();
        Thread[] threads = new Thread[numberOfThreads];
        HBaseTestingUtility hBaseTestingUtility = new HBaseTestingUtility();
        hBaseTestingUtility.getConfiguration().setInt("hbase.client.retries.number", 5);
        MockServer server = new MockServer(hBaseTestingUtility);
        MockMasterServices services = new MockMasterServices(server);
        final CatalogJanitor catalogJanitor = new CatalogJanitor((Server)server, (MasterServices)services);
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        gcValues.add(catalogJanitor.scan());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((String)"One janitor.scan() call should have returned -1", (boolean)gcValues.contains(-1));
    }

    private FileStatus[] addMockStoreFiles(int count, MasterServices services, Path storedir) throws IOException {
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        fs.mkdirs(storedir);
        for (int i = 0; i < count; ++i) {
            Path storeFile = new Path(storedir, "_store" + i);
            FSDataOutputStream dos = fs.create(storeFile, true);
            dos.writeBytes("Some data: " + i);
            dos.close();
        }
        LOG.debug((Object)("Adding " + count + " store files to the storedir:" + storedir));
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertEquals((String)"Didn't have expected store files", (long)count, (long)storeFiles.length);
        return storeFiles;
    }

    private String setRootDirAndCleanIt(HBaseTestingUtility htu, String subdir) throws IOException {
        Path testdir = htu.getDataTestDir(subdir);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        if (fs.exists(testdir)) {
            Assert.assertTrue((boolean)fs.delete(testdir, true));
        }
        FSUtils.setRootDir((Configuration)htu.getConfiguration(), (Path)testdir);
        return FSUtils.getRootDir((Configuration)htu.getConfiguration()).toString();
    }

    private Path createReferences(MasterServices services, HTableDescriptor htd, HRegionInfo parent, HRegionInfo daughter, byte[] midkey, boolean top) throws IOException {
        Path rootdir = services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir((Path)rootdir, (TableName)parent.getTable());
        Path storedir = HStore.getStoreHomedir((Path)tabledir, (HRegionInfo)daughter, (byte[])htd.getColumnFamilies()[0].getName());
        Reference ref = top ? Reference.createTopReference((byte[])midkey) : Reference.createBottomReference((byte[])midkey);
        long now = System.currentTimeMillis();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        ref.write(fs, p);
        return p;
    }

    private Result createResult(HRegionInfo parent, HRegionInfo a, HRegionInfo b) throws IOException {
        return MetaMockingUtil.getMetaTableRowResult(parent, null, a, b);
    }

    private HTableDescriptor createHTableDescriptor() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"t"));
        htd.addFamily(new HColumnDescriptor("f"));
        return htd;
    }

    private ClientProtos.MultiResponse buildMultiResponse(ClientProtos.MultiRequest req) {
        ClientProtos.MultiResponse.Builder builder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        ClientProtos.ResultOrException.Builder roeBuilder = ClientProtos.ResultOrException.newBuilder();
        for (ClientProtos.RegionAction regionAction : req.getRegionActionList()) {
            regionActionResultBuilder.clear();
            for (ClientProtos.Action action : regionAction.getActionList()) {
                roeBuilder.clear();
                roeBuilder.setResult(ClientProtos.Result.getDefaultInstance());
                roeBuilder.setIndex(action.getIndex());
                regionActionResultBuilder.addResultOrException(roeBuilder.build());
            }
            builder.addRegionActionResult(regionActionResultBuilder.build());
        }
        return builder.build();
    }

    class MockMasterServices
    implements MasterServices {
        private final MasterFileSystem mfs;
        private final AssignmentManager asm;
        private final ServerManager sm;
        private boolean stopped = false;

        MockMasterServices(Server server) throws IOException {
            this.mfs = new MasterFileSystem(server, (MasterServices)this);
            this.asm = (AssignmentManager)Mockito.mock(AssignmentManager.class);
            this.sm = (ServerManager)Mockito.mock(ServerManager.class);
        }

        public void checkTableModifiable(TableName tableName) throws IOException {
        }

        public long createTable(HTableDescriptor desc, byte[][] splitKeys, long nonceGroup, long nonce) throws IOException {
            return -1L;
        }

        public long createSystemTable(HTableDescriptor hTableDescriptor) throws IOException {
            return -1L;
        }

        public SnapshotManager getSnapshotManager() {
            return null;
        }

        public MasterProcedureManagerHost getMasterProcedureManagerHost() {
            return null;
        }

        public AssignmentManager getAssignmentManager() {
            return this.asm;
        }

        public ExecutorService getExecutorService() {
            return null;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public MasterFileSystem getMasterFileSystem() {
            return this.mfs;
        }

        public MasterCoprocessorHost getMasterCoprocessorHost() {
            return null;
        }

        public MasterQuotaManager getMasterQuotaManager() {
            return null;
        }

        public ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
            return null;
        }

        public ServerManager getServerManager() {
            return this.sm;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public Configuration getConfiguration() {
            return this.mfs.conf;
        }

        public ServerName getServerName() {
            return null;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public TableDescriptors getTableDescriptors() {
            return new TableDescriptors(){

                public HTableDescriptor remove(TableName tablename) throws IOException {
                    return null;
                }

                public Map<String, HTableDescriptor> getAll() throws IOException {
                    return null;
                }

                public HTableDescriptor get(TableName tablename) throws IOException {
                    return TestCatalogJanitor.this.createHTableDescriptor();
                }

                public Map<String, HTableDescriptor> getByNamespace(String name) throws IOException {
                    return null;
                }

                public void add(HTableDescriptor htd) throws IOException {
                }

                public void setCacheOn() throws IOException {
                }

                public void setCacheOff() throws IOException {
                }
            };
        }

        public boolean isServerCrashProcessingEnabled() {
            return true;
        }

        public boolean registerService(Service instance) {
            return false;
        }

        public void createNamespace(NamespaceDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        }

        public void createNamespaceSync(NamespaceDescriptor descriptor, long nonceGroup, long nonce, boolean executeCoprocessor) throws IOException {
        }

        public void modifyNamespace(NamespaceDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        }

        public void deleteNamespace(String name, long nonceGroup, long nonce) throws IOException {
        }

        public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
            return null;
        }

        public List<String> listNamespaces() throws IOException {
            return null;
        }

        public List<NamespaceDescriptor> listNamespaceDescriptors() throws IOException {
            return null;
        }

        public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
            return false;
        }

        public List<ProcedureInfo> listProcedures() throws IOException {
            return null;
        }

        public List<HTableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
            return null;
        }

        public List<TableName> listTableNamesByNamespace(String name) throws IOException {
            return null;
        }

        public long deleteTable(TableName tableName, long nonceGroup, long nonce) throws IOException {
            return -1L;
        }

        public void truncateTable(TableName tableName, boolean preserveSplits, long nonceGroup, long nonce) throws IOException {
        }

        public void modifyTable(TableName tableName, HTableDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        }

        public long enableTable(TableName tableName, long nonceGroup, long nonce) throws IOException {
            return -1L;
        }

        public LoadBalancer getLoadBalancer() {
            return null;
        }

        public long disableTable(TableName tableName, long nonceGroup, long nonce) throws IOException {
            return -1L;
        }

        public void addColumn(TableName tableName, HColumnDescriptor columnDescriptor, long nonceGroup, long nonce) throws IOException {
        }

        public void modifyColumn(TableName tableName, HColumnDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        }

        public void deleteColumn(TableName tableName, byte[] columnName, long nonceGroup, long nonce) throws IOException {
        }

        public TableLockManager getTableLockManager() {
            return null;
        }

        public TableNamespaceManager getTableNamespaceManager() {
            return null;
        }

        public void dispatchMergingRegions(HRegionInfo region_a, HRegionInfo region_b, boolean forcible, User user) throws IOException {
        }

        public boolean isInitialized() {
            return false;
        }

        public boolean isInMaintenanceMode() {
            return false;
        }

        public long getLastMajorCompactionTimestamp(TableName table) throws IOException {
            return 0L;
        }

        public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
            return 0L;
        }

        public String getRegionServerVersion(ServerName sn) {
            return null;
        }

        public void checkIfShouldMoveSystemRegionAsync() {
        }
    }

    class MockServer
    implements Server {
        private final ClusterConnection connection;
        private final Configuration c;

        MockServer(HBaseTestingUtility htu) throws NotAllMetaRegionsOnlineException, IOException, InterruptedException {
            this.c = htu.getConfiguration();
            ClientProtos.ClientService.BlockingInterface ri = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
            ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
            builder.setProcessed(true);
            try {
                Mockito.when((Object)ri.mutate((RpcController)Mockito.any(), (ClientProtos.MutateRequest)Mockito.any())).thenReturn((Object)builder.build());
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
            try {
                Mockito.when((Object)ri.multi((RpcController)Mockito.any(), (ClientProtos.MultiRequest)Mockito.any())).thenAnswer((Answer)new Answer<ClientProtos.MultiResponse>(){

                    public ClientProtos.MultiResponse answer(InvocationOnMock invocation) throws Throwable {
                        return TestCatalogJanitor.this.buildMultiResponse((ClientProtos.MultiRequest)invocation.getArguments()[1]);
                    }
                });
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
            this.connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(this.c, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class), ri, ServerName.valueOf((String)"example.org,12345,6789"), HRegionInfo.FIRST_META_REGIONINFO);
            FileSystem fs = FileSystem.get((Configuration)this.c);
            Path rootdir = FSUtils.getRootDir((Configuration)this.c);
            FSUtils.setRootDir((Configuration)this.c, (Path)rootdir);
            AdminProtos.AdminService.BlockingInterface hri = (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class);
        }

        public ClusterConnection getConnection() {
            return this.connection;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public Configuration getConfiguration() {
            return this.c;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"mockserver.example.org", (int)1234, (long)-1L);
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            BaseCoordinatedStateManager m = (BaseCoordinatedStateManager)Mockito.mock(BaseCoordinatedStateManager.class);
            SplitLogManagerCoordination c = (SplitLogManagerCoordination)Mockito.mock(SplitLogManagerCoordination.class);
            Mockito.when((Object)m.getSplitLogManagerCoordination()).thenReturn((Object)c);
            SplitLogManagerCoordination.SplitLogManagerDetails d = (SplitLogManagerCoordination.SplitLogManagerDetails)Mockito.mock(SplitLogManagerCoordination.SplitLogManagerDetails.class);
            Mockito.when((Object)c.getDetails()).thenReturn((Object)d);
            return m;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public boolean isStopped() {
            return false;
        }

        public void stop(String why) {
        }

        public ChoreService getChoreService() {
            return null;
        }
    }
}

