/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.log;

import com.google.common.base.Joiner;
import java.io.File;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.net.ssl.SSLException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.http.HttpConfig;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.log.LogLevel;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLogLevel {
    private static File BASEDIR;
    private static String keystoresDir;
    private static String sslConfDir;
    private static Configuration serverConf;
    private static Configuration clientConf;
    private static Configuration sslConf;
    private static final String logName;
    private static final Logger log;
    private static final String PRINCIPAL = "loglevel.principal";
    private static final String KEYTAB = "loglevel.keytab";
    private static MiniKdc kdc;
    private static HBaseCommonTestingUtility htu;
    private static final String LOCALHOST = "localhost";
    private static final String clientPrincipal = "client/localhost";
    private static String HTTP_PRINCIPAL;
    private static final File KEYTAB_FILE;

    @BeforeClass
    public static void setUp() throws Exception {
        BASEDIR = new File(htu.getDataTestDir().toUri().getPath());
        FileUtil.fullyDelete((File)BASEDIR);
        if (!BASEDIR.mkdirs()) {
            throw new Exception("unable to create the base directory for testing");
        }
        serverConf = new Configuration();
        clientConf = new Configuration();
        TestLogLevel.setupSSL(BASEDIR);
        kdc = TestLogLevel.setupMiniKdc();
        kdc.createPrincipal(KEYTAB_FILE, new String[]{clientPrincipal, HTTP_PRINCIPAL});
    }

    private static MiniKdc setupMiniKdc() throws Exception {
        boolean bindException;
        Properties conf = MiniKdc.createConf();
        conf.put("debug", (Object)true);
        MiniKdc kdc = null;
        File dir = null;
        int numTries = 0;
        do {
            try {
                bindException = false;
                dir = new File(htu.getDataTestDir("kdc").toUri().getPath());
                kdc = new MiniKdc(conf, dir);
                kdc.start();
            }
            catch (BindException e) {
                FileUtils.deleteDirectory(dir);
                if (++numTries == 3) {
                    log.error((Object)("Failed setting up MiniKDC. Tried " + numTries + " times."));
                    throw e;
                }
                log.error((Object)"BindException encountered when setting up MiniKdc. Trying again.");
                bindException = true;
            }
        } while (bindException);
        return kdc;
    }

    private static void setupSSL(File base) throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        keystoresDir = base.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestLogLevel.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, false);
        sslConf = TestLogLevel.getSslConfig();
    }

    private static Configuration getSslConfig() {
        Configuration sslConf = new Configuration(false);
        String sslServerConfFile = "ssl-server.xml";
        String sslClientConfFile = "ssl-client.xml";
        sslConf.addResource(sslServerConfFile);
        sslConf.addResource(sslClientConfFile);
        sslConf.set("hadoop.ssl.server.conf", sslServerConfFile);
        sslConf.set("hadoop.ssl.client.conf", sslClientConfFile);
        return sslConf;
    }

    @AfterClass
    public static void tearDown() {
        if (kdc != null) {
            kdc.stop();
        }
        FileUtil.fullyDelete((File)BASEDIR);
    }

    @Test(timeout=120000L)
    public void testCommandOptions() throws Exception {
        String className = this.getClass().getName();
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-foo"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[0]));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-setlevel"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "blah"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG", "blah"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "-setlevel", "foo.bar:8080", className}));
    }

    private boolean validateCommand(String[] args) {
        LogLevel.CLI cli = new LogLevel.CLI(clientConf);
        try {
            cli.parseArguments(args);
        }
        catch (HadoopIllegalArgumentException e) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private HttpServer createServer(String protocol, boolean isSpnego) throws Exception {
        HttpServer.Builder builder = new HttpServer.Builder().setName("..").addEndpoint(new URI(protocol + "://localhost:0")).setFindPort(true).setConf(serverConf);
        if (isSpnego) {
            builder.setSecurityEnabled(true).setUsernameConfKey(PRINCIPAL).setKeytabConfKey(KEYTAB).setACL(new AccessControlList("client"));
        }
        if (protocol.equals("https")) {
            builder = builder.keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks"));
        }
        HttpServer server = builder.build();
        server.start();
        return server;
    }

    private void testDynamicLogLevel(String bindProtocol, String connectProtocol, boolean isSpnego) throws Exception {
        this.testDynamicLogLevel(bindProtocol, connectProtocol, isSpnego, Level.DEBUG.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDynamicLogLevel(String bindProtocol, final String connectProtocol, boolean isSpnego, final String newLevel) throws Exception {
        if (!LogLevel.isValidProtocol((String)bindProtocol)) {
            throw new Exception("Invalid server protocol " + bindProtocol);
        }
        if (!LogLevel.isValidProtocol((String)connectProtocol)) {
            throw new Exception("Invalid client protocol " + connectProtocol);
        }
        Level oldLevel = log.getEffectiveLevel();
        Assert.assertNotEquals((String)"Get default Log Level which shouldn't be ERROR.", (Object)Level.ERROR, (Object)oldLevel);
        if (isSpnego) {
            serverConf.set(PRINCIPAL, HTTP_PRINCIPAL);
            serverConf.set(KEYTAB, KEYTAB_FILE.getAbsolutePath());
            serverConf.set("hadoop.security.authentication", "kerberos");
            serverConf.setBoolean("hadoop.security.authorization", true);
            UserGroupInformation.setConfiguration((Configuration)serverConf);
        } else {
            serverConf.set("hadoop.security.authentication", "simple");
            serverConf.setBoolean("hadoop.security.authorization", false);
            UserGroupInformation.setConfiguration((Configuration)serverConf);
        }
        HttpServer server = this.createServer(bindProtocol, isSpnego);
        final String authority = NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0));
        String keytabFilePath = KEYTAB_FILE.getAbsolutePath();
        UserGroupInformation clientUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)clientPrincipal, (String)keytabFilePath);
        try {
            clientUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestLogLevel.this.getLevel(connectProtocol, authority);
                    TestLogLevel.this.setLevel(connectProtocol, authority, newLevel);
                    return null;
                }
            });
        }
        finally {
            server.stop();
        }
        GenericTestUtils.setLogLevel((Logger)log, (Level)oldLevel);
    }

    private void getLevel(String protocol, String authority) throws Exception {
        String[] getLevelArgs = new String[]{"-getlevel", authority, logName, "-protocol", protocol};
        LogLevel.CLI cli = new LogLevel.CLI(clientConf);
        cli.run(getLevelArgs);
    }

    private void setLevel(String protocol, String authority, String newLevel) throws Exception {
        String[] setLevelArgs = new String[]{"-setlevel", authority, logName, newLevel, "-protocol", protocol};
        LogLevel.CLI cli = new LogLevel.CLI(clientConf);
        cli.run(setLevelArgs);
        Assert.assertEquals((String)"new level not equal to expected: ", (Object)newLevel.toUpperCase(), (Object)log.getEffectiveLevel().toString());
    }

    @Test(timeout=60000L)
    public void testInfoLogLevel() throws Exception {
        this.testDynamicLogLevel("http", "http", true, "INFO");
    }

    @Test(timeout=60000L)
    public void testErrorLogLevel() throws Exception {
        this.testDynamicLogLevel("http", "http", true, "ERROR");
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttp() throws Exception {
        this.testDynamicLogLevel("http", "http", false);
        try {
            this.testDynamicLogLevel("http", "https", false);
            Assert.fail((String)"A HTTPS Client should not have succeeded in connecting to a HTTP server");
        }
        catch (SSLException e) {
            TestLogLevel.exceptionShouldContains(e, "Unrecognized SSL message");
        }
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttpWithSpnego() throws Exception {
        this.testDynamicLogLevel("http", "http", true);
        try {
            this.testDynamicLogLevel("http", "https", true);
            Assert.fail((String)"A HTTPS Client should not have succeeded in connecting to a HTTP server");
        }
        catch (SSLException e) {
            TestLogLevel.exceptionShouldContains(e, "Unrecognized SSL message");
        }
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttps() throws Exception {
        this.testDynamicLogLevel("https", "https", false);
        try {
            this.testDynamicLogLevel("https", "http", false);
            Assert.fail((String)"A HTTP Client should not have succeeded in connecting to a HTTPS server");
        }
        catch (SocketException e) {
            TestLogLevel.exceptionShouldContains(e, "Unexpected end of file from server", "Connection reset");
        }
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttpsWithSpnego() throws Exception {
        this.testDynamicLogLevel("https", "https", true);
        try {
            this.testDynamicLogLevel("https", "http", true);
            Assert.fail((String)"A HTTP Client should not have succeeded in connecting to a HTTPS server");
        }
        catch (SocketException e) {
            TestLogLevel.exceptionShouldContains(e, "Unexpected end of file from server", "Connection reset");
        }
    }

    private static void exceptionShouldContains(Throwable throwable, String ... substr) {
        for (String s : substr) {
            for (Throwable t = throwable; t != null; t = t.getCause()) {
                String msg = t.toString();
                if (msg == null || !msg.toLowerCase().contains(s.toLowerCase())) continue;
                return;
            }
        }
        String debug = "[" + Joiner.on((String)" , ").join((Object[])substr) + "]";
        throw new AssertionError("Expected to find any of " + debug + " but got unexpected" + " exception:" + StringUtils.stringifyException((Throwable)throwable), throwable);
    }

    static {
        logName = TestLogLevel.class.getName();
        log = LogManager.getLogger((String)logName);
        htu = new HBaseCommonTestingUtility();
        HTTP_PRINCIPAL = "HTTP/localhost";
        KEYTAB_FILE = new File(htu.getDataTestDir("keytab").toUri().getPath());
    }
}

