/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestBlockReorderMultiBlocks {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockReorderMultiBlocks.class);
    private Configuration conf;
    private MiniDFSCluster cluster;
    private HBaseTestingUtility htu;
    private DistributedFileSystem dfs;
    private static final String host1 = "host1";
    private static final String host2 = "host2";
    private static final String host3 = "host3";
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.htu = new HBaseTestingUtility();
        this.htu.getConfiguration().setInt("dfs.blocksize", 1024);
        this.htu.getConfiguration().setInt("dfs.replication", 3);
        this.htu.startMiniDFSCluster(3, new String[]{"/r1", "/r2", "/r3"}, new String[]{host1, host2, host3});
        this.conf = this.htu.getConfiguration();
        this.cluster = this.htu.getDFSCluster();
        this.dfs = (DistributedFileSystem)FileSystem.get((Configuration)this.conf);
    }

    @After
    public void tearDownAfterClass() throws Exception {
        this.htu.shutdownMiniCluster();
    }

    @Test
    public void testHBaseCluster() throws Exception {
        byte[] sb = "sb".getBytes();
        this.htu.startMiniZKCluster();
        MiniHBaseCluster hbm = this.htu.startMiniHBaseCluster(1, 1);
        hbm.waitForActiveAndReadyMaster();
        hbm.getRegionServer(0).waitForServerOnline();
        HRegionServer targetRs = hbm.getRegionServer(0);
        String host4 = targetRs.getServerName().getHostname();
        LOG.info("Starting a new datanode with the name=" + host4);
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/r4"}, new String[]{host4}, null);
        this.cluster.waitClusterUp();
        int repCount = 3;
        this.conf = targetRs.getConfiguration();
        HFileSystem rfs = (HFileSystem)targetRs.getFileSystem();
        HTable h = this.htu.createTable(TableName.valueOf((String)"table"), sb);
        String walDir = new Path(FSUtils.getWALRootDir((Configuration)this.conf) + "/" + "WALs" + "/" + targetRs.getServerName().toString()).toUri().getPath();
        DistributedFileSystem mdfs = (DistributedFileSystem)hbm.getMaster().getMasterFileSystem().getFileSystem();
        int nbTest = 0;
        while (nbTest < 10) {
            List regions = targetRs.getOnlineRegions(h.getName());
            final CountDownLatch latch = new CountDownLatch(regions.size());
            WALActionsListener.Base listener = new WALActionsListener.Base(){

                public void postLogRoll(Path oldPath, Path newPath) throws IOException {
                    latch.countDown();
                }
            };
            for (Region region : regions) {
                ((HRegion)region).getWAL().registerWALActionsListener((WALActionsListener)listener);
            }
            this.htu.getHBaseAdmin().rollWALWriter(targetRs.getServerName());
            try {
                latch.await();
            }
            catch (InterruptedException exception) {
                LOG.warn("Interrupted while waiting for the wal of '" + targetRs + "' to roll. If later " + "tests fail, it's probably because we should still be waiting.");
                Thread.currentThread().interrupt();
            }
            for (Region region : regions) {
                ((HRegion)region).getWAL().unregisterWALActionsListener((WALActionsListener)listener);
            }
            Thread.sleep(100L);
            Put p = new Put(sb);
            p.addColumn(sb, sb, sb);
            h.put(p);
            DirectoryListing dl = this.dfs.getClient().listPaths(walDir, HdfsFileStatus.EMPTY_NAME);
            HdfsFileStatus[] hfs = dl.getPartialListing();
            Assert.assertTrue((hfs.length >= 1 ? 1 : 0) != 0);
            for (HdfsFileStatus hf : hfs) {
                try {
                    LOG.info("Log file found: " + hf.getLocalName() + " in " + walDir);
                    String logFile = walDir + "/" + hf.getLocalName();
                    FileStatus fsLog = rfs.getFileStatus(new Path(logFile));
                    LOG.info("Checking log file: " + logFile);
                    BlockLocation[] bls = rfs.getFileBlockLocations(fsLog, 0L, 1L);
                    if (bls.length <= 0) continue;
                    BlockLocation bl = bls[0];
                    LOG.info(bl.getHosts().length + " replicas for block 0 in " + logFile + " ");
                    for (int i = 0; i < bl.getHosts().length - 1; ++i) {
                        LOG.info(bl.getHosts()[i] + "    " + logFile);
                        Assert.assertNotSame((Object)bl.getHosts()[i], (Object)host4);
                    }
                    String last = bl.getHosts()[bl.getHosts().length - 1];
                    LOG.info(last + "    " + logFile);
                    if (!host4.equals(last)) continue;
                    ++nbTest;
                    LOG.info(logFile + " is on the new datanode and is ok");
                    if (bl.getHosts().length != 3) continue;
                    this.testFromDFS(this.dfs, logFile, 3, host4);
                    this.testFromDFS(mdfs, logFile, 3, host4);
                }
                catch (FileNotFoundException exception) {
                    LOG.debug("Failed to find log file '" + hf.getLocalName() + "'; it probably was " + "archived out from under us so we'll ignore and retry. If this test hangs " + "indefinitely you should treat this failure as a symptom.", (Throwable)exception);
                }
                catch (RemoteException exception) {
                    if (exception.unwrapRemoteException() instanceof FileNotFoundException) {
                        LOG.debug("Failed to find log file '" + hf.getLocalName() + "'; it probably was " + "archived out from under us so we'll ignore and retry. If this test hangs " + "indefinitely you should treat this failure as a symptom.", (Throwable)exception);
                        continue;
                    }
                    throw exception;
                }
            }
        }
    }

    private void testFromDFS(DistributedFileSystem dfs, String src, int repCount, String localhost) throws Exception {
        for (int i = 0; i < 10; ++i) {
            int y;
            LocatedBlocks l;
            boolean done;
            long max = System.currentTimeMillis() + 10000L;
            do {
                Assert.assertTrue((String)"Can't get enouth replica.", (System.currentTimeMillis() < max ? 1 : 0) != 0);
                l = TestBlockReorderMultiBlocks.getNamenode(dfs.getClient()).getBlockLocations(src, 0L, 1L);
                Assert.assertNotNull((String)("Can't get block locations for " + src), (Object)l);
                Assert.assertNotNull((Object)l.getLocatedBlocks());
                Assert.assertTrue((l.getLocatedBlocks().size() > 0 ? 1 : 0) != 0);
                done = true;
                for (y = 0; y < l.getLocatedBlocks().size() && done; ++y) {
                    done = l.get(y).getLocations().length == repCount;
                }
            } while (!done);
            for (y = 0; y < l.getLocatedBlocks().size() && done; ++y) {
                Assert.assertEquals((Object)localhost, (Object)l.get(y).getLocations()[repCount - 1].getHostName());
            }
        }
    }

    private static ClientProtocol getNamenode(DFSClient dfsc) throws Exception {
        Field nf = DFSClient.class.getDeclaredField("namenode");
        nf.setAccessible(true);
        return (ClientProtocol)nf.get(dfsc);
    }
}

