/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AbstractTestUpdateConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestUpdateConfiguration
extends AbstractTestUpdateConfiguration {
    private static final Log LOG = LogFactory.getLog(TestUpdateConfiguration.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        TestUpdateConfiguration.setUpConfigurationFiles(TEST_UTIL);
        TEST_UTIL.startMiniCluster(2, 1);
        TestUpdateConfiguration.addResourceToRegionServerConfiguration(TEST_UTIL);
    }

    @Test
    public void testOnlineConfigChange() throws IOException {
        LOG.debug((Object)("Starting the test " + this.name.getMethodName()));
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        ServerName server = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        admin.updateConfiguration(server);
    }

    @Test
    public void testMasterOnlineConfigChange() throws IOException {
        LOG.debug((Object)("Starting the test " + this.name.getMethodName()));
        this.replaceHBaseSiteXML();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        ServerName server = TEST_UTIL.getHBaseCluster().getMaster().getServerName();
        admin.updateConfiguration(server);
        Configuration conf = TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration();
        int custom = conf.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        this.restoreHBaseSiteXML();
    }

    @Test
    public void testAllOnlineConfigChange() throws IOException {
        LOG.debug((Object)("Starting the test " + this.name.getMethodName()));
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.updateConfiguration();
    }

    @Test
    public void testAllCustomOnlineConfigChange() throws IOException {
        LOG.debug((Object)("Starting the test " + this.name.getMethodName()));
        this.replaceHBaseSiteXML();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.updateConfiguration();
        Configuration masterConfiguration = TEST_UTIL.getMiniHBaseCluster().getMaster(0).getConfiguration();
        int custom = masterConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)custom, (long)1000L);
        Configuration backupMasterConfiguration = TEST_UTIL.getMiniHBaseCluster().getMaster(1).getConfiguration();
        custom = backupMasterConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)custom, (long)1000L);
        Configuration regionServerConfiguration = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getConfiguration();
        custom = regionServerConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)custom, (long)1000L);
        this.restoreHBaseSiteXML();
    }
}

