/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestMasterAddressRefresher {
    @Test
    public void testPeriodicMasterEndPointRefresh() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.client.master_registry.refresh_interval_secs", 1L);
        conf.setLong("hbase.client.master_registry.min_secs_between_refreshes", 0L);
        final DummyMasterRegistry registry = new DummyMasterRegistry();
        registry.init(new DummyConnection(conf));
        Waiter.waitFor((Configuration)conf, (long)5000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return registry.getMastersCount() > 3;
            }
        });
    }

    @Test
    public void testDurationBetweenRefreshes() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.client.master_registry.refresh_interval_secs", Integer.MAX_VALUE);
        conf.setLong("hbase.client.master_registry.min_secs_between_refreshes", 1L);
        DummyMasterRegistry registry = new DummyMasterRegistry();
        registry.init(new DummyConnection(conf));
        for (int i = 0; i < 10000; ++i) {
            registry.masterAddressRefresher.refreshNow();
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        List<Long> callTimeStamps = registry.getCallTimeStamps();
        Assert.assertTrue((String)String.valueOf(registry.getMastersCount()), (registry.getMastersCount() <= 20 ? 1 : 0) != 0);
        Assert.assertTrue((callTimeStamps.size() > 0 ? 1 : 0) != 0);
        for (int i = 1; i < callTimeStamps.size() - 1; ++i) {
            long delta = callTimeStamps.get(i) - callTimeStamps.get(i - 1);
            Assert.assertTrue((String)callTimeStamps.toString(), (delta > 990L ? 1 : 0) != 0);
        }
    }

    private static class DummyMasterRegistry
    extends MasterRegistry {
        private final AtomicInteger getMastersCallCounter = new AtomicInteger(0);
        private final List<Long> callTimeStamps = new ArrayList<Long>();

        private DummyMasterRegistry() {
        }

        public void init(Connection connection) throws IOException {
            super.init(connection);
        }

        List<ServerName> getMasters() {
            this.getMastersCallCounter.incrementAndGet();
            this.callTimeStamps.add(EnvironmentEdgeManager.currentTime());
            return new ArrayList<ServerName>();
        }

        public int getMastersCount() {
            return this.getMastersCallCounter.get();
        }

        public List<Long> getCallTimeStamps() {
            return this.callTimeStamps;
        }
    }

    static class DummyConnection
    implements Connection {
        private final Configuration conf;

        DummyConnection(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public Table getTable(TableName tableName) throws IOException {
            return null;
        }

        public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
            return null;
        }

        public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
            return null;
        }

        public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
            return null;
        }

        public RegionLocator getRegionLocator(TableName tableName) throws IOException {
            return null;
        }

        public Admin getAdmin() throws IOException {
            return null;
        }

        public String getClusterId() throws IOException {
            return null;
        }

        public void close() throws IOException {
        }

        public boolean isClosed() {
            return false;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }
    }
}

