/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnCountOnRowFilter;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestLimitedScanWithFilter {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestRegionScanner");
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[][] CQS = new byte[][]{Bytes.toBytes((String)"cq1"), Bytes.toBytes((String)"cq2"), Bytes.toBytes((String)"cq3"), Bytes.toBytes((String)"cq4")};
    private static int ROW_COUNT = 10;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        try (HTable table = UTIL.createTable(TABLE_NAME, FAMILY);){
            for (int i = 0; i < ROW_COUNT; ++i) {
                Put put = new Put(Bytes.toBytes((int)i));
                for (int j = 0; j < CQS.length; ++j) {
                    put.addColumn(FAMILY, CQS[j], Bytes.toBytes((int)((j + 1) * i)));
                }
                table.put(put);
            }
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCompleteResult() throws IOException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(2)).setMaxResultSize(1L).setLimit(limit);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            for (int i = 0; i < limit; ++i) {
                Result result = scanner.next();
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
                Assert.assertEquals((long)2L, (long)result.size());
                Assert.assertFalse((boolean)result.mayHaveMoreCellsInRow());
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[0])));
                Assert.assertEquals((long)(2 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[1])));
            }
            Assert.assertNull((Object)scanner.next());
        }
    }

    @Test
    public void testAllowPartial() throws IOException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(2)).setMaxResultSize(1L).setAllowPartialResults(true).setLimit(limit);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            for (int i = 0; i < 2 * limit; ++i) {
                int key = i / 2;
                Result result = scanner.next();
                Assert.assertEquals((long)key, (long)Bytes.toInt((byte[])result.getRow()));
                Assert.assertEquals((long)1L, (long)result.size());
                Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
                int cqIndex = i % 2;
                Assert.assertEquals((long)(key * (cqIndex + 1)), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[cqIndex])));
            }
            Assert.assertNull((Object)scanner.next());
        }
    }

    @Test
    public void testBatchAllowPartial() throws IOException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(3)).setBatch(2).setMaxResultSize(1L).setAllowPartialResults(true).setLimit(limit);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            for (int i = 0; i < 3 * limit; ++i) {
                int key = i / 3;
                Result result = scanner.next();
                Assert.assertEquals((long)key, (long)Bytes.toInt((byte[])result.getRow()));
                Assert.assertEquals((long)1L, (long)result.size());
                Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
                int cqIndex = i % 3;
                Assert.assertEquals((long)(key * (cqIndex + 1)), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[cqIndex])));
            }
            Assert.assertNull((Object)scanner.next());
        }
    }

    @Test
    public void testBatch() throws IOException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(2)).setBatch(2).setMaxResultSize(1L).setLimit(limit);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            for (int i = 0; i < limit; ++i) {
                Result result = scanner.next();
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
                Assert.assertEquals((long)2L, (long)result.size());
                Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[0])));
                Assert.assertEquals((long)(2 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[1])));
            }
            Assert.assertNull((Object)scanner.next());
        }
    }

    @Test
    public void testBatchAndFilterDiffer() throws IOException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(3)).setBatch(2).setMaxResultSize(1L).setLimit(limit);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            for (int i = 0; i < limit; ++i) {
                Result result = scanner.next();
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
                Assert.assertEquals((long)2L, (long)result.size());
                Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[0])));
                Assert.assertEquals((long)(2 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[1])));
                result = scanner.next();
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
                Assert.assertEquals((long)1L, (long)result.size());
                Assert.assertFalse((boolean)result.mayHaveMoreCellsInRow());
                Assert.assertEquals((long)(3 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[2])));
            }
            Assert.assertNull((Object)scanner.next());
        }
    }
}

