/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestConnectionImplementation {
    private static HBaseTestingUtility testUtil;
    private static ConnectionManager.HConnectionImplementation conn;
    private static HBaseProtos.RegionSpecifier specifier;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        testUtil = HBaseTestingUtility.createLocalHTU();
        testUtil.startMiniCluster();
        conn = (ConnectionManager.HConnectionImplementation)testUtil.getConnection();
        specifier = HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteStringer.wrap((byte[])Bytes.toBytes((String)"region"))).setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).build();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        conn.close();
        testUtil.shutdownMiniCluster();
    }

    @Test
    public void testGetAdminBadHostname() throws Exception {
        ServerName master = testUtil.getHBaseCluster().getMaster().getServerName();
        HBaseRpcController controller = conn.getRpcControllerFactory().newController();
        AdminProtos.GetRegionInfoRequest request = AdminProtos.GetRegionInfoRequest.newBuilder().setRegion(specifier).build();
        AdminProtos.AdminService.BlockingInterface goodAdmin = conn.getAdmin(master);
        this.verifyAdminCall(goodAdmin, controller, request, false);
        ServerName badHost = ServerName.valueOf((String)"unknownhost.invalid:16000", (long)System.currentTimeMillis());
        AdminProtos.AdminService.BlockingInterface badAdmin = conn.getAdmin(badHost);
        this.verifyAdminCall(badAdmin, controller, request, true);
    }

    private void verifyAdminCall(AdminProtos.AdminService.BlockingInterface admin, HBaseRpcController rpcController, AdminProtos.GetRegionInfoRequest request, boolean shouldHaveHostException) {
        try {
            admin.getRegionInfo((RpcController)rpcController, request);
        }
        catch (ServiceException se) {
            Assert.assertEquals((Object)shouldHaveHostException, (Object)(se.getCause() instanceof UnknownHostException));
        }
        catch (Exception e) {
            Assert.assertEquals((Object)(!shouldHaveHostException ? 1 : 0), (Object)(e instanceof NotServingRegionException));
        }
    }

    @Test
    public void testGetClientBadHostname() throws Exception {
        ServerName rs = testUtil.getHBaseCluster().getRegionServer(0).getServerName();
        HBaseRpcController controller = conn.getRpcControllerFactory().newController();
        ClientProtos.Get get = ClientProtos.Get.newBuilder().setRow(ByteStringer.wrap((byte[])Bytes.toBytes((String)"r"))).build();
        ClientProtos.GetRequest request = ClientProtos.GetRequest.newBuilder().setGet(get).setRegion(specifier).build();
        ClientProtos.ClientService.BlockingInterface goodClient = conn.getClient(rs);
        this.verifyClientCall(goodClient, controller, request, false);
        ServerName badHost = ServerName.valueOf((String)"unknownhost.invalid:16020", (long)System.currentTimeMillis());
        ClientProtos.ClientService.BlockingInterface badClient = conn.getClient(badHost);
        this.verifyClientCall(badClient, controller, request, true);
    }

    private void verifyClientCall(ClientProtos.ClientService.BlockingInterface client, HBaseRpcController rpcController, ClientProtos.GetRequest request, boolean shouldHaveHostException) {
        try {
            client.get((RpcController)rpcController, request);
        }
        catch (ServiceException se) {
            Assert.assertEquals((Object)shouldHaveHostException, (Object)(se.getCause() instanceof UnknownHostException));
        }
        catch (Exception e) {
            Assert.assertEquals((Object)(!shouldHaveHostException ? 1 : 0), (Object)(e instanceof NotServingRegionException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocateRegionsWithRegionReplicas() throws IOException {
        int regionReplication = 3;
        byte[] family = Bytes.toBytes((String)"cf");
        TableName tableName = TableName.valueOf((String)"testLocateRegionsWithRegionReplicas");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(family));
        desc.setRegionReplication(regionReplication);
        testUtil.getConnection().getAdmin().createTable(desc);
        try (ConnectionManager.HConnectionImplementation con = (ConnectionManager.HConnectionImplementation)ConnectionFactory.createConnection((Configuration)testUtil.getConfiguration());){
            List locations = con.locateRegions(tableName, false, false);
            Assert.assertEquals((long)regionReplication, (long)locations.size());
            HashSet<Integer> expectedReplicaIds = new HashSet<Integer>(Arrays.asList(0, 1, 2));
            for (HRegionLocation location : locations) {
                Assert.assertTrue((boolean)expectedReplicaIds.remove(location.getRegionInfo().getReplicaId()));
            }
        }
        finally {
            testUtil.deleteTable(tableName);
        }
    }
}

