/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class MockRegionServerServicesWithWALs
implements RegionServerServices {
    WALProvider provider;
    RegionServerServices rss;

    public MockRegionServerServicesWithWALs(RegionServerServices rss, WALProvider provider) {
        this.rss = rss;
        this.provider = provider;
    }

    public boolean isStopping() {
        return this.rss.isStopping();
    }

    public WAL getWAL(HRegionInfo hri) throws IOException {
        return this.provider.getWAL(hri.getEncodedNameAsBytes(), hri.getTable().getNamespace());
    }

    public CompactionRequestor getCompactionRequester() {
        return this.rss.getCompactionRequester();
    }

    public FlushRequester getFlushRequester() {
        return this.rss.getFlushRequester();
    }

    public RegionServerAccounting getRegionServerAccounting() {
        return this.rss.getRegionServerAccounting();
    }

    public TableLockManager getTableLockManager() {
        return this.rss.getTableLockManager();
    }

    public RegionServerQuotaManager getRegionServerQuotaManager() {
        return this.rss.getRegionServerQuotaManager();
    }

    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws KeeperException, IOException {
        this.rss.postOpenDeployTasks(context);
    }

    public void postOpenDeployTasks(Region r) throws KeeperException, IOException {
        this.rss.postOpenDeployTasks(r);
    }

    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        return this.rss.reportRegionStateTransition(context);
    }

    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, HRegionInfo ... hris) {
        return this.rss.reportRegionStateTransition(code, openSeqNum, hris);
    }

    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, HRegionInfo ... hris) {
        return this.rss.reportRegionStateTransition(code, hris);
    }

    public RpcServerInterface getRpcServer() {
        return this.rss.getRpcServer();
    }

    public ConcurrentMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.rss.getRegionsInTransitionInRS();
    }

    public FileSystem getFileSystem() {
        return this.rss.getFileSystem();
    }

    public Leases getLeases() {
        return this.rss.getLeases();
    }

    public ExecutorService getExecutorService() {
        return this.rss.getExecutorService();
    }

    public Map<String, Region> getRecoveringRegions() {
        return this.rss.getRecoveringRegions();
    }

    public ServerNonceManager getNonceManager() {
        return this.rss.getNonceManager();
    }

    public boolean registerService(Service service) {
        return this.rss.registerService(service);
    }

    public HeapMemoryManager getHeapMemoryManager() {
        return this.rss.getHeapMemoryManager();
    }

    public double getCompactionPressure() {
        return this.rss.getCompactionPressure();
    }

    public Set<TableName> getOnlineTables() {
        return this.rss.getOnlineTables();
    }

    public ThroughputController getFlushThroughputController() {
        return this.rss.getFlushThroughputController();
    }

    public double getFlushPressure() {
        return this.rss.getFlushPressure();
    }

    public MetricsRegionServer getMetrics() {
        return this.rss.getMetrics();
    }

    public void unassign(byte[] regionName) throws IOException {
        this.rss.unassign(regionName);
    }

    public void addToOnlineRegions(Region r) {
        this.rss.addToOnlineRegions(r);
    }

    public boolean removeFromOnlineRegions(Region r, ServerName destination) {
        return this.rss.removeFromOnlineRegions(r, destination);
    }

    public Region getFromOnlineRegions(String encodedRegionName) {
        return this.rss.getFromOnlineRegions(encodedRegionName);
    }

    public List<Region> getOnlineRegions(TableName tableName) throws IOException {
        return this.rss.getOnlineRegions(tableName);
    }

    public List<Region> getOnlineRegions() {
        return this.rss.getOnlineRegions();
    }

    public Configuration getConfiguration() {
        return this.rss.getConfiguration();
    }

    public ZooKeeperWatcher getZooKeeper() {
        return this.rss.getZooKeeper();
    }

    public ClusterConnection getConnection() {
        return this.rss.getConnection();
    }

    public MetaTableLocator getMetaTableLocator() {
        return this.rss.getMetaTableLocator();
    }

    public ServerName getServerName() {
        return this.rss.getServerName();
    }

    public CoordinatedStateManager getCoordinatedStateManager() {
        return this.rss.getCoordinatedStateManager();
    }

    public ChoreService getChoreService() {
        return this.rss.getChoreService();
    }

    public void abort(String why, Throwable e) {
        this.rss.abort(why, e);
    }

    public boolean isAborted() {
        return this.rss.isAborted();
    }

    public void stop(String why) {
        this.rss.stop(why);
    }

    public boolean isStopped() {
        return this.rss.isStopped();
    }

    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
        this.rss.updateRegionFavoredNodesMapping(encodedRegionName, favoredNodes);
    }

    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return this.rss.getFavoredNodesForRegion(encodedRegionName);
    }
}

