/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.metrics;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.yarn.api.records.Resource;

@Metrics(about="Metrics for node manager", context="yarn")
public class NodeManagerMetrics {
    @Metric
    MutableCounterInt containersLaunched;
    @Metric
    MutableCounterInt containersCompleted;
    @Metric
    MutableCounterInt containersFailed;
    @Metric
    MutableCounterInt containersKilled;
    @Metric(value={"# of initializing containers"})
    MutableGaugeInt containersIniting;
    @Metric
    MutableGaugeInt containersRunning;
    @Metric(value={"Current allocated memory in GB"})
    MutableGaugeInt allocatedGB;
    @Metric(value={"Current # of allocated containers"})
    MutableGaugeInt allocatedContainers;
    @Metric
    MutableGaugeInt availableGB;
    @Metric(value={"Current allocated Virtual Cores"})
    MutableGaugeInt allocatedVCores;
    @Metric
    MutableGaugeInt availableVCores;
    @Metric(value={"Container launch duration"})
    MutableRate containerLaunchDuration;
    @Metric(value={"# of bad local dirs"})
    MutableGaugeInt badLocalDirs;
    @Metric(value={"# of bad log dirs"})
    MutableGaugeInt badLogDirs;
    @Metric(value={"Disk utilization % on good local dirs"})
    MutableGaugeInt goodLocalDirsDiskUtilizationPerc;
    @Metric(value={"Disk utilization % on good log dirs"})
    MutableGaugeInt goodLogDirsDiskUtilizationPerc;
    private JvmMetrics jvmMetrics = null;
    private long allocatedMB;
    private long availableMB;

    public NodeManagerMetrics(JvmMetrics jvmMetrics) {
        this.jvmMetrics = jvmMetrics;
    }

    public static NodeManagerMetrics create() {
        return NodeManagerMetrics.create(DefaultMetricsSystem.instance());
    }

    static NodeManagerMetrics create(MetricsSystem ms) {
        JvmMetrics jm = JvmMetrics.create((String)"NodeManager", null, (MetricsSystem)ms);
        return (NodeManagerMetrics)ms.register((Object)new NodeManagerMetrics(jm));
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public void launchedContainer() {
        this.containersLaunched.incr();
    }

    public void completedContainer() {
        this.containersCompleted.incr();
    }

    public void failedContainer() {
        this.containersFailed.incr();
    }

    public void killedContainer() {
        this.containersKilled.incr();
    }

    public void initingContainer() {
        this.containersIniting.incr();
    }

    public void endInitingContainer() {
        this.containersIniting.decr();
    }

    public void runningContainer() {
        this.containersRunning.incr();
    }

    public void endRunningContainer() {
        this.containersRunning.decr();
    }

    public void allocateContainer(Resource res) {
        this.allocatedContainers.incr();
        this.allocatedMB += res.getMemorySize();
        this.allocatedGB.set((int)Math.ceil((double)this.allocatedMB / 1024.0));
        this.availableMB -= res.getMemorySize();
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.allocatedVCores.incr(res.getVirtualCores());
        this.availableVCores.decr(res.getVirtualCores());
    }

    public void releaseContainer(Resource res) {
        this.allocatedContainers.decr();
        this.allocatedMB -= res.getMemorySize();
        this.allocatedGB.set((int)Math.ceil((double)this.allocatedMB / 1024.0));
        this.availableMB += res.getMemorySize();
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.allocatedVCores.decr(res.getVirtualCores());
        this.availableVCores.incr(res.getVirtualCores());
    }

    public void changeContainer(Resource before, Resource now) {
        long deltaMB = now.getMemorySize() - before.getMemorySize();
        int deltaVCores = now.getVirtualCores() - before.getVirtualCores();
        this.allocatedMB += deltaMB;
        this.allocatedGB.set((int)Math.ceil((double)this.allocatedMB / 1024.0));
        this.availableMB -= deltaMB;
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.allocatedVCores.incr(deltaVCores);
        this.availableVCores.decr(deltaVCores);
    }

    public void addResource(Resource res) {
        this.availableMB += res.getMemorySize();
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.availableVCores.incr(res.getVirtualCores());
    }

    public void addContainerLaunchDuration(long value) {
        this.containerLaunchDuration.add(value);
    }

    public void setBadLocalDirs(int badLocalDirs) {
        this.badLocalDirs.set(badLocalDirs);
    }

    public void setBadLogDirs(int badLogDirs) {
        this.badLogDirs.set(badLogDirs);
    }

    public void setGoodLocalDirsDiskUtilizationPerc(int goodLocalDirsDiskUtilizationPerc) {
        this.goodLocalDirsDiskUtilizationPerc.set(goodLocalDirsDiskUtilizationPerc);
    }

    public void setGoodLogDirsDiskUtilizationPerc(int goodLogDirsDiskUtilizationPerc) {
        this.goodLogDirsDiskUtilizationPerc.set(goodLogDirsDiskUtilizationPerc);
    }

    public int getRunningContainers() {
        return this.containersRunning.value();
    }

    @VisibleForTesting
    public int getKilledContainers() {
        return this.containersKilled.value();
    }

    @VisibleForTesting
    public int getFailedContainers() {
        return this.containersFailed.value();
    }

    @VisibleForTesting
    public int getCompletedContainers() {
        return this.containersCompleted.value();
    }

    @VisibleForTesting
    public int getBadLogDirs() {
        return this.badLogDirs.value();
    }

    @VisibleForTesting
    public int getBadLocalDirs() {
        return this.badLocalDirs.value();
    }

    @VisibleForTesting
    public int getGoodLogDirsDiskUtilizationPerc() {
        return this.goodLogDirsDiskUtilizationPerc.value();
    }

    @VisibleForTesting
    public int getGoodLocalDirsDiskUtilizationPerc() {
        return this.goodLocalDirsDiskUtilizationPerc.value();
    }
}

