/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.api.ContainerLogAggregationPolicy;
import org.apache.hadoop.yarn.server.api.ContainerLogContext;
import org.apache.hadoop.yarn.server.api.ContainerType;

@InterfaceAudience.Private
public class SampleContainerLogAggregationPolicy
implements ContainerLogAggregationPolicy {
    private static final Log LOG = LogFactory.getLog(SampleContainerLogAggregationPolicy.class);
    static String SAMPLE_RATE = "SR";
    public static final float DEFAULT_SAMPLE_RATE = 0.2f;
    static String MIN_THRESHOLD = "MIN";
    public static final int DEFAULT_SAMPLE_MIN_THRESHOLD = 20;
    private float sampleRate = 0.2f;
    private int minThreshold = 20;

    public static String buildParameters(float sampleRate, int minThreshold) {
        StringBuilder sb = new StringBuilder();
        sb.append(SAMPLE_RATE).append(":").append(sampleRate).append(",").append(MIN_THRESHOLD).append(":").append(minThreshold);
        return sb.toString();
    }

    public void parseParameters(String parameters) {
        Collection params = StringUtils.getStringCollection((String)parameters);
        for (String param : params) {
            String[] property = StringUtils.getStrings((String)param, (String)":");
            if (property == null || property.length != 2) continue;
            if (property[0].equals(SAMPLE_RATE)) {
                try {
                    float sampleRate = Float.parseFloat(property[1]);
                    if ((double)sampleRate >= 0.0 && (double)sampleRate <= 1.0) {
                        this.sampleRate = sampleRate;
                        continue;
                    }
                    LOG.warn((Object)"The format isn't valid. Sample rate falls back to the default value 0.2");
                }
                catch (NumberFormatException nfe) {
                    LOG.warn((Object)"The format isn't valid. Sample rate falls back to the default value 0.2");
                }
                continue;
            }
            if (!property[0].equals(MIN_THRESHOLD)) continue;
            try {
                int minThreshold = Integer.parseInt(property[1]);
                if (minThreshold >= 0) {
                    this.minThreshold = minThreshold;
                    continue;
                }
                LOG.warn((Object)"The format isn't valid. Min threshold falls back to the default value 20");
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)"The format isn't valid. Min threshold falls back to the default value 20");
            }
        }
    }

    public boolean shouldDoLogAggregation(ContainerLogContext logContext) {
        if (logContext.getContainerType() == ContainerType.APPLICATION_MASTER || logContext.getExitCode() != 0) {
            return true;
        }
        if ((logContext.getContainerId().getContainerId() & 0xFFFFFFFFFFL) < (long)(this.minThreshold + 2)) {
            return true;
        }
        return this.sampleRate != 0.0f && (float)logContext.getContainerId().hashCode() % (1.0f / this.sampleRate) == 0.0f;
    }
}

