/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.util.LongBitFormat;

public enum AclEntryStatusFormat {
    SCOPE(null, 1),
    TYPE(AclEntryStatusFormat.SCOPE.BITS, 2),
    PERMISSION(AclEntryStatusFormat.TYPE.BITS, 3),
    NAMED_ENTRY_CHECK(AclEntryStatusFormat.PERMISSION.BITS, 1),
    RESERVED(AclEntryStatusFormat.NAMED_ENTRY_CHECK.BITS, 1),
    NAME(AclEntryStatusFormat.RESERVED.BITS, 24);

    private final LongBitFormat BITS;

    private AclEntryStatusFormat(LongBitFormat previous, int length) {
        this.BITS = new LongBitFormat(this.name(), previous, length, 0L);
    }

    static AclEntryScope getScope(int aclEntry) {
        int ordinal = (int)AclEntryStatusFormat.SCOPE.BITS.retrieve((long)aclEntry);
        return AclEntryScope.values()[ordinal];
    }

    static AclEntryType getType(int aclEntry) {
        int ordinal = (int)AclEntryStatusFormat.TYPE.BITS.retrieve((long)aclEntry);
        return AclEntryType.values()[ordinal];
    }

    static FsAction getPermission(int aclEntry) {
        int ordinal = (int)AclEntryStatusFormat.PERMISSION.BITS.retrieve((long)aclEntry);
        return FsAction.values()[ordinal];
    }

    static String getName(int aclEntry) {
        int nameExists = (int)AclEntryStatusFormat.NAMED_ENTRY_CHECK.BITS.retrieve((long)aclEntry);
        if (nameExists == 0) {
            return null;
        }
        int id = (int)AclEntryStatusFormat.NAME.BITS.retrieve((long)aclEntry);
        AclEntryType type = AclEntryStatusFormat.getType(aclEntry);
        if (type == AclEntryType.USER) {
            return SerialNumberManager.INSTANCE.getUser(id);
        }
        if (type == AclEntryType.GROUP) {
            return SerialNumberManager.INSTANCE.getGroup(id);
        }
        return null;
    }

    static int toInt(AclEntry aclEntry) {
        long aclEntryInt = 0L;
        aclEntryInt = AclEntryStatusFormat.SCOPE.BITS.combine((long)aclEntry.getScope().ordinal(), aclEntryInt);
        aclEntryInt = AclEntryStatusFormat.TYPE.BITS.combine((long)aclEntry.getType().ordinal(), aclEntryInt);
        aclEntryInt = AclEntryStatusFormat.PERMISSION.BITS.combine((long)aclEntry.getPermission().ordinal(), aclEntryInt);
        if (aclEntry.getName() != null) {
            aclEntryInt = AclEntryStatusFormat.NAMED_ENTRY_CHECK.BITS.combine(1L, aclEntryInt);
            if (aclEntry.getType() == AclEntryType.USER) {
                int userId = SerialNumberManager.INSTANCE.getUserSerialNumber(aclEntry.getName());
                aclEntryInt = AclEntryStatusFormat.NAME.BITS.combine((long)userId, aclEntryInt);
            } else if (aclEntry.getType() == AclEntryType.GROUP) {
                int groupId = SerialNumberManager.INSTANCE.getGroupSerialNumber(aclEntry.getName());
                aclEntryInt = AclEntryStatusFormat.NAME.BITS.combine((long)groupId, aclEntryInt);
            }
        }
        return (int)aclEntryInt;
    }

    static AclEntry toAclEntry(int aclEntry) {
        AclEntry.Builder builder = new AclEntry.Builder();
        builder.setScope(AclEntryStatusFormat.getScope(aclEntry)).setType(AclEntryStatusFormat.getType(aclEntry)).setPermission(AclEntryStatusFormat.getPermission(aclEntry));
        if (AclEntryStatusFormat.getName(aclEntry) != null) {
            builder.setName(AclEntryStatusFormat.getName(aclEntry));
        }
        return builder.build();
    }

    public static int[] toInt(List<AclEntry> aclEntries) {
        int[] entries = new int[aclEntries.size()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = AclEntryStatusFormat.toInt(aclEntries.get(i));
        }
        return entries;
    }

    public static ImmutableList<AclEntry> toAclEntries(int[] entries) {
        ImmutableList.Builder b = new ImmutableList.Builder();
        for (int entry : entries) {
            AclEntry aclEntry = AclEntryStatusFormat.toAclEntry(entry);
            b.add((Object)aclEntry);
        }
        return b.build();
    }
}

