/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;

@JRubyClass(name={"Integer"}, parent="Numeric", include={"Precision"})
public abstract class RubyInteger
extends RubyNumeric {
    static final ByteList[] SINGLE_CHAR_BYTELISTS = new ByteList[256];
    static final ByteList[] SINGLE_CHAR_BYTELISTS19 = new ByteList[256];

    public static RubyClass createIntegerClass(Ruby runtime2) {
        RubyClass integer = runtime2.defineClass("Integer", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setInteger(integer);
        integer.index = 16;
        integer.setReifiedClass(RubyInteger.class);
        integer.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyInteger;
            }
        };
        integer.getSingletonClass().undefineMethod("new");
        if (!runtime2.is1_9()) {
            integer.includeModule(runtime2.getPrecision());
        }
        integer.defineAnnotatedMethods(RubyInteger.class);
        return integer;
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyInteger(RubyClass rubyClass) {
        super(rubyClass);
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace) {
        super(runtime2, rubyClass, useObjectSpace);
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, rubyClass, useObjectSpace, canBeTainted);
    }

    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod
    public IRubyObject upto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumUpto(context, ((RubyFixnum)this).getLongValue(), ((RubyFixnum)to).getLongValue(), block);
            } else {
                RubyInteger.duckUpto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "upto", to);
    }

    private static void fixnumUpto(ThreadContext context, long from, long to, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (block.getBody().getArgumentType() == 0) {
            IRubyObject nil = runtime2.getNil();
            for (long i2 = from; i2 <= to; ++i2) {
                block.yield(context, nil);
            }
        } else {
            for (long i3 = from; i3 <= to; ++i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
            }
        }
    }

    private static void duckUpto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject i2 = from;
        RubyFixnum one = RubyFixnum.one(runtime2);
        while (!i2.callMethod(context, ">", to).isTrue()) {
            block.yield(context, i2);
            i2 = i2.callMethod(context, "+", one);
        }
    }

    @JRubyMethod
    public IRubyObject downto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumDownto(context, ((RubyFixnum)this).getLongValue(), ((RubyFixnum)to).getLongValue(), block);
            } else {
                RubyInteger.duckDownto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "downto", to);
    }

    private static void fixnumDownto(ThreadContext context, long from, long to, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (block.getBody().getArgumentType() == 0) {
            IRubyObject nil = runtime2.getNil();
            for (long i2 = from; i2 >= to; --i2) {
                block.yield(context, nil);
            }
        } else {
            for (long i3 = from; i3 >= to; --i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
            }
        }
    }

    private static void duckDownto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject i2 = from;
        RubyFixnum one = RubyFixnum.one(runtime2);
        while (!i2.callMethod(context, "<", to).isTrue()) {
            block.yield(context, i2);
            i2 = i2.callMethod(context, "-", one);
        }
    }

    @JRubyMethod
    public IRubyObject times(ThreadContext context, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.getRuntime();
            IRubyObject i2 = RubyFixnum.zero(runtime2);
            RubyFixnum one = RubyFixnum.one(runtime2);
            while (i2.callMethod(context, "<", this).isTrue()) {
                block.yield(context, i2);
                i2 = i2.callMethod(context, "+", one);
            }
            return this;
        }
        return RubyEnumerator.enumeratorize(context.getRuntime(), this, "times");
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        if (this instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.getRuntime(), this.getLongValue() + 1L);
        }
        return this.callMethod(context, "+", (IRubyObject)RubyFixnum.one(context.getRuntime()));
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_8)
    public RubyString chr(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        long value2 = this.getLongValue();
        if (value2 < 0L || value2 > 255L) {
            throw runtime2.newRangeError(this.toString() + " out of char range");
        }
        return RubyString.newStringShared(runtime2, SINGLE_CHAR_BYTELISTS[(int)value2]);
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_9)
    public RubyString chr19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        int value2 = (int)this.getLongValue();
        if (value2 >= 0 && value2 <= 255) {
            ByteList bytes2 = SINGLE_CHAR_BYTELISTS19[value2];
            return RubyString.newStringShared(runtime2, bytes2, bytes2.getEncoding());
        }
        Encoding enc = runtime2.getDefaultInternalEncoding();
        if (value2 > 255 && (enc == null || enc == ASCIIEncoding.INSTANCE)) {
            throw runtime2.newRangeError(this.toString() + " out of char range");
        }
        if (enc == null) {
            enc = USASCIIEncoding.INSTANCE;
        }
        return RubyString.newStringNoCopy(runtime2, this.fromEncodedBytes(runtime2, enc, value2), enc, 0);
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_9)
    public RubyString chr19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        long value2 = this.getLongValue();
        Encoding enc = arg2 instanceof RubyEncoding ? ((RubyEncoding)arg2).getEncoding() : arg2.convertToString().toEncoding(runtime2);
        if (enc == ASCIIEncoding.INSTANCE && value2 >= 128L) {
            return this.chr19(context);
        }
        return RubyString.newStringNoCopy(runtime2, this.fromEncodedBytes(runtime2, enc, (int)value2), enc, 0);
    }

    private ByteList fromEncodedBytes(Ruby runtime2, Encoding enc, int value2) {
        int n;
        try {
            n = value2 < 0 ? 0 : enc.codeToMbcLength(value2);
        }
        catch (EncodingException ee) {
            n = 0;
        }
        if (n <= 0) {
            throw runtime2.newRangeError(this.toString() + " out of char range");
        }
        ByteList bytes2 = new ByteList(n);
        enc.codeToMbc(value2, bytes2.getUnsafeBytes(), 0);
        bytes2.setRealSize(n);
        return bytes2;
    }

    @JRubyMethod(name={"ord"})
    public IRubyObject ord(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_i", "to_int", "floor", "ceil", "truncate"})
    public IRubyObject to_i() {
        return this;
    }

    @JRubyMethod(name={"round"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject round() {
        return this;
    }

    @JRubyMethod(name={"round"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject round19() {
        return this;
    }

    @JRubyMethod(name={"round"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject round19(ThreadContext context, IRubyObject arg2) {
        int ndigits = RubyNumeric.num2int(arg2);
        if (ndigits > 0) {
            return RubyKernel.new_float(this, this);
        }
        if (ndigits == 0) {
            return this;
        }
        ndigits = -ndigits;
        Ruby runtime2 = context.getRuntime();
        if (ndigits < 0) {
            throw runtime2.newArgumentError("ndigits out of range");
        }
        IRubyObject f = Numeric.int_pow(context, 10L, ndigits);
        if (this instanceof RubyFixnum && f instanceof RubyFixnum) {
            boolean neg;
            long x = ((RubyFixnum)this).getLongValue();
            long y = ((RubyFixnum)f).getLongValue();
            boolean bl = neg = x < 0L;
            if (neg) {
                x = -x;
            }
            x = (x + y / 2L) / y * y;
            if (neg) {
                x = -x;
            }
            return RubyFixnum.newFixnum(runtime2, x);
        }
        IRubyObject h = f.callMethod(context, "/", RubyFixnum.two(runtime2));
        IRubyObject r = this.callMethod(context, "%", f);
        IRubyObject n = this.callMethod(context, "-", r);
        if (!r.callMethod(context, "<", h).isTrue()) {
            n = n.callMethod(context, "+", f);
        }
        return n;
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this);
    }

    @JRubyMethod(name={"rationalize"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        return this.to_r(context);
    }

    @JRubyMethod(name={"odd?"})
    public RubyBoolean odd_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.callMethod(context, "%", (IRubyObject)RubyFixnum.two(runtime2)) != RubyFixnum.zero(runtime2)) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"even?"})
    public RubyBoolean even_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.callMethod(context, "%", (IRubyObject)RubyFixnum.two(runtime2)) == RubyFixnum.zero(runtime2)) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"pred"})
    public IRubyObject pred(ThreadContext context) {
        return this.callMethod(context, "-", (IRubyObject)RubyFixnum.one(context.getRuntime()));
    }

    @JRubyMethod(name={"gcd"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gcd(ThreadContext context, IRubyObject other) {
        Numeric.checkInteger(context, other);
        return Numeric.f_gcd(context, this, RubyRational.intValue(context, other));
    }

    @JRubyMethod(name={"lcm"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lcm(ThreadContext context, IRubyObject other) {
        Numeric.checkInteger(context, other);
        return Numeric.f_lcm(context, this, RubyRational.intValue(context, other));
    }

    @JRubyMethod(name={"gcdlcm"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gcdlcm(ThreadContext context, IRubyObject other) {
        Numeric.checkInteger(context, other);
        other = RubyRational.intValue(context, other);
        return context.getRuntime().newArray(Numeric.f_gcd(context, this, other), Numeric.f_lcm(context, this, other));
    }

    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.getRuntime());
    }

    @JRubyMethod(name={"induced_from"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return other.callMethod(context, "to_i");
        }
        throw recv2.getRuntime().newTypeError("failed to convert " + other.getMetaClass().getName() + " into Integer");
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            ByteList usascii;
            RubyInteger.SINGLE_CHAR_BYTELISTS[i2] = usascii = new ByteList(new byte[]{(byte)i2}, false);
            RubyInteger.SINGLE_CHAR_BYTELISTS19[i2] = i2 < 128 ? new ByteList(new byte[]{(byte)i2}, USASCIIEncoding.INSTANCE) : new ByteList(new byte[]{(byte)i2}, ASCIIEncoding.INSTANCE);
        }
    }
}

