/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ServiceException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.regionserver.wal.WALEditsReplaySink;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.io.MultipleIOException;

@InterfaceAudience.Private
@SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Synchronization on concurrent map is intended")
public class WALSplitter {
    private static final Log LOG = LogFactory.getLog(WALSplitter.class);
    public static final boolean SPLIT_SKIP_ERRORS_DEFAULT = false;
    protected final Path walDir;
    protected final Path rootDir;
    protected final FileSystem walFS;
    protected final FileSystem rootFS;
    protected final Configuration conf;
    PipelineController controller;
    OutputSink outputSink;
    EntryBuffers entryBuffers;
    private Set<TableName> disablingOrDisabledTables = new HashSet<TableName>();
    private BaseCoordinatedStateManager csm;
    private final WALFactory walFactory;
    private MonitoredTask status;
    protected final LastSequenceId sequenceIdChecker;
    protected boolean distributedLogReplay;
    private final boolean splitWriterCreationBounded;
    protected Map<String, Long> lastFlushedSequenceIds = new ConcurrentHashMap<String, Long>();
    protected Map<String, Map<byte[], Long>> regionMaxSeqIdInStores = new ConcurrentHashMap<String, Map<byte[], Long>>();
    protected String failedServerName = "";
    private final int numWriterThreads;
    private final int minBatchSize;
    private FileStatus fileBeingSplit;
    public static final String SPLIT_WRITER_CREATION_BOUNDED = "hbase.split.writer.creation.bounded";
    private static final Pattern EDITFILES_NAME_PATTERN = Pattern.compile("-?[0-9]+");
    private static final String RECOVERED_LOG_TMPFILE_SUFFIX = ".temp";
    private static final String SEQUENCE_ID_FILE_SUFFIX = ".seqid";
    private static final String OLD_SEQUENCE_ID_FILE_SUFFIX = "_seqid";
    private static final int SEQUENCE_ID_FILE_SUFFIX_LENGTH = ".seqid".length();

    WALSplitter(WALFactory factory, Configuration conf, Path walDir, FileSystem walFS, Path rootDir, FileSystem rootFS, LastSequenceId idChecker, CoordinatedStateManager csm, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
        this.conf = HBaseConfiguration.create((Configuration)conf);
        String codecClassName = conf.get("hbase.regionserver.wal.codec", WALCellCodec.class.getName());
        this.conf.set("hbase.client.rpc.codec", codecClassName);
        this.walDir = walDir;
        this.walFS = walFS;
        this.rootDir = rootDir;
        this.rootFS = rootFS;
        this.sequenceIdChecker = idChecker;
        this.csm = (BaseCoordinatedStateManager)csm;
        this.walFactory = factory;
        this.controller = new PipelineController();
        this.splitWriterCreationBounded = conf.getBoolean(SPLIT_WRITER_CREATION_BOUNDED, false);
        this.entryBuffers = new EntryBuffers(this.controller, this.conf.getInt("hbase.regionserver.hlog.splitlog.buffersize", 0x8000000), this.splitWriterCreationBounded);
        this.minBatchSize = this.conf.getInt("hbase.regionserver.wal.logreplay.batch.size", 64);
        this.distributedLogReplay = ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY == mode;
        this.numWriterThreads = this.conf.getInt("hbase.regionserver.hlog.splitlog.writer.threads", 3);
        if (csm != null && this.distributedLogReplay) {
            this.outputSink = new LogReplayOutputSink(this.controller, this.entryBuffers, this.numWriterThreads);
        } else {
            if (this.distributedLogReplay) {
                LOG.info((Object)"ZooKeeperWatcher is passed in as NULL so disable distrubitedLogRepaly.");
            }
            this.distributedLogReplay = false;
            this.outputSink = this.splitWriterCreationBounded ? new BoundedLogWriterCreationOutputSink(this.controller, this.entryBuffers, this.numWriterThreads) : new LogRecoveredEditsOutputSink(this.controller, this.entryBuffers, this.numWriterThreads);
        }
    }

    public static boolean splitLogFile(Path walDir, FileStatus logfile, FileSystem walFS, Configuration conf, CancelableProgressable reporter, LastSequenceId idChecker, CoordinatedStateManager cp, ZooKeeperProtos.SplitLogTask.RecoveryMode mode, WALFactory factory) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        FileSystem rootFS = rootDir.getFileSystem(conf);
        WALSplitter s = new WALSplitter(factory, conf, walDir, walFS, rootDir, rootFS, idChecker, cp, mode);
        return s.splitLogFile(logfile, reporter);
    }

    public static List<Path> split(Path walRootDir, Path logDir, Path oldLogDir, FileSystem walFs, Configuration conf, WALFactory factory) throws IOException {
        FileStatus[] logfiles = SplitLogManager.getFileList(conf, Collections.singletonList(logDir), null);
        ArrayList<Path> splits = new ArrayList<Path>();
        if (logfiles != null && logfiles.length > 0) {
            Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
            FileSystem rootFS = rootDir.getFileSystem(conf);
            FileStatus[] arr$ = logfiles;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                WALSplitter s = new WALSplitter(factory, conf, walRootDir, walFs, rootDir, rootFS, null, null, ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING);
                FileStatus logfile = arr$[i$];
                if (!s.splitLogFile(logfile, null)) continue;
                WALSplitter.finishSplitLogFile(walRootDir, oldLogDir, logfile.getPath(), conf);
                if (s.outputSink.splits == null) continue;
                splits.addAll(s.outputSink.splits);
            }
        }
        if (!walFs.delete(logDir, true)) {
            throw new IOException("Unable to delete src dir: " + logDir);
        }
        return splits;
    }

    /*
     * Exception decompiling
     */
    boolean splitLogFile(FileStatus logfile, CancelableProgressable reporter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 44[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isRegionDirPresentUnderRoot(TableName tableName, String regionName) throws IOException {
        Path regionDirPath = CommonFSUtils.getRegionDir((Path)this.rootDir, (TableName)tableName, (String)regionName);
        return this.rootFS.exists(regionDirPath);
    }

    public static void finishSplitLogFile(String logfile, Configuration conf) throws IOException {
        Path walDir = FSUtils.getWALRootDir((Configuration)conf);
        Path oldLogDir = new Path(walDir, "oldWALs");
        Path logPath = FSUtils.isStartingWithPath((Path)walDir, (String)logfile) ? new Path(logfile) : new Path(walDir, logfile);
        WALSplitter.finishSplitLogFile(walDir, oldLogDir, logPath, conf);
    }

    private static void finishSplitLogFile(Path walDir, Path oldLogDir, Path logPath, Configuration conf) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        FileSystem walFS = walDir.getFileSystem(conf);
        if (ZKSplitLog.isCorrupted(walDir, logPath.getName(), walFS)) {
            corruptedLogs.add(logPath);
        } else {
            processedLogs.add(logPath);
        }
        WALSplitter.archiveLogs(corruptedLogs, processedLogs, oldLogDir, walFS, conf);
        Path stagingDir = ZKSplitLog.getSplitLogDir(walDir, logPath.getName());
        walFS.delete(stagingDir, true);
    }

    private static void archiveLogs(List<Path> corruptedLogs, List<Path> processedLogs, Path oldLogDir, FileSystem walFS, Configuration conf) throws IOException {
        Path corruptDir = new Path(FSUtils.getWALRootDir((Configuration)conf), conf.get("hbase.regionserver.hlog.splitlog.corrupt.dir", "corrupt"));
        if (!walFS.mkdirs(corruptDir)) {
            LOG.info((Object)("Unable to mkdir " + corruptDir));
        }
        walFS.mkdirs(oldLogDir);
        for (Path corrupted : corruptedLogs) {
            Path p = new Path(corruptDir, corrupted.getName());
            if (!walFS.exists(corrupted)) continue;
            if (!walFS.rename(corrupted, p)) {
                LOG.warn((Object)("Unable to move corrupted log " + corrupted + " to " + p));
                continue;
            }
            LOG.warn((Object)("Moved corrupted log " + corrupted + " to " + p));
        }
        for (Path p : processedLogs) {
            Path newPath = FSHLog.getWALArchivePath(oldLogDir, p);
            if (!walFS.exists(p)) continue;
            if (!FSUtils.renameAndSetModifyTime((FileSystem)walFS, (Path)p, (Path)newPath)) {
                LOG.warn((Object)("Unable to move  " + p + " to " + newPath));
                continue;
            }
            LOG.info((Object)("Archived processed log " + p + " to " + newPath));
        }
    }

    static Path getRegionSplitEditsPath(WAL.Entry logEntry, String fileNameBeingSplit, String tmpDirName, Configuration conf) throws IOException {
        String encodedRegionName;
        TableName tableName;
        Path regionDir;
        Path dir;
        FileSystem walFS = FSUtils.getWALFileSystem((Configuration)conf);
        if (walFS.exists(dir = WALSplitter.getRegionDirRecoveredEditsDir(regionDir = FSUtils.getWALRegionDir(conf, tableName = logEntry.getKey().getTablename(), encodedRegionName = Bytes.toString((byte[])logEntry.getKey().getEncodedRegionName())))) && walFS.isFile(dir)) {
            Path tmp = new Path(tmpDirName);
            if (!walFS.exists(tmp)) {
                walFS.mkdirs(tmp);
            }
            tmp = new Path(tmp, "recovered.edits_" + encodedRegionName);
            LOG.warn((Object)("Found existing old file: " + dir + ". It could be some " + "leftover of an old installation. It should be a folder instead. " + "So moving it to " + tmp));
            if (!walFS.rename(dir, tmp)) {
                LOG.warn((Object)("Failed to sideline old file " + dir));
            }
        }
        if (!walFS.exists(dir) && !walFS.mkdirs(dir)) {
            LOG.warn((Object)("mkdir failed on " + dir));
        }
        String fileName = WALSplitter.formatRecoveredEditsFileName(logEntry.getKey().getLogSeqNum());
        fileName = WALSplitter.getTmpRecoveredEditsFileName(fileName + "-" + fileNameBeingSplit);
        return new Path(dir, fileName);
    }

    private static String getTmpRecoveredEditsFileName(String fileName) {
        return fileName + RECOVERED_LOG_TMPFILE_SUFFIX;
    }

    private static Path getCompletedRecoveredEditsFilePath(Path srcPath, long maximumEditLogSeqNum) {
        String fileName = WALSplitter.formatRecoveredEditsFileName(maximumEditLogSeqNum);
        return new Path(srcPath.getParent(), fileName);
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    public static Path getRegionDirRecoveredEditsDir(Path regionDir) {
        return new Path(regionDir, "recovered.edits");
    }

    public static NavigableSet<Path> getSplitEditFilesSorted(final FileSystem walFS, Path regionDir) throws IOException {
        TreeSet<Path> filesSorted = new TreeSet<Path>();
        Path editsdir = WALSplitter.getRegionDirRecoveredEditsDir(regionDir);
        if (!walFS.exists(editsdir)) {
            return filesSorted;
        }
        FileStatus[] files = FSUtils.listStatus((FileSystem)walFS, (Path)editsdir, (PathFilter)new PathFilter(){

            public boolean accept(Path p) {
                boolean result = false;
                try {
                    Matcher m = EDITFILES_NAME_PATTERN.matcher(p.getName());
                    boolean bl = result = walFS.isFile(p) && m.matches();
                    if (p.getName().endsWith(WALSplitter.RECOVERED_LOG_TMPFILE_SUFFIX)) {
                        result = false;
                    }
                    if (WALSplitter.isSequenceIdFile(p)) {
                        result = false;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed isFile check on " + p));
                }
                return result;
            }
        });
        if (files == null) {
            return filesSorted;
        }
        for (FileStatus status : files) {
            filesSorted.add(status.getPath());
        }
        return filesSorted;
    }

    public static Path moveAsideBadEditsFile(FileSystem walFS, Path edits) throws IOException {
        Path moveAsideName = new Path(edits.getParent(), edits.getName() + "." + System.currentTimeMillis());
        if (!walFS.rename(edits, moveAsideName)) {
            LOG.warn((Object)("Rename failed from " + edits + " to " + moveAsideName));
        }
        return moveAsideName;
    }

    public static boolean isSequenceIdFile(Path file) {
        return file.getName().endsWith(SEQUENCE_ID_FILE_SUFFIX) || file.getName().endsWith(OLD_SEQUENCE_ID_FILE_SUFFIX);
    }

    public static long writeRegionSequenceIdFile(FileSystem walFS, Path regionDir, long newSeqId, long saftyBumper) throws IOException {
        Path editsdir = WALSplitter.getRegionDirRecoveredEditsDir(regionDir);
        long maxSeqId = 0L;
        FileStatus[] files = null;
        if (walFS.exists(editsdir) && (files = FSUtils.listStatus((FileSystem)walFS, (Path)editsdir, (PathFilter)new PathFilter(){

            public boolean accept(Path p) {
                return WALSplitter.isSequenceIdFile(p);
            }
        })) != null) {
            for (FileStatus status : files) {
                String fileName = status.getPath().getName();
                try {
                    Long tmpSeqId = Long.parseLong(fileName.substring(0, fileName.length() - SEQUENCE_ID_FILE_SUFFIX_LENGTH));
                    maxSeqId = Math.max(tmpSeqId, maxSeqId);
                }
                catch (NumberFormatException ex) {
                    LOG.warn((Object)("Invalid SeqId File Name=" + fileName));
                }
            }
        }
        if (maxSeqId > newSeqId) {
            newSeqId = maxSeqId;
        }
        Path newSeqIdFile = new Path(editsdir, (newSeqId += saftyBumper) + SEQUENCE_ID_FILE_SUFFIX);
        if (newSeqId != maxSeqId) {
            try {
                if (!walFS.createNewFile(newSeqIdFile) && !walFS.exists(newSeqIdFile)) {
                    throw new IOException("Failed to create SeqId file:" + newSeqIdFile);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Wrote region seqId=" + newSeqIdFile + " to file, newSeqId=" + newSeqId + ", maxSeqId=" + maxSeqId));
                }
            }
            catch (FileAlreadyExistsException ignored) {
                // empty catch block
            }
        }
        if (files != null) {
            for (FileStatus status : files) {
                if (newSeqIdFile.equals((Object)status.getPath())) continue;
                walFS.delete(status.getPath(), false);
            }
        }
        return newSeqId;
    }

    protected WAL.Reader getReader(FileStatus file, boolean skipErrors, CancelableProgressable reporter) throws IOException, CorruptedLogFileException {
        WAL.Reader in;
        Path path = file.getPath();
        long length = file.getLen();
        if (length <= 0L) {
            LOG.warn((Object)("File " + path + " might be still open, length is 0"));
        }
        try {
            FSUtils.getInstance(this.walFS, this.conf).recoverFileLease(this.walFS, path, this.conf, reporter);
            try {
                in = this.getReader(path, reporter);
            }
            catch (EOFException e) {
                if (length <= 0L) {
                    LOG.warn((Object)("Could not open " + path + " for reading. File is empty"), (Throwable)e);
                    return null;
                }
                return null;
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                LOG.warn((Object)("File " + path + " doesn't exist anymore."), (Throwable)e);
                return null;
            }
            if (!skipErrors || e instanceof InterruptedIOException) {
                throw e;
            }
            throw new CorruptedLogFileException("skipErrors=true Could not open wal " + path + " ignoring", e);
        }
        return in;
    }

    private static WAL.Entry getNextLogLine(WAL.Reader in, Path path, boolean skipErrors) throws CorruptedLogFileException, IOException {
        try {
            return in.next();
        }
        catch (EOFException eof) {
            LOG.info((Object)("EOF from wal " + path + ".  continuing"));
            return null;
        }
        catch (IOException e) {
            if (e.getCause() != null && (e.getCause() instanceof ParseException || e.getCause() instanceof ChecksumException)) {
                LOG.warn((Object)("Parse exception " + e.getCause().toString() + " from wal " + path + ".  continuing"));
                return null;
            }
            if (!skipErrors) {
                throw e;
            }
            throw new CorruptedLogFileException("skipErrors=true Ignoring exception while parsing wal " + path + ". Marking as corrupted", e);
        }
    }

    protected WALProvider.Writer createWriter(Path logfile) throws IOException {
        return this.walFactory.createRecoveredEditsWriter(this.walFS, logfile);
    }

    protected WAL.Reader getReader(Path curLogFile, CancelableProgressable reporter) throws IOException {
        return this.walFactory.createReader(this.walFS, curLogFile, reporter);
    }

    private int getNumOpenWriters() {
        int result = 0;
        if (this.outputSink != null) {
            result += this.outputSink.getNumOpenWriters();
        }
        return result;
    }

    public static List<MutationReplay> getMutationsFromWALEntry(AdminProtos.WALEntry entry, CellScanner cells, Pair<WALKey, WALEdit> logEntry, Durability durability) throws IOException {
        if (entry == null) {
            return new ArrayList<MutationReplay>();
        }
        long replaySeqId = entry.getKey().hasOrigSequenceNumber() ? entry.getKey().getOrigSequenceNumber() : entry.getKey().getLogSequenceNumber();
        int count = entry.getAssociatedCellCount();
        ArrayList<MutationReplay> mutations = new ArrayList<MutationReplay>();
        Cell previousCell = null;
        Delete m = null;
        HLogKey key = null;
        WALEdit val = null;
        if (logEntry != null) {
            val = new WALEdit();
        }
        for (int i = 0; i < count; ++i) {
            boolean isNewRowOrType;
            if (!cells.advance()) {
                throw new ArrayIndexOutOfBoundsException("Expected=" + count + ", index=" + i);
            }
            Cell cell = cells.current();
            if (val != null) {
                val.add(cell);
            }
            boolean bl = isNewRowOrType = previousCell == null || previousCell.getTypeByte() != cell.getTypeByte() || !CellUtil.matchingRow(previousCell, (Cell)cell);
            if (isNewRowOrType) {
                if (CellUtil.isDelete((Cell)cell)) {
                    m = new Delete(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
                    mutations.add(new MutationReplay(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)m, 0L, 0L));
                } else {
                    m = new Put(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
                    long nonceGroup = entry.getKey().hasNonceGroup() ? entry.getKey().getNonceGroup() : 0L;
                    long nonce = entry.getKey().hasNonce() ? entry.getKey().getNonce() : 0L;
                    mutations.add(new MutationReplay(ClientProtos.MutationProto.MutationType.PUT, (Mutation)m, nonceGroup, nonce));
                }
            }
            if (CellUtil.isDelete((Cell)cell)) {
                ((Delete)m).addDeleteMarker(cell);
            } else {
                ((Put)m).add(cell);
            }
            m.setDurability(durability);
            previousCell = cell;
        }
        if (logEntry != null) {
            WALProtos.WALKey walKeyProto = entry.getKey();
            ArrayList<UUID> clusterIds = new ArrayList<UUID>(walKeyProto.getClusterIdsCount());
            for (HBaseProtos.UUID uuid : entry.getKey().getClusterIdsList()) {
                clusterIds.add(new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits()));
            }
            key = new HLogKey(walKeyProto.getEncodedRegionName().toByteArray(), TableName.valueOf((byte[])walKeyProto.getTableName().toByteArray()), replaySeqId, walKeyProto.getWriteTime(), clusterIds, walKeyProto.getNonceGroup(), walKeyProto.getNonce(), null);
            logEntry.setFirst((Object)key);
            logEntry.setSecond((Object)val);
        }
        return mutations;
    }

    public static class MutationReplay
    implements Comparable<MutationReplay> {
        public final ClientProtos.MutationProto.MutationType type;
        public final Mutation mutation;
        public final long nonceGroup;
        public final long nonce;

        public MutationReplay(ClientProtos.MutationProto.MutationType type, Mutation mutation, long nonceGroup, long nonce) {
            this.type = type;
            this.mutation = mutation;
            if (this.mutation.getDurability() != Durability.SKIP_WAL) {
                this.mutation.setDurability(Durability.ASYNC_WAL);
            }
            this.nonceGroup = nonceGroup;
            this.nonce = nonce;
        }

        @Override
        public int compareTo(MutationReplay d) {
            return this.mutation.compareTo((Row)d.mutation);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MutationReplay)) {
                return false;
            }
            return this.compareTo((MutationReplay)obj) == 0;
        }

        public int hashCode() {
            return this.mutation.hashCode();
        }
    }

    static class CorruptedLogFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CorruptedLogFileException(String s) {
            super(s);
        }

        CorruptedLogFileException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class RegionServerWriter
    extends SinkWriter {
        final WALEditsReplaySink sink;

        RegionServerWriter(Configuration conf, TableName tableName, HConnection conn) throws IOException {
            this.sink = new WALEditsReplaySink(conf, tableName, conn);
        }

        void close() throws IOException {
        }
    }

    class LogReplayOutputSink
    extends OutputSink {
        private static final double BUFFER_THRESHOLD = 0.35;
        private static final String KEY_DELIMITER = "#";
        private long waitRegionOnlineTimeOut;
        private final Set<String> recoveredRegions;
        private final Map<String, RegionServerWriter> rsWriters;
        private final Map<String, HRegionLocation> onlineRegions;
        private final Map<TableName, HConnection> tableNameToHConnectionMap;
        private final Map<String, List<Pair<HRegionLocation, WAL.Entry>>> serverToBufferQueueMap;
        private final List<Throwable> thrown;
        private LogRecoveredEditsOutputSink logRecoveredEditsOutputSink;
        private boolean hasEditsInDisablingOrDisabledTables;

        public LogReplayOutputSink(PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
            super(controller, entryBuffers, numWriters);
            this.recoveredRegions = Collections.synchronizedSet(new HashSet());
            this.rsWriters = new ConcurrentHashMap<String, RegionServerWriter>();
            this.onlineRegions = new ConcurrentHashMap<String, HRegionLocation>();
            this.tableNameToHConnectionMap = Collections.synchronizedMap(new TreeMap());
            this.serverToBufferQueueMap = new ConcurrentHashMap<String, List<Pair<HRegionLocation, WAL.Entry>>>();
            this.thrown = new ArrayList<Throwable>();
            this.hasEditsInDisablingOrDisabledTables = false;
            this.waitRegionOnlineTimeOut = WALSplitter.this.conf.getInt("hbase.splitlog.manager.timeout", 120000);
            this.logRecoveredEditsOutputSink = new LogRecoveredEditsOutputSink(controller, entryBuffers, numWriters);
            this.logRecoveredEditsOutputSink.setReporter(this.reporter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void append(RegionEntryBuffer buffer) throws IOException {
            List<WAL.Entry> entries = buffer.entryBuffer;
            if (entries.isEmpty()) {
                LOG.warn((Object)"got an empty buffer, skipping");
                return;
            }
            if (WALSplitter.this.disablingOrDisabledTables.contains(buffer.tableName)) {
                this.logRecoveredEditsOutputSink.append(buffer);
                this.hasEditsInDisablingOrDisabledTables = true;
                this.addToRecoveredRegions(Bytes.toString((byte[])buffer.encodedRegionName));
                return;
            }
            this.groupEditsByServer(entries);
            String maxLocKey = null;
            int maxSize = 0;
            List<Pair<HRegionLocation, WAL.Entry>> maxQueue = null;
            Map<String, List<Pair<HRegionLocation, WAL.Entry>>> map = this.serverToBufferQueueMap;
            synchronized (map) {
                for (Map.Entry<String, List<Pair<HRegionLocation, WAL.Entry>>> entry : this.serverToBufferQueueMap.entrySet()) {
                    List<Pair<HRegionLocation, WAL.Entry>> curQueue = entry.getValue();
                    if (curQueue.size() <= maxSize) continue;
                    maxSize = curQueue.size();
                    maxQueue = curQueue;
                    maxLocKey = entry.getKey();
                }
                if (maxSize < WALSplitter.this.minBatchSize && (double)this.entryBuffers.totalBuffered < 0.35 * (double)this.entryBuffers.maxHeapUsage) {
                    return;
                }
                if (maxSize > 0) {
                    this.serverToBufferQueueMap.remove(maxLocKey);
                }
            }
            if (maxSize > 0) {
                this.processWorkItems(maxLocKey, maxQueue);
            }
        }

        private void addToRecoveredRegions(String encodedRegionName) {
            if (!this.recoveredRegions.contains(encodedRegionName)) {
                this.recoveredRegions.add(encodedRegionName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void groupEditsByServer(List<WAL.Entry> entries) throws IOException {
            TreeSet<TableName> nonExistentTables = null;
            Long cachedLastFlushedSequenceId = -1L;
            for (WAL.Entry entry : entries) {
                WALEdit edit = entry.getEdit();
                TableName table = entry.getKey().getTablename();
                entry.getKey().setScopes(null);
                String encodeRegionNameStr = Bytes.toString((byte[])entry.getKey().getEncodedRegionName());
                if (nonExistentTables != null && nonExistentTables.contains(table)) {
                    this.skippedEdits.incrementAndGet();
                    continue;
                }
                Map<byte[], Long> maxStoreSequenceIds = null;
                boolean needSkip = false;
                HRegionLocation loc = null;
                String locKey = null;
                ArrayList<Cell> cells = edit.getCells();
                ArrayList<Cell> skippedCells = new ArrayList<Cell>();
                HConnection hconn = this.getConnectionByTableName(table);
                for (Cell cell : cells) {
                    Long maxStoreSeqId;
                    byte[] family;
                    block18: {
                        boolean isCompactionEntry;
                        byte[] row;
                        block17: {
                            row = CellUtil.cloneRow((Cell)cell);
                            family = CellUtil.cloneFamily((Cell)cell);
                            isCompactionEntry = false;
                            if (CellUtil.matchingFamily((Cell)cell, (byte[])WALEdit.METAFAMILY)) {
                                WALProtos.CompactionDescriptor compaction = WALEdit.getCompaction(cell);
                                if (compaction != null && compaction.hasRegionName()) {
                                    try {
                                        byte[][] regionName = HRegionInfo.parseRegionName((byte[])compaction.getRegionName().toByteArray());
                                        row = regionName[1];
                                        family = compaction.getFamilyName().toByteArray();
                                        isCompactionEntry = true;
                                        break block17;
                                    }
                                    catch (Exception ex) {
                                        LOG.warn((Object)("Unexpected exception received, ignoring " + ex));
                                        skippedCells.add(cell);
                                        continue;
                                    }
                                }
                                skippedCells.add(cell);
                                continue;
                            }
                        }
                        try {
                            loc = this.locateRegionAndRefreshLastFlushedSequenceId(hconn, table, row, encodeRegionNameStr);
                            if (!isCompactionEntry || encodeRegionNameStr.equalsIgnoreCase(loc.getRegionInfo().getEncodedName())) break block18;
                            LOG.info((Object)("Not replaying a compaction marker for an older region: " + encodeRegionNameStr));
                            needSkip = true;
                        }
                        catch (TableNotFoundException ex) {
                            LOG.info((Object)("Table " + table + " doesn't exist. Skip log replay for region " + encodeRegionNameStr));
                            WALSplitter.this.lastFlushedSequenceIds.put(encodeRegionNameStr, Long.MAX_VALUE);
                            if (nonExistentTables == null) {
                                nonExistentTables = new TreeSet<TableName>();
                            }
                            nonExistentTables.add(table);
                            this.skippedEdits.incrementAndGet();
                            needSkip = true;
                            break;
                        }
                    }
                    cachedLastFlushedSequenceId = WALSplitter.this.lastFlushedSequenceIds.get(loc.getRegionInfo().getEncodedName());
                    if (cachedLastFlushedSequenceId != null && cachedLastFlushedSequenceId >= entry.getKey().getLogSeqNum()) {
                        this.skippedEdits.incrementAndGet();
                        needSkip = true;
                        break;
                    }
                    if (maxStoreSequenceIds == null) {
                        maxStoreSequenceIds = WALSplitter.this.regionMaxSeqIdInStores.get(loc.getRegionInfo().getEncodedName());
                    }
                    if (maxStoreSequenceIds == null || (maxStoreSeqId = (Long)maxStoreSequenceIds.get(family)) != null && maxStoreSeqId < entry.getKey().getLogSeqNum()) continue;
                    skippedCells.add(cell);
                }
                if (loc == null || needSkip) continue;
                if (!skippedCells.isEmpty()) {
                    cells.removeAll(skippedCells);
                }
                Map<String, List<Pair<HRegionLocation, WAL.Entry>>> map = this.serverToBufferQueueMap;
                synchronized (map) {
                    locKey = loc.getHostnamePort() + KEY_DELIMITER + table;
                    List<Object> queue = this.serverToBufferQueueMap.get(locKey);
                    if (queue == null) {
                        queue = Collections.synchronizedList(new ArrayList());
                        this.serverToBufferQueueMap.put(locKey, queue);
                    }
                    queue.add((Pair<HRegionLocation, WAL.Entry>)new Pair((Object)loc, (Object)entry));
                }
                this.addToRecoveredRegions(loc.getRegionInfo().getEncodedName());
            }
        }

        private HRegionLocation locateRegionAndRefreshLastFlushedSequenceId(HConnection hconn, TableName table, byte[] row, String originalEncodedRegionName) throws IOException {
            HRegionLocation loc = this.onlineRegions.get(originalEncodedRegionName);
            if (loc != null) {
                return loc;
            }
            loc = hconn.getRegionLocation(table, row, true);
            if (loc == null) {
                throw new IOException("Can't locate location for row:" + Bytes.toString((byte[])row) + " of table:" + table);
            }
            if (!originalEncodedRegionName.equalsIgnoreCase(loc.getRegionInfo().getEncodedName())) {
                WALSplitter.this.lastFlushedSequenceIds.put(originalEncodedRegionName, Long.MAX_VALUE);
                HRegionLocation tmpLoc = this.onlineRegions.get(loc.getRegionInfo().getEncodedName());
                if (tmpLoc != null) {
                    return tmpLoc;
                }
            }
            Long lastFlushedSequenceId = -1L;
            AtomicBoolean isRecovering = new AtomicBoolean(true);
            loc = this.waitUntilRegionOnline(loc, row, this.waitRegionOnlineTimeOut, isRecovering);
            if (!isRecovering.get()) {
                WALSplitter.this.lastFlushedSequenceIds.put(loc.getRegionInfo().getEncodedName(), Long.MAX_VALUE);
                LOG.info((Object)("logReplay skip region: " + loc.getRegionInfo().getEncodedName() + " because it's not in recovering."));
            } else {
                Long cachedLastFlushedSequenceId = WALSplitter.this.lastFlushedSequenceIds.get(loc.getRegionInfo().getEncodedName());
                ClusterStatusProtos.RegionStoreSequenceIds ids = WALSplitter.this.csm.getSplitLogWorkerCoordination().getRegionFlushedSequenceId(WALSplitter.this.failedServerName, loc.getRegionInfo().getEncodedName());
                if (ids != null) {
                    lastFlushedSequenceId = ids.getLastFlushedSequenceId();
                    TreeMap<byte[], Long> storeIds = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
                    List maxSeqIdInStores = ids.getStoreSequenceIdList();
                    for (ClusterStatusProtos.StoreSequenceId id : maxSeqIdInStores) {
                        storeIds.put(id.getFamilyName().toByteArray(), id.getSequenceId());
                    }
                    WALSplitter.this.regionMaxSeqIdInStores.put(loc.getRegionInfo().getEncodedName(), storeIds);
                }
                if (cachedLastFlushedSequenceId == null || lastFlushedSequenceId > cachedLastFlushedSequenceId) {
                    WALSplitter.this.lastFlushedSequenceIds.put(loc.getRegionInfo().getEncodedName(), lastFlushedSequenceId);
                }
            }
            this.onlineRegions.put(loc.getRegionInfo().getEncodedName(), loc);
            return loc;
        }

        private void processWorkItems(String key, List<Pair<HRegionLocation, WAL.Entry>> actions) throws IOException {
            RegionServerWriter rsw = null;
            long startTime = System.nanoTime();
            try {
                rsw = this.getRegionServerWriter(key);
                rsw.sink.replayEntries(actions);
                rsw.incrementEdits(actions.size());
                rsw.incrementNanoTime(System.nanoTime() - startTime);
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException((IOException)e);
                LOG.fatal((Object)" Got while writing log entry to log", (Throwable)e);
                throw e;
            }
        }

        private HRegionLocation waitUntilRegionOnline(HRegionLocation loc, byte[] row, long timeout, AtomicBoolean isRecovering) throws IOException {
            long endTime = EnvironmentEdgeManager.currentTime() + timeout;
            long pause = WALSplitter.this.conf.getLong("hbase.client.pause", 100L);
            boolean reloadLocation = false;
            TableName tableName = loc.getRegionInfo().getTable();
            int tries = 0;
            Throwable cause = null;
            while (endTime > EnvironmentEdgeManager.currentTime()) {
                block9: {
                    try {
                        HConnection hconn = this.getConnectionByTableName(tableName);
                        if (reloadLocation) {
                            loc = hconn.getRegionLocation(tableName, row, true);
                        }
                        AdminProtos.AdminService.BlockingInterface remoteSvr = hconn.getAdmin(loc.getServerName());
                        HRegionInfo region = loc.getRegionInfo();
                        try {
                            AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest((byte[])region.getRegionName());
                            AdminProtos.GetRegionInfoResponse response = remoteSvr.getRegionInfo(null, request);
                            if (HRegionInfo.convert((HBaseProtos.RegionInfo)response.getRegionInfo()) != null) {
                                isRecovering.set(response.hasIsRecovering() ? response.getIsRecovering() : true);
                                return loc;
                            }
                        }
                        catch (ServiceException se) {
                            throw ProtobufUtil.getRemoteException((ServiceException)se);
                        }
                    }
                    catch (IOException e) {
                        cause = e.getCause();
                        if (cause instanceof RegionOpeningException) break block9;
                        reloadLocation = true;
                    }
                }
                long expectedSleep = ConnectionUtils.getPauseTime((long)pause, (int)tries);
                try {
                    Thread.sleep(expectedSleep);
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted when waiting region " + loc.getRegionInfo().getEncodedName() + " online.", e);
                }
                ++tries;
            }
            throw new IOException("Timeout when waiting region " + loc.getRegionInfo().getEncodedName() + " online for " + timeout + " milliseconds.", cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean flush() throws IOException {
            String curLoc = null;
            int curSize = 0;
            List<Pair<HRegionLocation, WAL.Entry>> curQueue = null;
            Object object = this.serverToBufferQueueMap;
            synchronized (object) {
                for (Map.Entry<String, List<Pair<HRegionLocation, WAL.Entry>>> entry : this.serverToBufferQueueMap.entrySet()) {
                    String locationKey = entry.getKey();
                    curQueue = entry.getValue();
                    if (curQueue.isEmpty()) continue;
                    curSize = curQueue.size();
                    curLoc = locationKey;
                    break;
                }
                if (curSize > 0) {
                    this.serverToBufferQueueMap.remove(curLoc);
                }
            }
            if (curSize > 0) {
                this.processWorkItems(curLoc, curQueue);
                object = this.controller.dataAvailable;
                synchronized (object) {
                    this.controller.dataAvailable.notifyAll();
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean keepRegionEvent(WAL.Entry entry) {
            return true;
        }

        void addWriterError(Throwable t) {
            this.thrown.add(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Path> finishWritingAndClose() throws IOException {
            try {
                if (!this.finishWriting(false)) {
                    List<Path> list = null;
                    return list;
                }
                this.splits = this.hasEditsInDisablingOrDisabledTables ? this.logRecoveredEditsOutputSink.finishWritingAndClose() : new ArrayList();
                List list = this.splits;
                return list;
            }
            finally {
                List<IOException> thrown = this.closeRegionServerWriters();
                if (thrown != null && !thrown.isEmpty()) {
                    throw MultipleIOException.createIOException(thrown);
                }
            }
        }

        @Override
        int getNumOpenWriters() {
            return this.rsWriters.size() + this.logRecoveredEditsOutputSink.getNumOpenWriters();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<IOException> closeRegionServerWriters() throws IOException {
            ArrayList result = null;
            if (!this.writersClosed) {
                Map<String, RegionServerWriter> map;
                result = Lists.newArrayList();
                try {
                    for (WriterThread t : this.writerThreads) {
                        while (t.isAlive()) {
                            t.shouldStop = true;
                            t.interrupt();
                            try {
                                t.join(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                InterruptedIOException iie = new InterruptedIOException();
                                iie.initCause(interruptedException);
                                throw iie;
                            }
                        }
                    }
                    map = this.rsWriters;
                }
                catch (Throwable throwable) {
                    Map<String, RegionServerWriter> map2 = this.rsWriters;
                    synchronized (map2) {
                        for (Map.Entry<String, RegionServerWriter> entry : this.rsWriters.entrySet()) {
                            String locationKey = entry.getKey();
                            RegionServerWriter tmpW = entry.getValue();
                            try {
                                tmpW.close();
                            }
                            catch (IOException ioe) {
                                LOG.error((Object)("Couldn't close writer for region server:" + locationKey), (Throwable)ioe);
                                result.add(ioe);
                            }
                        }
                    }
                    map2 = this.tableNameToHConnectionMap;
                    synchronized (map2) {
                        for (Map.Entry<String, RegionServerWriter> entry : this.tableNameToHConnectionMap.entrySet()) {
                            TableName tableName = (TableName)entry.getKey();
                            HConnection hconn = (HConnection)entry.getValue();
                            try {
                                hconn.clearRegionCache();
                                hconn.close();
                            }
                            catch (IOException ioe) {
                                result.add(ioe);
                            }
                        }
                    }
                    this.writersClosed = true;
                    throw throwable;
                }
                synchronized (map) {
                    for (Map.Entry<String, RegionServerWriter> entry : this.rsWriters.entrySet()) {
                        String locationKey = entry.getKey();
                        RegionServerWriter tmpW = entry.getValue();
                        try {
                            tmpW.close();
                        }
                        catch (IOException ioe) {
                            LOG.error((Object)("Couldn't close writer for region server:" + locationKey), (Throwable)ioe);
                            result.add(ioe);
                        }
                    }
                }
                map = this.tableNameToHConnectionMap;
                synchronized (map) {
                    for (Map.Entry<String, RegionServerWriter> entry : this.tableNameToHConnectionMap.entrySet()) {
                        TableName tableName = (TableName)entry.getKey();
                        HConnection hconn = (HConnection)entry.getValue();
                        try {
                            hconn.clearRegionCache();
                            hconn.close();
                        }
                        catch (IOException ioe) {
                            result.add(ioe);
                        }
                    }
                }
                this.writersClosed = true;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<byte[], Long> getOutputCounts() {
            TreeMap<byte[], Long> ret = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            Map<String, RegionServerWriter> map = this.rsWriters;
            synchronized (map) {
                for (Map.Entry<String, RegionServerWriter> entry : this.rsWriters.entrySet()) {
                    ret.put(Bytes.toBytes((String)entry.getKey()), entry.getValue().editsWritten);
                }
            }
            return ret;
        }

        @Override
        public int getNumberOfRecoveredRegions() {
            return this.recoveredRegions.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionServerWriter getRegionServerWriter(String loc) throws IOException {
            RegionServerWriter ret = this.rsWriters.get(loc);
            if (ret != null) {
                return ret;
            }
            TableName tableName = this.getTableFromLocationStr(loc);
            if (tableName == null) {
                throw new IOException("Invalid location string:" + loc + " found. Replay aborted.");
            }
            HConnection hconn = this.getConnectionByTableName(tableName);
            Map<String, RegionServerWriter> map = this.rsWriters;
            synchronized (map) {
                ret = this.rsWriters.get(loc);
                if (ret == null) {
                    ret = new RegionServerWriter(WALSplitter.this.conf, tableName, hconn);
                    this.rsWriters.put(loc, ret);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HConnection getConnectionByTableName(TableName tableName) throws IOException {
            HConnection hconn = this.tableNameToHConnectionMap.get(tableName);
            if (hconn == null) {
                Map<TableName, HConnection> map = this.tableNameToHConnectionMap;
                synchronized (map) {
                    hconn = this.tableNameToHConnectionMap.get(tableName);
                    if (hconn == null) {
                        hconn = HConnectionManager.getConnection((Configuration)WALSplitter.this.conf);
                        this.tableNameToHConnectionMap.put(tableName, hconn);
                    }
                }
            }
            return hconn;
        }

        private TableName getTableFromLocationStr(String loc) {
            String[] splits = loc.split(KEY_DELIMITER);
            if (splits.length != 2) {
                return null;
            }
            return TableName.valueOf((String)splits[1]);
        }
    }

    private static final class WriterAndPath
    extends SinkWriter {
        final Path p;
        final WALProvider.Writer w;
        final long minLogSeqNum;

        WriterAndPath(Path p, WALProvider.Writer w, long minLogSeqNum) {
            this.p = p;
            this.w = w;
            this.minLogSeqNum = minLogSeqNum;
        }
    }

    public static abstract class SinkWriter {
        long editsWritten = 0L;
        long editsSkipped = 0L;
        long nanosSpent = 0L;

        void incrementEdits(int edits) {
            this.editsWritten += (long)edits;
        }

        void incrementSkippedEdits(int skipped) {
            this.editsSkipped += (long)skipped;
        }

        void incrementNanoTime(long nanos) {
            this.nanosSpent += nanos;
        }
    }

    class BoundedLogWriterCreationOutputSink
    extends LogRecoveredEditsOutputSink {
        ConcurrentHashMap<String, Long> regionRecoverStatMap;

        public BoundedLogWriterCreationOutputSink(PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
            super(controller, entryBuffers, numWriters);
            this.regionRecoverStatMap = new ConcurrentHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Path> finishWritingAndClose() throws IOException {
            List<Path> result;
            boolean isSuccessful;
            try {
                isSuccessful = this.finishWriting(false);
            }
            finally {
                result = this.close();
            }
            if (isSuccessful) {
                this.splits = result;
            }
            return this.splits;
        }

        @Override
        boolean executeCloseTask(CompletionService<Void> closeCompletionService, List<IOException> thrown, final List<Path> paths) throws InterruptedException, ExecutionException {
            for (final Map.Entry<byte[], RegionEntryBuffer> buffer : this.entryBuffers.buffers.entrySet()) {
                LOG.info((Object)("Submitting write then close of " + Bytes.toString((byte[])buffer.getValue().encodedRegionName)));
                closeCompletionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Path dst = BoundedLogWriterCreationOutputSink.this.writeThenClose((RegionEntryBuffer)buffer.getValue());
                        paths.add(dst);
                        return null;
                    }
                });
            }
            boolean progress_failed = false;
            int n = this.entryBuffers.buffers.size();
            for (int i = 0; i < n; ++i) {
                Future<Void> future = closeCompletionService.take();
                future.get();
                if (progress_failed || this.reporter == null || this.reporter.progress()) continue;
                progress_failed = true;
            }
            return progress_failed;
        }

        @Override
        public Map<byte[], Long> getOutputCounts() {
            HashMap<byte[], Long> regionRecoverStatMapResult = new HashMap<byte[], Long>();
            for (Map.Entry<String, Long> entry : this.regionRecoverStatMap.entrySet()) {
                regionRecoverStatMapResult.put(Bytes.toBytes((String)entry.getKey()), entry.getValue());
            }
            return regionRecoverStatMapResult;
        }

        @Override
        public int getNumberOfRecoveredRegions() {
            return this.regionRecoverStatMap.size();
        }

        @Override
        public void append(RegionEntryBuffer buffer) throws IOException {
            this.writeThenClose(buffer);
        }

        private Path writeThenClose(RegionEntryBuffer buffer) throws IOException {
            String encodedRegionName;
            Long value;
            WriterAndPath wap = this.appendBuffer(buffer, false);
            Path dst = null;
            if (wap != null && (value = this.regionRecoverStatMap.putIfAbsent(encodedRegionName = Bytes.toString((byte[])buffer.encodedRegionName), wap.editsWritten)) != null) {
                Long newValue = this.regionRecoverStatMap.get(encodedRegionName) + wap.editsWritten;
                this.regionRecoverStatMap.put(encodedRegionName, newValue);
            }
            ArrayList<IOException> thrown = new ArrayList<IOException>();
            if (wap != null) {
                dst = this.closeWriter(Bytes.toString((byte[])buffer.encodedRegionName), wap, thrown);
            }
            if (!thrown.isEmpty()) {
                throw MultipleIOException.createIOException(thrown);
            }
            return dst;
        }
    }

    class LogRecoveredEditsOutputSink
    extends OutputSink {
        public LogRecoveredEditsOutputSink(PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
            super(controller, entryBuffers, numWriters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Path> finishWritingAndClose() throws IOException {
            boolean isSuccessful = false;
            List<Path> result = null;
            try {
                isSuccessful = this.finishWriting(false);
            }
            finally {
                result = this.close();
                List<IOException> thrown = this.closeLogWriters(null);
                if (thrown != null && !thrown.isEmpty()) {
                    throw MultipleIOException.createIOException(thrown);
                }
            }
            if (isSuccessful) {
                this.splits = result;
            }
            return this.splits;
        }

        void deleteOneWithFewerEntries(WriterAndPath wap, Path dst) throws IOException {
            String errorMsg;
            long dstMinLogSeqNum;
            block19: {
                dstMinLogSeqNum = -1L;
                try (WAL.Reader reader = WALSplitter.this.walFactory.createReader(WALSplitter.this.walFS, dst);){
                    WAL.Entry entry = reader.next();
                    if (entry != null) {
                        dstMinLogSeqNum = entry.getKey().getLogSeqNum();
                    }
                }
                catch (EOFException e) {
                    if (!LOG.isDebugEnabled()) break block19;
                    LOG.debug((Object)("Got EOF when reading first WAL entry from " + dst + ", an empty or broken WAL file?"), (Throwable)e);
                }
            }
            if (wap.minLogSeqNum < dstMinLogSeqNum) {
                errorMsg = "Found existing old edits file. It could be the result of a previous failed split attempt or we have duplicated wal entries. Deleting " + dst + ", length=" + WALSplitter.this.walFS.getFileStatus(dst).getLen();
                LOG.warn((Object)errorMsg);
                this.updateStatusWithMsg(errorMsg);
                if (!WALSplitter.this.walFS.delete(dst, false)) {
                    String msg = "Failed deleting of old " + dst;
                    LOG.warn((Object)msg);
                    this.updateStatusWithMsg(msg);
                    throw new IOException("Failed deleting of old " + dst);
                }
            } else {
                errorMsg = "Found existing old edits file and we have less entries. Deleting " + wap.p + ", length=" + WALSplitter.this.walFS.getFileStatus(wap.p).getLen();
                LOG.warn((Object)errorMsg);
                this.updateStatusWithMsg(errorMsg);
                if (!WALSplitter.this.walFS.delete(wap.p, false)) {
                    String failureMsg = "Failed deleting of " + wap.p;
                    LOG.warn((Object)failureMsg);
                    this.updateStatusWithMsg(failureMsg);
                    throw new IOException(failureMsg);
                }
            }
        }

        List<Path> close() throws IOException {
            boolean progress_failed;
            Preconditions.checkState((!this.closeAndCleanCompleted ? 1 : 0) != 0);
            ArrayList<Path> paths = new ArrayList<Path>();
            ArrayList thrown = Lists.newArrayList();
            ThreadPoolExecutor closeThreadPool = Threads.getBoundedCachedThreadPool((int)this.numThreads, (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactory(){
                private int count = 1;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "split-log-closeStream-" + this.count++);
                    return t;
                }
            });
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(closeThreadPool);
            try {
                progress_failed = this.executeCloseTask(completionService, thrown, paths);
            }
            catch (InterruptedException e) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(e);
                throw iie;
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
            finally {
                closeThreadPool.shutdownNow();
            }
            if (!thrown.isEmpty()) {
                throw MultipleIOException.createIOException((List)thrown);
            }
            this.writersClosed = true;
            this.closeAndCleanCompleted = true;
            if (progress_failed) {
                return null;
            }
            return paths;
        }

        boolean executeCloseTask(CompletionService<Void> completionService, final List<IOException> thrown, final List<Path> paths) throws InterruptedException, ExecutionException {
            for (final Map.Entry writersEntry : this.writers.entrySet()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Submitting close of " + ((WriterAndPath)writersEntry.getValue()).p));
                }
                completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        WriterAndPath wap = (WriterAndPath)writersEntry.getValue();
                        Path dst = LogRecoveredEditsOutputSink.this.closeWriter((String)writersEntry.getKey(), wap, thrown);
                        paths.add(dst);
                        return null;
                    }
                });
            }
            boolean progress_failed = false;
            int n = this.writers.size();
            for (int i = 0; i < n; ++i) {
                Future<Void> future = completionService.take();
                future.get();
                if (progress_failed || this.reporter == null || this.reporter.progress()) continue;
                progress_failed = true;
            }
            return progress_failed;
        }

        Path closeWriter(String encodedRegionName, WriterAndPath wap, List<IOException> thrown) throws IOException {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Closing " + wap.p));
            }
            try {
                wap.w.close();
            }
            catch (IOException ioe) {
                String errorMsg = "Couldn't close log at " + wap.p;
                LOG.error((Object)errorMsg, (Throwable)ioe);
                this.updateStatusWithMsg(errorMsg);
                thrown.add(ioe);
                return null;
            }
            String msg = "Closed wap " + wap.p + " (wrote " + wap.editsWritten + " edits, skipped " + wap.editsSkipped + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msg);
            }
            this.updateStatusWithMsg(msg);
            if (wap.editsWritten == 0L) {
                if (WALSplitter.this.walFS.exists(wap.p) && !WALSplitter.this.walFS.delete(wap.p, false)) {
                    String errorMsg = "Failed deleting empty " + wap.p;
                    LOG.warn((Object)errorMsg);
                    throw new IOException("Failed deleting empty  " + wap.p);
                }
                return null;
            }
            Path dst = WALSplitter.getCompletedRecoveredEditsFilePath(wap.p, (Long)this.regionMaximumEditLogSeqNum.get(encodedRegionName));
            try {
                if (!dst.equals((Object)wap.p) && WALSplitter.this.walFS.exists(dst)) {
                    this.deleteOneWithFewerEntries(wap, dst);
                }
                if (WALSplitter.this.walFS.exists(wap.p)) {
                    if (!WALSplitter.this.walFS.rename(wap.p, dst)) {
                        String errorMsg = "Failed renaming " + wap.p + " to " + dst;
                        this.updateStatusWithMsg(errorMsg);
                        throw new IOException(errorMsg);
                    }
                    String renameLog = "Rename " + wap.p + " to " + dst;
                    LOG.info((Object)renameLog);
                    this.updateStatusWithMsg(renameLog);
                }
            }
            catch (IOException ioe) {
                String errorMsg = "Couldn't rename " + wap.p + " to " + dst;
                LOG.error((Object)errorMsg, (Throwable)ioe);
                this.updateStatusWithMsg(errorMsg);
                thrown.add(ioe);
                return null;
            }
            return dst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<IOException> closeLogWriters(List<IOException> thrown) throws IOException {
            WriterAndPath wap;
            if (this.writersClosed) {
                return thrown;
            }
            if (thrown == null) {
                thrown = Lists.newArrayList();
            }
            try {
                for (WriterThread t : this.writerThreads) {
                    while (t.isAlive()) {
                        t.shouldStop = true;
                        t.interrupt();
                        try {
                            t.join(10L);
                        }
                        catch (InterruptedException e) {
                            InterruptedIOException iie = new InterruptedIOException();
                            iie.initCause(e);
                            throw iie;
                        }
                    }
                }
                wap = null;
            }
            catch (Throwable throwable) {
                WriterAndPath wap2 = null;
                for (SinkWriter tmpWAP : this.writers.values()) {
                    try {
                        wap2 = (WriterAndPath)tmpWAP;
                        wap2.w.close();
                    }
                    catch (IOException ioe) {
                        String errorMsg = "Couldn't close log at " + wap2.p;
                        LOG.error((Object)errorMsg, (Throwable)ioe);
                        this.updateStatusWithMsg(errorMsg);
                        thrown.add(ioe);
                        continue;
                    }
                    String msg = "Closed log " + wap2.p + " (wrote " + wap2.editsWritten + " edits in " + wap2.nanosSpent / 1000L / 1000L + "ms)";
                    LOG.info((Object)msg);
                    this.updateStatusWithMsg(msg);
                }
                this.writersClosed = true;
                throw throwable;
            }
            for (SinkWriter tmpWAP : this.writers.values()) {
                try {
                    wap = (WriterAndPath)tmpWAP;
                    wap.w.close();
                }
                catch (IOException ioe) {
                    String errorMsg = "Couldn't close log at " + wap.p;
                    LOG.error((Object)errorMsg, (Throwable)ioe);
                    this.updateStatusWithMsg(errorMsg);
                    thrown.add(ioe);
                    continue;
                }
                String msg = "Closed log " + wap.p + " (wrote " + wap.editsWritten + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms)";
                LOG.info((Object)msg);
                this.updateStatusWithMsg(msg);
            }
            this.writersClosed = true;
            return thrown;
        }

        WriterAndPath getWriterAndPath(WAL.Entry entry, boolean reusable) throws IOException {
            byte[] region = entry.getKey().getEncodedRegionName();
            String regionName = Bytes.toString((byte[])region);
            WriterAndPath ret = (WriterAndPath)this.writers.get(regionName);
            if (ret != null) {
                return ret;
            }
            if (this.blacklistedRegions.contains(region)) {
                return null;
            }
            ret = this.createWAP(region, entry);
            if (ret == null) {
                this.blacklistedRegions.add(region);
                return null;
            }
            if (reusable) {
                this.writers.put(regionName, ret);
            }
            return ret;
        }

        WriterAndPath createWAP(byte[] region, WAL.Entry entry) throws IOException {
            String tmpDirName = WALSplitter.this.conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
            Path regionedits = WALSplitter.getRegionSplitEditsPath(entry, WALSplitter.this.fileBeingSplit.getPath().getName(), tmpDirName, WALSplitter.this.conf);
            if (regionedits == null) {
                return null;
            }
            if (WALSplitter.this.walFS.exists(regionedits)) {
                String warnMsg = "Found old edits file. It could be the result of a previous failed split attempt. Deleting " + regionedits + ", length=" + WALSplitter.this.walFS.getFileStatus(regionedits).getLen();
                LOG.warn((Object)warnMsg);
                this.updateStatusWithMsg(warnMsg);
                if (!WALSplitter.this.walFS.delete(regionedits, false)) {
                    String errorMsg = "Failed delete of old " + regionedits;
                    LOG.warn((Object)errorMsg);
                    this.updateStatusWithMsg(errorMsg);
                }
            }
            WALProvider.Writer w = WALSplitter.this.createWriter(regionedits);
            String msg = "Creating writer path=" + regionedits;
            LOG.debug((Object)msg);
            this.updateStatusWithMsg(msg);
            return new WriterAndPath(regionedits, w, entry.getKey().getLogSeqNum());
        }

        void filterCellByStore(WAL.Entry logEntry) {
            Map<byte[], Long> maxSeqIdInStores = WALSplitter.this.regionMaxSeqIdInStores.get(Bytes.toString((byte[])logEntry.getKey().getEncodedRegionName()));
            if (maxSeqIdInStores == null || maxSeqIdInStores.isEmpty()) {
                return;
            }
            ArrayList<Cell> keptCells = new ArrayList<Cell>(logEntry.getEdit().getCells().size());
            for (Cell cell : logEntry.getEdit().getCells()) {
                if (CellUtil.matchingFamily((Cell)cell, (byte[])WALEdit.METAFAMILY)) {
                    keptCells.add(cell);
                    continue;
                }
                byte[] family = CellUtil.cloneFamily((Cell)cell);
                Long maxSeqId = maxSeqIdInStores.get(family);
                if (maxSeqId != null && maxSeqId >= logEntry.getKey().getLogSeqNum()) continue;
                keptCells.add(cell);
            }
            logEntry.getEdit().setCells(keptCells);
        }

        @Override
        public void append(RegionEntryBuffer buffer) throws IOException {
            this.appendBuffer(buffer, true);
        }

        WriterAndPath appendBuffer(RegionEntryBuffer buffer, boolean reusable) throws IOException {
            List<WAL.Entry> entries = buffer.entryBuffer;
            if (entries.isEmpty()) {
                LOG.warn((Object)"got an empty buffer, skipping");
                return null;
            }
            SinkWriter wap = null;
            long startTime = System.nanoTime();
            int editsCount = 0;
            for (WAL.Entry logEntry : entries) {
                try {
                    if (wap == null && (wap = this.getWriterAndPath(logEntry, reusable)) == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("getWriterAndPath decided we don't need to write edits for " + logEntry));
                        }
                        return null;
                    }
                    this.filterCellByStore(logEntry);
                    if (!logEntry.getEdit().isEmpty()) {
                        ((WriterAndPath)wap).w.append(logEntry);
                        this.updateRegionMaximumEditLogSeqNum(logEntry);
                        ++editsCount;
                        continue;
                    }
                    wap.incrementSkippedEdits(1);
                }
                catch (IOException e) {
                    this.logAndThrowWriterAppendFailure(logEntry, e);
                }
            }
            wap.incrementEdits(editsCount);
            wap.incrementNanoTime(System.nanoTime() - startTime);
            return wap;
        }

        private void logAndThrowWriterAppendFailure(WAL.Entry logEntry, IOException e) throws IOException {
            e = RemoteExceptionHandler.checkIOException((IOException)e);
            String errorMsg = "Failed to write log entry " + logEntry.toString() + " to log";
            LOG.fatal((Object)errorMsg, (Throwable)e);
            this.updateStatusWithMsg(errorMsg);
            throw e;
        }

        @Override
        public boolean keepRegionEvent(WAL.Entry entry) {
            ArrayList<Cell> cells = entry.getEdit().getCells();
            for (int i = 0; i < cells.size(); ++i) {
                if (!WALEdit.isCompactionMarker(cells.get(i))) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<byte[], Long> getOutputCounts() {
            TreeMap<byte[], Long> ret = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            ConcurrentHashMap concurrentHashMap = this.writers;
            synchronized (concurrentHashMap) {
                for (Map.Entry entry : this.writers.entrySet()) {
                    ret.put(Bytes.toBytes((String)((String)entry.getKey())), ((SinkWriter)entry.getValue()).editsWritten);
                }
            }
            return ret;
        }

        @Override
        public int getNumberOfRecoveredRegions() {
            return this.writers.size();
        }
    }

    public static abstract class OutputSink {
        protected PipelineController controller;
        protected EntryBuffers entryBuffers;
        protected ConcurrentHashMap<String, SinkWriter> writers = new ConcurrentHashMap();
        protected ConcurrentHashMap<String, Long> regionMaximumEditLogSeqNum = new ConcurrentHashMap();
        protected final List<WriterThread> writerThreads = Lists.newArrayList();
        protected final Set<byte[]> blacklistedRegions = Collections.synchronizedSet(new TreeSet(Bytes.BYTES_COMPARATOR));
        protected boolean closeAndCleanCompleted = false;
        protected boolean writersClosed = false;
        protected final int numThreads;
        protected CancelableProgressable reporter = null;
        protected AtomicLong skippedEdits = new AtomicLong();
        protected List<Path> splits = null;
        protected MonitoredTask status = null;

        public OutputSink(PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
            this.numThreads = numWriters;
            this.controller = controller;
            this.entryBuffers = entryBuffers;
        }

        void setReporter(CancelableProgressable reporter) {
            this.reporter = reporter;
        }

        public synchronized void startWriterThreads() {
            for (int i = 0; i < this.numThreads; ++i) {
                WriterThread t = new WriterThread(this.controller, this.entryBuffers, this, i);
                t.start();
                this.writerThreads.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateRegionMaximumEditLogSeqNum(WAL.Entry entry) {
            ConcurrentHashMap<String, Long> concurrentHashMap = this.regionMaximumEditLogSeqNum;
            synchronized (concurrentHashMap) {
                String encodedRegionName = Bytes.toString((byte[])entry.getKey().getEncodedRegionName());
                Long currentMaxSeqNum = this.regionMaximumEditLogSeqNum.get(encodedRegionName);
                if (currentMaxSeqNum == null || entry.getKey().getLogSeqNum() > currentMaxSeqNum) {
                    this.regionMaximumEditLogSeqNum.put(encodedRegionName, entry.getKey().getLogSeqNum());
                }
            }
        }

        Long getRegionMaximumEditLogSeqNum(byte[] region) {
            return this.regionMaximumEditLogSeqNum.get(Bytes.toString((byte[])region));
        }

        int getNumOpenWriters() {
            return this.writers.size();
        }

        long getSkippedEdits() {
            return this.skippedEdits.get();
        }

        void setStatus(MonitoredTask status) {
            this.status = status;
        }

        protected boolean finishWriting(boolean interrupt) throws IOException {
            LOG.debug((Object)"Waiting for split writer threads to finish");
            boolean progress_failed = false;
            for (WriterThread t : this.writerThreads) {
                t.finish();
            }
            if (interrupt) {
                for (WriterThread t : this.writerThreads) {
                    t.interrupt();
                }
            }
            for (WriterThread t : this.writerThreads) {
                if (!progress_failed && this.reporter != null && !this.reporter.progress()) {
                    progress_failed = true;
                }
                try {
                    t.join();
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iie = new InterruptedIOException();
                    iie.initCause(ie);
                    throw iie;
                }
            }
            this.controller.checkForErrors();
            String msg = this.writerThreads.size() + " split writer threads finished";
            LOG.info((Object)msg);
            this.updateStatusWithMsg(msg);
            return !progress_failed;
        }

        public abstract List<Path> finishWritingAndClose() throws IOException;

        public abstract Map<byte[], Long> getOutputCounts();

        public abstract int getNumberOfRecoveredRegions();

        public abstract void append(RegionEntryBuffer var1) throws IOException;

        public boolean flush() throws IOException {
            return false;
        }

        public abstract boolean keepRegionEvent(WAL.Entry var1);

        protected final void updateStatusWithMsg(String msg) {
            if (this.status != null) {
                this.status.setStatus(msg);
            }
        }
    }

    public static class WriterThread
    extends Thread {
        private volatile boolean shouldStop = false;
        private PipelineController controller;
        private EntryBuffers entryBuffers;
        private OutputSink outputSink = null;

        WriterThread(PipelineController controller, EntryBuffers entryBuffers, OutputSink sink, int i) {
            super(Thread.currentThread().getName() + "-Writer-" + i);
            this.controller = controller;
            this.entryBuffers = entryBuffers;
            this.outputSink = sink;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                LOG.error((Object)"Exiting thread", t);
                this.controller.writerThreadError(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws IOException {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Writer thread starting");
            }
            while (true) {
                RegionEntryBuffer buffer;
                if ((buffer = this.entryBuffers.getChunkToWrite()) == null) {
                    Object object = this.controller.dataAvailable;
                    synchronized (object) {
                        block13: {
                            if (this.shouldStop && !this.outputSink.flush()) {
                                return;
                            }
                            try {
                                this.controller.dataAvailable.wait(500L);
                            }
                            catch (InterruptedException ie) {
                                if (this.shouldStop) break block13;
                                throw new RuntimeException(ie);
                            }
                        }
                    }
                }
                assert (buffer != null);
                try {
                    this.writeBuffer(buffer);
                    continue;
                }
                finally {
                    this.entryBuffers.doneWriting(buffer);
                    continue;
                }
                break;
            }
        }

        private void writeBuffer(RegionEntryBuffer buffer) throws IOException {
            this.outputSink.append(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish() {
            Object object = this.controller.dataAvailable;
            synchronized (object) {
                this.shouldStop = true;
                this.controller.dataAvailable.notifyAll();
            }
        }
    }

    public static class RegionEntryBuffer
    implements HeapSize {
        long heapInBuffer = 0L;
        List<WAL.Entry> entryBuffer;
        TableName tableName;
        byte[] encodedRegionName;

        RegionEntryBuffer(TableName tableName, byte[] region) {
            this.tableName = tableName;
            this.encodedRegionName = region;
            this.entryBuffer = new LinkedList<WAL.Entry>();
        }

        long appendEntry(WAL.Entry entry) {
            this.internify(entry);
            this.entryBuffer.add(entry);
            long incrHeap = entry.getEdit().heapSize() + (long)ClassSize.align((int)(2 * ClassSize.REFERENCE)) + 0L;
            this.heapInBuffer += incrHeap;
            return incrHeap;
        }

        private void internify(WAL.Entry entry) {
            WALKey k = entry.getKey();
            k.internTableName(this.tableName);
            k.internEncodedRegionName(this.encodedRegionName);
        }

        public long heapSize() {
            return this.heapInBuffer;
        }

        public byte[] getEncodedRegionName() {
            return this.encodedRegionName;
        }

        public List<WAL.Entry> getEntryBuffer() {
            return this.entryBuffer;
        }

        public TableName getTableName() {
            return this.tableName;
        }
    }

    public static class EntryBuffers {
        PipelineController controller;
        Map<byte[], RegionEntryBuffer> buffers = new TreeMap<byte[], RegionEntryBuffer>(Bytes.BYTES_COMPARATOR);
        Set<byte[]> currentlyWriting = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        long totalBuffered = 0L;
        final long maxHeapUsage;
        boolean splitWriterCreationBounded;

        public EntryBuffers(PipelineController controller, long maxHeapUsage) {
            this(controller, maxHeapUsage, false);
        }

        public EntryBuffers(PipelineController controller, long maxHeapUsage, boolean splitWriterCreationBounded) {
            this.controller = controller;
            this.maxHeapUsage = maxHeapUsage;
            this.splitWriterCreationBounded = splitWriterCreationBounded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendEntry(WAL.Entry entry) throws InterruptedException, IOException {
            long incrHeap;
            WALKey key = entry.getKey();
            Object object = this;
            synchronized (object) {
                RegionEntryBuffer buffer = this.buffers.get(key.getEncodedRegionName());
                if (buffer == null) {
                    buffer = new RegionEntryBuffer(key.getTablename(), key.getEncodedRegionName());
                    this.buffers.put(key.getEncodedRegionName(), buffer);
                }
                incrHeap = buffer.appendEntry(entry);
            }
            object = this.controller.dataAvailable;
            synchronized (object) {
                this.totalBuffered += incrHeap;
                while (this.totalBuffered > this.maxHeapUsage && this.controller.thrown.get() == null) {
                    LOG.debug((Object)("Used " + this.totalBuffered + " bytes of buffered edits, waiting for IO threads..."));
                    this.controller.dataAvailable.wait(2000L);
                }
                this.controller.dataAvailable.notifyAll();
            }
            this.controller.checkForErrors();
        }

        synchronized RegionEntryBuffer getChunkToWrite() {
            if (this.splitWriterCreationBounded && this.totalBuffered < this.maxHeapUsage) {
                return null;
            }
            long biggestSize = 0L;
            byte[] biggestBufferKey = null;
            for (Map.Entry<byte[], RegionEntryBuffer> entry : this.buffers.entrySet()) {
                long size = entry.getValue().heapSize();
                if (size <= biggestSize || this.currentlyWriting.contains(entry.getKey())) continue;
                biggestSize = size;
                biggestBufferKey = entry.getKey();
            }
            if (biggestBufferKey == null) {
                return null;
            }
            RegionEntryBuffer buffer = this.buffers.remove(biggestBufferKey);
            this.currentlyWriting.add(biggestBufferKey);
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doneWriting(RegionEntryBuffer buffer) {
            EntryBuffers entryBuffers = this;
            synchronized (entryBuffers) {
                boolean removed = this.currentlyWriting.remove(buffer.encodedRegionName);
                assert (removed);
            }
            long size = buffer.heapSize();
            Object object = this.controller.dataAvailable;
            synchronized (object) {
                this.totalBuffered -= size;
                this.controller.dataAvailable.notifyAll();
            }
        }

        synchronized boolean isRegionCurrentlyWriting(byte[] region) {
            return this.currentlyWriting.contains(region);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilDrained() {
            Object object = this.controller.dataAvailable;
            synchronized (object) {
                while (this.totalBuffered > 0L) {
                    try {
                        this.controller.dataAvailable.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Got interrupted while waiting for EntryBuffers is drained");
                        Thread.interrupted();
                        break;
                    }
                }
            }
        }
    }

    public static class PipelineController {
        AtomicReference<Throwable> thrown = new AtomicReference();
        public final Object dataAvailable = new Object();

        void writerThreadError(Throwable t) {
            this.thrown.compareAndSet(null, t);
        }

        void checkForErrors() throws IOException {
            Throwable thrown = this.thrown.get();
            if (thrown == null) {
                return;
            }
            if (thrown instanceof IOException) {
                throw new IOException(thrown);
            }
            throw new RuntimeException(thrown);
        }
    }
}

