/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import com.google.common.base.Preconditions;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.namequeues.DisruptorExceptionHandler;
import org.apache.hadoop.hbase.namequeues.LogEventHandler;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.RingBufferEnvelope;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class NamedQueueRecorder {
    private final Disruptor<RingBufferEnvelope> disruptor;
    private final LogEventHandler logEventHandler;
    private static NamedQueueRecorder namedQueueRecorder;
    private static boolean isInit;
    private static final Object LOCK;

    private NamedQueueRecorder(Configuration conf) {
        String hostingThreadName = Thread.currentThread().getName();
        int eventCount = conf.getInt("hbase.namedqueue.ringbuffer.size", 1024);
        this.disruptor = new Disruptor(this.getEventFactory(), this.getEventCount(eventCount), (Executor)Executors.newSingleThreadExecutor(Threads.getNamedThreadFactory((String)(hostingThreadName + ".slowlog.append-pool"))), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleExceptionsWith((ExceptionHandler)new DisruptorExceptionHandler());
        this.logEventHandler = new LogEventHandler(conf);
        this.disruptor.handleEventsWith((EventHandler[])new LogEventHandler[]{this.logEventHandler});
        this.disruptor.start();
    }

    private EventFactory<RingBufferEnvelope> getEventFactory() {
        return new EventFactory<RingBufferEnvelope>(){

            public RingBufferEnvelope newInstance() {
                return new RingBufferEnvelope();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedQueueRecorder getInstance(Configuration conf) {
        if (namedQueueRecorder != null) {
            return namedQueueRecorder;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!isInit) {
                namedQueueRecorder = new NamedQueueRecorder(conf);
                isInit = true;
            }
        }
        return namedQueueRecorder;
    }

    private int getEventCount(int eventCount) {
        Preconditions.checkArgument((eventCount >= 0 ? 1 : 0) != 0, (Object)"hbase.namedqueue.ringbuffer.size must be > 0");
        int floor = Integer.highestOneBit(eventCount);
        if (floor == eventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        return this.logEventHandler.getNamedQueueRecords(request);
    }

    public boolean clearNamedQueue(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        return this.logEventHandler.clearNamedQueue(namedQueueEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(NamedQueuePayload namedQueuePayload) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        long seqId = ringBuffer.next();
        try {
            ((RingBufferEnvelope)ringBuffer.get(seqId)).load(namedQueuePayload);
        }
        finally {
            ringBuffer.publish(seqId);
        }
    }

    public void persistAll(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        if (this.logEventHandler != null) {
            this.logEventHandler.persistAll(namedQueueEvent);
        }
    }

    static {
        isInit = false;
        LOCK = new Object();
    }
}

