/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;

@InterfaceAudience.Private
public class LogCleaner
extends CleanerChore<BaseLogCleanerDelegate>
implements ConfigurationObserver {
    private static final Log LOG = LogFactory.getLog((String)LogCleaner.class.getName());
    public static final String OLD_WALS_CLEANER_THREAD_SIZE = "hbase.oldwals.cleaner.thread.size";
    public static final int DEFAULT_OLD_WALS_CLEANER_THREAD_SIZE = 2;
    public static final String OLD_WALS_CLEANER_THREAD_TIMEOUT_MSEC = "hbase.oldwals.cleaner.thread.timeout.msec";
    static final long DEFAULT_OLD_WALS_CLEANER_THREAD_TIMEOUT_MSEC = 60000L;
    public static final String OLD_WALS_CLEANER_THREAD_CHECK_INTERVAL_MSEC = "hbase.oldwals.cleaner.thread.check.interval.msec";
    static final long DEFAULT_OLD_WALS_CLEANER_THREAD_CHECK_INTERVAL_MSEC = 500L;
    private final LinkedBlockingQueue<CleanerContext> pendingDelete = new LinkedBlockingQueue();
    private List<Thread> oldWALsCleaner;
    private long cleanerThreadTimeoutMsec;
    private long cleanerThreadCheckIntervalMsec;

    public LogCleaner(int p, Stoppable s, Configuration conf, FileSystem fs, Path oldLogDir, DirScanPool pool, Map<String, Object> params) {
        super("LogsCleaner", p, s, conf, fs, oldLogDir, "hbase.master.logcleaner.plugins", pool, params);
        int size = conf.getInt(OLD_WALS_CLEANER_THREAD_SIZE, 2);
        this.oldWALsCleaner = this.createOldWalsCleaner(size);
        this.cleanerThreadTimeoutMsec = conf.getLong(OLD_WALS_CLEANER_THREAD_TIMEOUT_MSEC, 60000L);
        this.cleanerThreadCheckIntervalMsec = conf.getLong(OLD_WALS_CLEANER_THREAD_CHECK_INTERVAL_MSEC, 500L);
    }

    @Override
    protected boolean validate(Path file) {
        return DefaultWALProvider.validateWALFilename(file.getName());
    }

    public void onConfigurationChange(Configuration conf) {
        int newSize = conf.getInt(OLD_WALS_CLEANER_THREAD_SIZE, 2);
        if (newSize == this.oldWALsCleaner.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Size from configuration is the same as previous which is " + newSize + ", no need to update."));
            }
            return;
        }
        this.interruptOldWALsCleaner();
        this.oldWALsCleaner = this.createOldWalsCleaner(newSize);
        this.cleanerThreadTimeoutMsec = conf.getLong(OLD_WALS_CLEANER_THREAD_TIMEOUT_MSEC, 60000L);
        this.cleanerThreadCheckIntervalMsec = conf.getLong(OLD_WALS_CLEANER_THREAD_CHECK_INTERVAL_MSEC, 500L);
    }

    @Override
    protected int deleteFiles(Iterable<FileStatus> filesToDelete) {
        LinkedList<CleanerContext> results = new LinkedList<CleanerContext>();
        for (FileStatus toDelete : filesToDelete) {
            CleanerContext context = CleanerContext.createCleanerContext(toDelete, this.cleanerThreadTimeoutMsec);
            if (context == null) continue;
            this.pendingDelete.add(context);
            results.add(context);
        }
        int deletedFiles = 0;
        for (CleanerContext res : results) {
            deletedFiles += res.getResult(this.cleanerThreadCheckIntervalMsec) ? 1 : 0;
        }
        return deletedFiles;
    }

    @Override
    public synchronized void cleanup() {
        super.cleanup();
        this.interruptOldWALsCleaner();
    }

    int getSizeOfCleaners() {
        return this.oldWALsCleaner.size();
    }

    long getCleanerThreadTimeoutMsec() {
        return this.cleanerThreadTimeoutMsec;
    }

    long getCleanerThreadCheckIntervalMsec() {
        return this.cleanerThreadCheckIntervalMsec;
    }

    private List<Thread> createOldWalsCleaner(int size) {
        LOG.info((Object)("Creating OldWALs cleaners with size=" + size));
        ArrayList<Thread> oldWALsCleaner = new ArrayList<Thread>(size);
        for (int i = 0; i < size; ++i) {
            Thread cleaner = new Thread(new Runnable(){

                @Override
                public void run() {
                    LogCleaner.this.deleteFile();
                }
            });
            cleaner.setName("OldWALsCleaner-" + i);
            cleaner.setDaemon(true);
            cleaner.start();
            oldWALsCleaner.add(cleaner);
        }
        return oldWALsCleaner;
    }

    private void interruptOldWALsCleaner() {
        for (Thread cleaner : this.oldWALsCleaner) {
            cleaner.interrupt();
        }
        this.oldWALsCleaner.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void deleteFile() {
        while (true) {
            context = null;
            succeed = false;
            interrupted = false;
            try {
                context = this.pendingDelete.take();
                if (context == null) continue;
                toClean = context.getTargetToClean();
                succeed = this.fs.delete(toClean.getPath(), false);
                continue;
            }
            catch (InterruptedException ite) {
                if (context != null) {
                    LogCleaner.LOG.warn((Object)("Interrupted while cleaning oldWALs " + context.getTargetToClean() + ", try to clean it next round."));
                }
                interrupted = true;
            }
            catch (IOException e) {
                LogCleaner.LOG.warn((Object)("Failed to clean oldwals with exception: " + e));
                succeed = false;
            }
            finally {
                if (context != null) {
                    context.setResult(succeed);
                }
                if (interrupted) ** break;
                continue;
                Thread.currentThread().interrupt();
            }
            break;
        }
        if (LogCleaner.LOG.isDebugEnabled()) {
            LogCleaner.LOG.debug((Object)"Exiting cleaner.");
        }
    }

    public synchronized void cancel(boolean mayInterruptIfRunning) {
        super.cancel(mayInterruptIfRunning);
        for (Thread t : this.oldWALsCleaner) {
            t.interrupt();
        }
    }

    private static final class CleanerContext {
        final FileStatus target;
        volatile boolean result;
        volatile boolean setFromCleaner = false;
        long timeoutMsec;

        static CleanerContext createCleanerContext(FileStatus status, long timeoutMsec) {
            return status != null ? new CleanerContext(status, timeoutMsec) : null;
        }

        private CleanerContext(FileStatus status, long timeoutMsec) {
            this.target = status;
            this.result = false;
            this.timeoutMsec = timeoutMsec;
        }

        synchronized void setResult(boolean res) {
            this.result = res;
            this.setFromCleaner = true;
            this.notify();
        }

        synchronized boolean getResult(long waitIfNotFinished) {
            long totalTimeMsec = 0L;
            try {
                while (!this.setFromCleaner) {
                    long startTimeNanos = System.nanoTime();
                    this.wait(waitIfNotFinished);
                    if ((totalTimeMsec += TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS)) < this.timeoutMsec) continue;
                    LOG.warn((Object)("Spend too much time " + totalTimeMsec + " ms to delete oldwals " + this.target));
                    return this.result;
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Interrupted while waiting deletion of " + this.target));
                return this.result;
            }
            return this.result;
        }

        FileStatus getTargetToClean() {
            return this.target;
        }
    }
}

