/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.regionserver.handler.WALSplitterHandler;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class ZkSplitLogWorkerCoordination
extends ZooKeeperListener
implements SplitLogWorkerCoordination {
    private static final Log LOG = LogFactory.getLog(ZkSplitLogWorkerCoordination.class);
    private static final int checkInterval = 5000;
    private static final int FAILED_TO_OWN_TASK = -1;
    private SplitLogWorker worker;
    private SplitLogWorker.TaskExecutor splitTaskExecutor;
    private final Object taskReadyLock = new Object();
    private AtomicInteger taskReadySeq = new AtomicInteger(0);
    private volatile String currentTask = null;
    private int currentVersion;
    private volatile boolean shouldStop = false;
    private final Object grabTaskLock = new Object();
    private boolean workerInGrabTask = false;
    private int reportPeriod;
    private RegionServerServices server = null;
    protected final AtomicInteger tasksInProgress = new AtomicInteger(0);
    private int maxConcurrentTasks = 0;
    private final ZkCoordinatedStateManager manager;

    public ZkSplitLogWorkerCoordination(ZkCoordinatedStateManager zkCoordinatedStateManager, ZooKeeperWatcher watcher) {
        super(watcher);
        this.manager = zkCoordinatedStateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.splitLogZNode)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("tasks arrived or departed on " + path));
            }
            Object object = this.taskReadyLock;
            synchronized (object) {
                this.taskReadySeq.incrementAndGet();
                this.taskReadyLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDataChanged(String path) {
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path)) {
                this.getDataSetWatchAsync();
            }
        }
    }

    @Override
    public void init(RegionServerServices server, Configuration conf, SplitLogWorker.TaskExecutor splitExecutor, SplitLogWorker worker) {
        this.server = server;
        this.worker = worker;
        this.splitTaskExecutor = splitExecutor;
        this.maxConcurrentTasks = conf.getInt("hbase.regionserver.wal.max.splitters", 2);
        this.reportPeriod = conf.getInt("hbase.splitlog.report.period", conf.getInt("hbase.splitlog.manager.timeout", 120000) / 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDataSetWatchFailure(String path) {
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path)) {
                LOG.info((Object)("retrying data watch on " + path));
                SplitLogCounters.tot_wkr_get_data_retry.incrementAndGet();
                this.getDataSetWatchAsync();
            }
        }
    }

    public void getDataSetWatchAsync() {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().getData(this.currentTask, (Watcher)this.watcher, (AsyncCallback.DataCallback)new GetDataAsyncCallback(), null);
        SplitLogCounters.tot_wkr_get_data_queued.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDataSetWatchSuccess(String path, byte[] data) {
        SplitLogTask slt;
        try {
            slt = SplitLogTask.parseFrom(data);
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return;
        }
        Object object = this.grabTaskLock;
        synchronized (object) {
            ServerName serverName;
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path) && !slt.isOwned(serverName = this.manager.getServer().getServerName()) && !slt.isDone(serverName) && !slt.isErr(serverName) && !slt.isResigned(serverName)) {
                LOG.info((Object)("task " + taskpath + " preempted from " + serverName + ", current task state and owner=" + slt.toString()));
                this.worker.stopTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean grabTask(String path) {
        Stat stat = new Stat();
        Object object = this.grabTaskLock;
        synchronized (object) {
            this.currentTask = path;
            this.workerInGrabTask = true;
            if (Thread.interrupted()) {
                return false;
            }
        }
        try {
            SplitLogTask slt;
            byte[] data;
            block46: {
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)this.watcher, (String)path, (Stat)stat);
                if (data == null) {
                    SplitLogCounters.tot_wkr_failed_to_grab_task_no_data.incrementAndGet();
                    boolean bl = false;
                    return bl;
                }
                break block46;
                catch (KeeperException e) {
                    LOG.warn((Object)("Failed to get data for znode " + path), (Throwable)e);
                    SplitLogCounters.tot_wkr_failed_to_grab_task_exception.incrementAndGet();
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                slt = SplitLogTask.parseFrom(data);
            }
            catch (DeserializationException e) {
                LOG.warn((Object)("Failed parse data for znode " + path), (Throwable)e);
                SplitLogCounters.tot_wkr_failed_to_grab_task_exception.incrementAndGet();
                boolean bl = false;
                Object object2 = this.grabTaskLock;
                synchronized (object2) {
                    this.workerInGrabTask = false;
                    Thread.interrupted();
                }
                return bl;
            }
            if (!slt.isUnassigned()) {
                SplitLogCounters.tot_wkr_failed_to_grab_task_owned.incrementAndGet();
                boolean e = false;
                return e;
            }
            this.currentVersion = ZkSplitLogWorkerCoordination.attemptToOwnTask(true, this.watcher, this.server.getServerName(), path, slt.getMode(), stat.getVersion());
            if (this.currentVersion < 0) {
                SplitLogCounters.tot_wkr_failed_to_grab_task_lost_race.incrementAndGet();
                boolean e = false;
                return e;
            }
            if (ZKSplitLog.isRescanNode(this.watcher, this.currentTask)) {
                ZkSplitTaskDetails splitTaskDetails = new ZkSplitTaskDetails();
                splitTaskDetails.setTaskNode(this.currentTask);
                splitTaskDetails.setCurTaskZKVersion(new MutableInt(this.currentVersion));
                this.endTask(new SplitLogTask.Done(this.server.getServerName(), slt.getMode()), SplitLogCounters.tot_wkr_task_acquired_rescan, splitTaskDetails);
                boolean bl = false;
                return bl;
            }
            LOG.info((Object)("worker " + this.server.getServerName() + " acquired task " + path));
            SplitLogCounters.tot_wkr_task_acquired.incrementAndGet();
            this.getDataSetWatchAsync();
            this.submitTask(path, slt.getMode(), this.currentVersion, this.reportPeriod);
            try {
                int sleepTime = RandomUtils.nextInt((int)500) + 500;
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted while yielding for other region servers", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Object object3 = this.grabTaskLock;
            synchronized (object3) {
                this.workerInGrabTask = false;
                Thread.interrupted();
            }
        }
    }

    void submitTask(final String curTask, final ZooKeeperProtos.SplitLogTask.RecoveryMode mode, int curTaskZKVersion, final int reportPeriod) {
        final MutableInt zkVersion = new MutableInt(curTaskZKVersion);
        CancelableProgressable reporter = new CancelableProgressable(){
            private long last_report_at = 0L;

            @Override
            public boolean progress() {
                long t = EnvironmentEdgeManager.currentTime();
                if (t - this.last_report_at > (long)reportPeriod) {
                    this.last_report_at = t;
                    int latestZKVersion = ZkSplitLogWorkerCoordination.attemptToOwnTask(false, ZkSplitLogWorkerCoordination.this.watcher, ZkSplitLogWorkerCoordination.this.server.getServerName(), curTask, mode, zkVersion.intValue());
                    if (latestZKVersion < 0) {
                        LOG.warn((Object)("Failed to heartbeat the task" + curTask));
                        return false;
                    }
                    zkVersion.setValue(latestZKVersion);
                }
                return true;
            }
        };
        ZkSplitTaskDetails splitTaskDetails = new ZkSplitTaskDetails();
        splitTaskDetails.setTaskNode(curTask);
        splitTaskDetails.setCurTaskZKVersion(zkVersion);
        WALSplitterHandler hsh = new WALSplitterHandler(this.server, this, splitTaskDetails, reporter, this.tasksInProgress, this.splitTaskExecutor, mode);
        this.server.getExecutorService().submit(hsh);
    }

    private boolean areSplittersAvailable() {
        return this.maxConcurrentTasks - this.tasksInProgress.get() > 0;
    }

    protected static int attemptToOwnTask(boolean isFirstTime, ZooKeeperWatcher zkw, ServerName server, String task, ZooKeeperProtos.SplitLogTask.RecoveryMode mode, int taskZKVersion) {
        int latestZKVersion = -1;
        try {
            SplitLogTask.Owned slt = new SplitLogTask.Owned(server, mode);
            Stat stat = zkw.getRecoverableZooKeeper().setData(task, slt.toByteArray(), taskZKVersion);
            if (stat == null) {
                LOG.warn((Object)("zk.setData() returned null for path " + task));
                SplitLogCounters.tot_wkr_task_heartbeat_failed.incrementAndGet();
                return -1;
            }
            latestZKVersion = stat.getVersion();
            SplitLogCounters.tot_wkr_task_heartbeat.incrementAndGet();
            return latestZKVersion;
        }
        catch (KeeperException e) {
            if (!isFirstTime) {
                if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                    LOG.warn((Object)("NONODE failed to assert ownership for " + task), (Throwable)e);
                } else if (e.code().equals((Object)KeeperException.Code.BADVERSION)) {
                    LOG.warn((Object)("BADVERSION failed to assert ownership for " + task), (Throwable)e);
                } else {
                    LOG.warn((Object)("failed to assert ownership for " + task), (Throwable)e);
                }
            }
        }
        catch (InterruptedException e1) {
            LOG.warn((Object)("Interrupted while trying to assert ownership of " + task + " " + StringUtils.stringifyException((Throwable)e1)));
            Thread.currentThread().interrupt();
        }
        SplitLogCounters.tot_wkr_task_heartbeat_failed.incrementAndGet();
        return -1;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void taskLoop() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getTaskList() throws InterruptedException {
        List childrenPaths = null;
        long sleepTime = 1000L;
        while (!this.shouldStop) {
            try {
                childrenPaths = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.watcher.splitLogZNode);
                if (childrenPaths != null) {
                    return childrenPaths;
                }
            }
            catch (KeeperException e) {
                LOG.warn((Object)("Could not get children of znode " + this.watcher.splitLogZNode), (Throwable)e);
            }
            LOG.debug((Object)("Retry listChildren of znode " + this.watcher.splitLogZNode + " after sleep for " + sleepTime + "ms!"));
            Thread.sleep(sleepTime);
        }
        return childrenPaths;
    }

    @Override
    public void markCorrupted(Path rootDir, String name, FileSystem fs) {
        ZKSplitLog.markCorrupted(rootDir, name, fs);
    }

    @Override
    public boolean isReady() throws InterruptedException {
        int result = -1;
        try {
            result = ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)this.watcher.splitLogZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Exception when checking for " + this.watcher.splitLogZNode + " ... retrying"), (Throwable)e);
        }
        if (result == -1) {
            LOG.info((Object)(this.watcher.splitLogZNode + " znode does not exist, waiting for master to create"));
            Thread.sleep(1000L);
        }
        return result != -1;
    }

    @Override
    public int getTaskReadySeq() {
        return this.taskReadySeq.get();
    }

    @Override
    public void registerListener() {
        this.watcher.registerListener((ZooKeeperListener)this);
    }

    @Override
    public void removeListener() {
        this.watcher.unregisterListener((ZooKeeperListener)this);
    }

    @Override
    public void stopProcessingTasks() {
        this.shouldStop = true;
    }

    @Override
    public boolean isStop() {
        return this.shouldStop;
    }

    @Override
    public ClusterStatusProtos.RegionStoreSequenceIds getRegionFlushedSequenceId(String failedServerName, String key) throws IOException {
        return ZKSplitLog.getRegionFlushedSequenceId(this.watcher, failedServerName, key);
    }

    @Override
    public void endTask(SplitLogTask slt, AtomicLong ctr, SplitLogWorkerCoordination.SplitTaskDetails details) {
        ZkSplitTaskDetails zkDetails = (ZkSplitTaskDetails)details;
        String task = zkDetails.getTaskNode();
        int taskZKVersion = zkDetails.getCurTaskZKVersion().intValue();
        try {
            if (ZKUtil.setData((ZooKeeperWatcher)this.watcher, (String)task, (byte[])slt.toByteArray(), (int)taskZKVersion)) {
                LOG.info((Object)("successfully transitioned task " + task + " to final state " + slt));
                ctr.incrementAndGet();
                return;
            }
            LOG.warn((Object)("failed to transistion task " + task + " to end state " + slt + " because of version mismatch "));
        }
        catch (KeeperException.BadVersionException bve) {
            LOG.warn((Object)("transisition task " + task + " to " + slt + " failed because of version mismatch"), (Throwable)bve);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.fatal((Object)("logic error - end task " + task + " " + slt + " failed because task doesn't exist"), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("failed to end task, " + task + " " + slt), (Throwable)e);
        }
        SplitLogCounters.tot_wkr_final_transition_failed.incrementAndGet();
    }

    public static class ZkSplitTaskDetails
    implements SplitLogWorkerCoordination.SplitTaskDetails {
        private String taskNode;
        private MutableInt curTaskZKVersion;

        public ZkSplitTaskDetails() {
        }

        public ZkSplitTaskDetails(String taskNode, MutableInt curTaskZKVersion) {
            this.taskNode = taskNode;
            this.curTaskZKVersion = curTaskZKVersion;
        }

        public String getTaskNode() {
            return this.taskNode;
        }

        public void setTaskNode(String taskNode) {
            this.taskNode = taskNode;
        }

        public MutableInt getCurTaskZKVersion() {
            return this.curTaskZKVersion;
        }

        public void setCurTaskZKVersion(MutableInt curTaskZKVersion) {
            this.curTaskZKVersion = curTaskZKVersion;
        }

        @Override
        public String getWALFile() {
            return ZKSplitLog.getFileName(this.taskNode);
        }
    }

    class GetDataAsyncCallback
    implements AsyncCallback.DataCallback {
        private final Log LOG = LogFactory.getLog(GetDataAsyncCallback.class);

        GetDataAsyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            SplitLogCounters.tot_wkr_get_data_result.incrementAndGet();
            if (rc != 0) {
                this.LOG.warn((Object)("getdata rc = " + KeeperException.Code.get((int)rc) + " " + path));
                ZkSplitLogWorkerCoordination.this.getDataSetWatchFailure(path);
                return;
            }
            data = ZkSplitLogWorkerCoordination.this.watcher.getRecoverableZooKeeper().removeMetaData(data);
            ZkSplitLogWorkerCoordination.this.getDataSetWatchSuccess(path, data);
        }
    }
}

