/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.AbstractHBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslOutputStream;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
public class HBaseSaslRpcClient
extends AbstractHBaseSaslRpcClient {
    private static final Log LOG = LogFactory.getLog(HBaseSaslRpcClient.class);

    public HBaseSaslRpcClient(AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed) throws IOException {
        super(method, token, serverPrincipal, fallbackAllowed);
    }

    public HBaseSaslRpcClient(AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed, String rpcProtection) throws IOException {
        super(method, token, serverPrincipal, fallbackAllowed, rpcProtection);
    }

    private static void readStatus(DataInputStream inStream) throws IOException {
        int status = inStream.readInt();
        if (status != SaslStatus.SUCCESS.state) {
            throw new RemoteException(WritableUtils.readString((DataInput)inStream), WritableUtils.readString((DataInput)inStream));
        }
    }

    public boolean saslConnect(InputStream inS, OutputStream outS) throws IOException {
        DataInputStream inStream = new DataInputStream(new BufferedInputStream(inS));
        DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(outS));
        try {
            byte[] saslToken = this.getInitialResponse();
            if (saslToken != null) {
                outStream.writeInt(saslToken.length);
                outStream.write(saslToken, 0, saslToken.length);
                outStream.flush();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Have sent token of size " + saslToken.length + " from initSASLContext."));
                }
            }
            if (!this.isComplete()) {
                HBaseSaslRpcClient.readStatus(inStream);
                int len = inStream.readInt();
                if (len == -88) {
                    if (!this.fallbackAllowed) {
                        throw new IOException("Server asks us to fall back to SIMPLE auth, but this client is configured to only allow secure connections.");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Server asks us to fall back to simple auth.");
                    }
                    this.dispose();
                    return false;
                }
                saslToken = new byte[len];
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will read input token of size " + saslToken.length + " for processing by initSASLContext"));
                }
                inStream.readFully(saslToken);
            }
            while (!this.isComplete()) {
                if ((saslToken = this.evaluateChallenge(saslToken)) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Will send token of size " + saslToken.length + " from initSASLContext."));
                    }
                    outStream.writeInt(saslToken.length);
                    outStream.write(saslToken, 0, saslToken.length);
                    outStream.flush();
                }
                if (this.isComplete()) continue;
                HBaseSaslRpcClient.readStatus(inStream);
                saslToken = new byte[inStream.readInt()];
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will read input token of size " + saslToken.length + " for processing by initSASLContext"));
                }
                inStream.readFully(saslToken);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SASL client context established. Negotiated QoP: " + this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")));
            }
            return true;
        }
        catch (IOException e) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException ignored) {
                // empty catch block
            }
            throw e;
        }
    }

    public InputStream getInputStream(InputStream in) throws IOException {
        if (!this.saslClient.isComplete()) {
            throw new IOException("Sasl authentication exchange hasn't completed yet");
        }
        return new SaslInputStream(in, this.saslClient);
    }

    public OutputStream getOutputStream(OutputStream out) throws IOException {
        if (!this.saslClient.isComplete()) {
            throw new IOException("Sasl authentication exchange hasn't completed yet");
        }
        return new SaslOutputStream(out, this.saslClient);
    }
}

