/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.common.resource;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.submarine.common.exception.SubmarineRuntimeException;
import org.apache.hadoop.yarn.submarine.common.resource.UnitsConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final String RES_PATTERN = "^[^=]+=\\d+\\s?\\w*$";
    private static final String SET_RESOURCE_VALUE_METHOD = "setResourceValue";
    private static final String SET_MEMORY_SIZE_METHOD = "setMemorySize";
    private static final String DEPRECATED_SET_MEMORY_SIZE_METHOD = "setMemory";
    private static final String GET_MEMORY_SIZE_METHOD = "getMemorySize";
    private static final String DEPRECATED_GET_MEMORY_SIZE_METHOD = "getMemory";
    private static final String GET_RESOURCE_VALUE_METHOD = "getResourceValue";
    private static final String GET_RESOURCE_TYPE_METHOD = "getResourcesTypeInfo";
    private static final String REINITIALIZE_RESOURCES_METHOD = "reinitializeResources";
    public static final String MEMORY_URI = "memory-mb";
    public static final String VCORES_URI = "vcores";
    public static final String GPU_URI = "yarn.io/gpu";
    public static final String FPGA_URI = "yarn.io/fpga";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static Resource createResourceFromString(String resourceStr) {
        Map<String, Long> typeToValue = ResourceUtils.parseResourcesString(resourceStr);
        Resource resource = Resource.newInstance((int)0, (int)0);
        for (Map.Entry<String, Long> entry : typeToValue.entrySet()) {
            if (entry.getKey().equals(VCORES_URI)) {
                resource.setVirtualCores(entry.getValue().intValue());
                continue;
            }
            if (entry.getKey().equals(MEMORY_URI)) {
                ResourceUtils.setMemorySize(resource, entry.getValue());
                continue;
            }
            ResourceUtils.setResource(resource, entry.getKey(), entry.getValue().intValue());
        }
        return resource;
    }

    private static Map<String, Long> parseResourcesString(String resourcesStr) {
        String[] pairs;
        HashMap<String, Long> resources = new HashMap<String, Long>();
        for (String resource : pairs = resourcesStr.trim().split(",")) {
            if (!(resource = resource.trim()).matches(RES_PATTERN)) {
                throw new IllegalArgumentException("\"" + resource + "\" is not a valid resource type/amount pair. Please provide key=amount pairs separated by commas.");
            }
            String[] splits = resource.split("=");
            String key = splits[0];
            String value = splits[1];
            String units = ResourceUtils.getUnits(value);
            String valueWithoutUnit = value.substring(0, value.length() - units.length()).trim();
            long resourceValue = Long.parseLong(valueWithoutUnit);
            if (units.equals("M") || units.equals("m")) {
                units = "Mi";
            } else if (units.equals("G") || units.equals("g")) {
                units = "Gi";
            } else if (!units.isEmpty()) {
                throw new IllegalArgumentException("Acceptable units are M/G or empty");
            }
            if (key.equals(MEMORY_URI) && !units.isEmpty()) {
                resourceValue = UnitsConversionUtil.convert(units, "Mi", resourceValue);
            }
            if (key.equals("memory")) {
                key = MEMORY_URI;
                resourceValue = UnitsConversionUtil.convert(units, "Mi", resourceValue);
            }
            if (key.equals("gpu")) {
                key = GPU_URI;
            }
            if (key.equals("fpga")) {
                key = FPGA_URI;
            }
            resources.put(key, resourceValue);
        }
        return resources;
    }

    public static void setResource(Resource resource, String resourceName, int resourceValue) {
        try {
            Method method = resource.getClass().getMethod(SET_RESOURCE_VALUE_METHOD, String.class, Long.TYPE);
            method.invoke((Object)resource, resourceName, resourceValue);
        }
        catch (NoSuchMethodException e) {
            LOG.error("There is no 'setResourceValue' API in thisversion of YARN", (Throwable)e);
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Failed to invoke 'setResourceValue' method to set GPU resources", (Throwable)e);
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
    }

    public static void setMemorySize(Resource resource, Long memorySize) {
        Method method;
        boolean useWithIntParameter = false;
        try {
            method = resource.getClass().getMethod(SET_MEMORY_SIZE_METHOD, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)resource, memorySize);
        }
        catch (NoSuchMethodException nsme) {
            LOG.info("There is no 'setMemorySize(long)' API in this version of YARN");
            useWithIntParameter = true;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Failed to invoke 'setMemorySize' method", (Throwable)e);
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
        if (useWithIntParameter) {
            try {
                LOG.info("Trying to use 'setMemory(int)' API for this version of YARN");
                method = resource.getClass().getMethod(DEPRECATED_SET_MEMORY_SIZE_METHOD, Integer.TYPE);
                method.invoke((Object)resource, memorySize.intValue());
            }
            catch (NoSuchMethodException e) {
                LOG.error("There is no 'setMemory(int)' API in this version of YARN", (Throwable)e);
                throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Failed to invoke 'setMemory' method", (Throwable)e);
                throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
            }
        }
    }

    public static long getMemorySize(Resource resource) {
        Method method;
        boolean useWithIntParameter = false;
        long memory = 0L;
        try {
            method = resource.getClass().getMethod(GET_MEMORY_SIZE_METHOD, new Class[0]);
            method.setAccessible(true);
            memory = (Long)method.invoke((Object)resource, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.info("There is no 'getMemorySize' API in this version of YARN");
            useWithIntParameter = true;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Failed to invoke 'getMemorySize' method", (Throwable)e);
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
        if (useWithIntParameter) {
            try {
                LOG.info("Trying to use 'getMemory' API for this version of YARN");
                method = resource.getClass().getMethod(DEPRECATED_GET_MEMORY_SIZE_METHOD, new Class[0]);
                method.setAccessible(true);
                memory = ((Integer)method.invoke((Object)resource, new Object[0])).longValue();
            }
            catch (NoSuchMethodException e) {
                LOG.error("There is no 'getMemory' API in this version of YARN", (Throwable)e);
                throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Failed to invoke 'getMemory' method", (Throwable)e);
                throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
            }
        }
        return memory;
    }

    public static long getResourceValue(Resource resource, String resourceName) {
        long resourceValue = 0L;
        try {
            Method method = resource.getClass().getMethod(GET_RESOURCE_VALUE_METHOD, String.class);
            Object value = method.invoke((Object)resource, resourceName);
            resourceValue = (Long)value;
        }
        catch (NoSuchMethodException e) {
            LOG.info("There is no 'getResourceValue' API in this version of YARN");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException().getClass().getName().equals("org.apache.hadoop.yarn.exceptions.ResourceNotFoundException")) {
                LOG.info("Not found resource " + resourceName);
            }
            LOG.info("Failed to invoke 'getResourceValue' method to get resource " + resourceName);
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
        catch (ClassCastException | IllegalAccessException e) {
            LOG.error("Failed to invoke 'getResourceValue' method to get resource " + resourceName, (Throwable)e);
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
        return resourceValue;
    }

    public static void configureResourceType(String resrouceName) {
        try {
            Class<?> resourceTypeInfo = Class.forName("org.apache.hadoop.yarn.api.records.ResourceTypeInfo");
            Class<?> resourceUtils = Class.forName("org.apache.hadoop.yarn.util.resource.ResourceUtils");
            Method method = resourceUtils.getMethod(GET_RESOURCE_TYPE_METHOD, new Class[0]);
            Object resTypes = method.invoke(null, new Object[0]);
            Method resourceTypeInstance = resourceTypeInfo.getMethod("newInstance", String.class, String.class);
            Object resourceType = resourceTypeInstance.invoke(null, resrouceName, "");
            ((ArrayList)resTypes).add(resourceType);
            Method reInitialMethod = resourceUtils.getMethod(REINITIALIZE_RESOURCES_METHOD, List.class);
            reInitialMethod.invoke(null, resTypes);
        }
        catch (ClassNotFoundException e) {
            LOG.info("There is no specified class API in this version of YARN");
            LOG.info(e.getMessage());
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
        catch (NoSuchMethodException nsme) {
            LOG.info("There is no 'getResourceValue' API in this version of YARN");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.info("Failed to invoke 'configureResourceType' method ", (Throwable)e);
            throw new SubmarineRuntimeException(e.getMessage(), e.getCause());
        }
    }

    private static String getUnits(String resourceValue) {
        return ResourceUtils.parseResourceValue(resourceValue)[0];
    }

    private static String[] parseResourceValue(String resourceValue) {
        int i;
        String[] resource = new String[2];
        for (i = 0; i < resourceValue.length() && !Character.isAlphabetic(resourceValue.charAt(i)); ++i) {
        }
        String units = resourceValue.substring(i);
        if (StringUtils.isAlpha((CharSequence)units) || units.equals("")) {
            resource[0] = units;
            resource[1] = resourceValue.substring(0, i);
            return resource;
        }
        throw new IllegalArgumentException("Units '" + units + "' contains non alphabet characters, which is not allowed.");
    }
}

