/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.common.conf;

import org.apache.hadoop.conf.Configuration;

public class SubmarineConfiguration
extends Configuration {
    private static final String SUBMARINE_CONFIGURATION_FILE = "submarine.xml";
    public static final String SUBMARINE_CONFIGURATION_PREFIX = "submarine.";
    public static final String SUBMARINE_LOCALIZATION_PREFIX = "submarine.localization.";
    public static final String LOCALIZATION_MAX_ALLOWED_FILE_SIZE_MB = "submarine.localization.max-allowed-file-size-mb";
    public static final long DEFAULT_MAX_ALLOWED_REMOTE_URI_SIZE_MB = 2048L;
    private static final String PREFIX = "submarine.";
    public static final String RUNTIME_CLASS = "submarine.runtime.class";
    public static final String DEFAULT_RUNTIME_CLASS = "org.apache.hadoop.yarn.submarine.runtimes.yarnservice.YarnServiceRuntimeFactory";

    public SubmarineConfiguration() {
        this(new Configuration(false), true);
    }

    public SubmarineConfiguration(Configuration configuration) {
        this(configuration, false);
    }

    public SubmarineConfiguration(Configuration configuration, boolean loadLocalConfig) {
        super(configuration);
        if (loadLocalConfig) {
            this.addResource(SUBMARINE_CONFIGURATION_FILE);
        }
    }

    public void setSubmarineRuntimeClass(String runtimeClass) {
        this.set(RUNTIME_CLASS, runtimeClass);
    }
}

