/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.runjob;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.AbstractCli;
import org.apache.hadoop.yarn.submarine.client.cli.CliUtils;
import org.apache.hadoop.yarn.submarine.client.cli.Command;
import org.apache.hadoop.yarn.submarine.client.cli.param.ParametersHolder;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.YamlConfigFile;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.YamlParseException;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.Framework;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.exception.SubmarineException;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobMonitor;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobSubmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class RunJobCli
extends AbstractCli {
    private static final Logger LOG = LoggerFactory.getLogger(RunJobCli.class);
    private static final String CAN_BE_USED_WITH_TF_PYTORCH = "Can be used with TensorFlow or PyTorch frameworks.";
    private static final String CAN_BE_USED_WITH_TF_ONLY = "Can only be used with TensorFlow framework.";
    public static final String YAML_PARSE_FAILED = "Failed to parse YAML config";
    private Options options = this.generateOptions();
    private JobSubmitter jobSubmitter;
    private JobMonitor jobMonitor;
    private ParametersHolder parametersHolder;

    public RunJobCli(ClientContext cliContext) {
        this(cliContext, cliContext.getRuntimeFactory().getJobSubmitterInstance(), cliContext.getRuntimeFactory().getJobMonitorInstance());
    }

    @VisibleForTesting
    public RunJobCli(ClientContext cliContext, JobSubmitter jobSubmitter, JobMonitor jobMonitor) {
        super(cliContext);
        this.jobSubmitter = jobSubmitter;
        this.jobMonitor = jobMonitor;
    }

    public void printUsages() {
        new HelpFormatter().printHelp("job run", this.options);
    }

    private Options generateOptions() {
        Options options = new Options();
        options.addOption("f", true, "Config file (in YAML format)");
        options.addOption("framework", true, String.format("Framework to use. Valid values are: %s! The default framework is Tensorflow.", Framework.getValues()));
        options.addOption("name", true, "Name of the job");
        options.addOption("input_path", true, "Input of the job, could be local or other FS directory");
        options.addOption("checkpoint_path", true, "Training output directory of the job, could be local or other FS directory. This typically includes checkpoint files and exported model ");
        options.addOption("saved_model_path", true, "Model exported path (savedmodel) of the job, which is needed when exported model is not placed under ${checkpoint_path}could be local or other FS directory. This will be used to serve.");
        options.addOption("docker_image", true, "Docker image name/tag");
        options.addOption("queue", true, "Name of queue to run the job, by default it uses default queue");
        this.addWorkerOptions(options);
        this.addPSOptions(options);
        this.addTensorboardOptions(options);
        options.addOption("env", true, "Common environment variable of worker/ps");
        options.addOption("verbose", false, "Print verbose log for troubleshooting");
        options.addOption("wait_job_finish", false, "Specified when user want to wait the job finish");
        options.addOption("quicklink", true, "Specify quicklink so YARNweb UI shows link to given role instance and port. When --tensorboard is specified, quicklink to tensorboard instance will be added automatically. The format of quick link is: Quick_link_label=http(or https)://role-name:port. For example, if want to link to first worker's 7070 port, and text of quicklink is Notebook_UI, user need to specify --quicklink Notebook_UI=https://master-0:7070");
        options.addOption("localization", true, "Specify localization to make remote/local file/directory available to all container(Docker). Argument format is \"RemoteUri:LocalFilePath[:rw] \" (ro permission is not supported yet) The RemoteUri can be a file or directory in local or HDFS or s3 or abfs or http .etc. The LocalFilePath can be absolute or relative. If it's a relative path, it'll be under container's implied working directory but sub directory is not supported yet. This option can be set mutiple times. Examples are \n-localization \"hdfs:///user/yarn/mydir2:/opt/data\"\n-localization \"s3a:///a/b/myfile1:./\"\n-localization \"https:///a/b/myfile2:./myfile\"\n-localization \"/user/yarn/mydir3:/opt/mydir3\"\n-localization \"./mydir1:.\"\n");
        options.addOption("keytab", true, "Specify keytab used by the job under security environment");
        options.addOption("principal", true, "Specify principal used by the job under security environment");
        options.addOption("distribute_keytab", false, "Distribute local keytab to cluster machines for service authentication. If not specified, pre-distributed keytab of which path specified by parameterkeytab on cluster machines will be used");
        options.addOption("h", "help", false, "Print help");
        options.addOption("insecure", false, "Cluster is not Kerberos enabled.");
        options.addOption("conf", true, "User specified configuration, as key=val pairs.");
        return options;
    }

    private void addWorkerOptions(Options options) {
        options.addOption("num_workers", true, "Number of worker tasks of the job, by default it's 1.Can be used with TensorFlow or PyTorch frameworks.");
        options.addOption("worker_docker_image", true, "Specify docker image for WORKER, when this is not specified, WORKER uses --docker_image as default.Can be used with TensorFlow or PyTorch frameworks.");
        options.addOption("worker_launch_cmd", true, "Commandline of worker, arguments will be directly used to launch the workerCan be used with TensorFlow or PyTorch frameworks.");
        options.addOption("worker_resources", true, "Resource of each worker, for example memory-mb=2048,vcores=2,yarn.io/gpu=2Can be used with TensorFlow or PyTorch frameworks.");
    }

    private void addPSOptions(Options options) {
        options.addOption("num_ps", true, "Number of PS tasks of the job, by default it's 0. Can only be used with TensorFlow framework.");
        options.addOption("ps_docker_image", true, "Specify docker image for PS, when this is not specified, PS uses --docker_image as default.Can only be used with TensorFlow framework.");
        options.addOption("ps_launch_cmd", true, "Commandline of worker, arguments will be directly used to launch the PSCan only be used with TensorFlow framework.");
        options.addOption("ps_resources", true, "Resource of each PS, for example memory-mb=2048,vcores=2,yarn.io/gpu=2Can only be used with TensorFlow framework.");
    }

    private void addTensorboardOptions(Options options) {
        options.addOption("tensorboard", false, "Should we run TensorBoard for this job? By default it's disabled.Can only be used with TensorFlow framework.");
        options.addOption("tensorboard_resources", true, "Specify resources of Tensorboard, by default it is memory=4G,vcores=1.Can only be used with TensorFlow framework.");
        options.addOption("tensorboard_docker_image", true, "Specify Tensorboard docker image. when this is not specified, Tensorboard uses --docker_image as default.Can only be used with TensorFlow framework.");
    }

    private void parseCommandLineAndGetRunJobParameters(String[] args) throws ParseException, IOException, YarnException {
        try {
            GnuParser parser = new GnuParser();
            CommandLine cli = parser.parse(this.options, args);
            this.parametersHolder = this.createParametersHolder(cli);
            this.parametersHolder.updateParameters(this.clientContext);
        }
        catch (ParseException e) {
            LOG.error("Exception in parse: {}", (Object)e.getMessage());
            this.printUsages();
            throw e;
        }
    }

    private ParametersHolder createParametersHolder(CommandLine cli) throws ParseException, YarnException {
        String yamlConfigFile = cli.getOptionValue("f");
        if (yamlConfigFile != null) {
            YamlConfigFile yamlConfig = this.readYamlConfigFile(yamlConfigFile);
            this.checkYamlConfig(yamlConfigFile, yamlConfig);
            LOG.info("Using YAML configuration!");
            return ParametersHolder.createWithCmdLineAndYaml(cli, yamlConfig, Command.RUN_JOB);
        }
        LOG.info("Using CLI configuration!");
        return ParametersHolder.createWithCmdLine(cli, Command.RUN_JOB);
    }

    private void checkYamlConfig(String yamlConfigFile, YamlConfigFile yamlConfig) {
        if (yamlConfig == null) {
            throw new YamlParseException(String.format("Failed to parse YAML config, file is empty: %s", yamlConfigFile));
        }
        if (yamlConfig.getConfigs() == null) {
            throw new YamlParseException(String.format("Failed to parse YAML config, config section should be defined, but it cannot be found in YAML file '%s'!", yamlConfigFile));
        }
    }

    private YamlConfigFile readYamlConfigFile(String filename) {
        Constructor constructor = new Constructor(YamlConfigFile.class);
        constructor.setPropertyUtils((PropertyUtils)new RunJobParameters.UnderscoreConverterPropertyUtils());
        try {
            LOG.info("Reading YAML configuration from file: {}", (Object)filename);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            return (YamlConfigFile)yaml.loadAs((InputStream)FileUtils.openInputStream((File)new File(filename)), YamlConfigFile.class);
        }
        catch (FileNotFoundException e) {
            this.logExceptionOfYamlParse(filename, e);
            throw new YamlParseException("Failed to parse YAML config, file does not exist!");
        }
        catch (Exception e) {
            this.logExceptionOfYamlParse(filename, e);
            throw new YamlParseException(String.format("Failed to parse YAML config, details: %s", e.getMessage()));
        }
    }

    private void logExceptionOfYamlParse(String filename, Exception e) {
        LOG.error(String.format("Exception while parsing YAML file %s", filename), (Throwable)e);
    }

    private void storeJobInformation(RunJobParameters parameters, ApplicationId applicationId, String[] args) throws IOException {
        String jobName = parameters.getName();
        HashMap<String, String> jobInfo = new HashMap<String, String>();
        jobInfo.put("JOB_NAME", jobName);
        jobInfo.put("APPLICATION_ID", applicationId.toString());
        if (parameters.getCheckpointPath() != null) {
            jobInfo.put("CHECKPOINT_PATH", parameters.getCheckpointPath());
        }
        if (parameters.getInputPath() != null) {
            jobInfo.put("INPUT_PATH", parameters.getInputPath());
        }
        if (parameters.getSavedModelPath() != null) {
            jobInfo.put("SAVED_MODEL_PATH", parameters.getSavedModelPath());
        }
        String joinedArgs = String.join((CharSequence)" ", args);
        jobInfo.put("JOB_RUN_ARGS", joinedArgs);
        this.clientContext.getRuntimeFactory().getSubmarineStorage().addNewJob(jobName, jobInfo);
    }

    @Override
    public int run(String[] args) throws ParseException, IOException, YarnException, SubmarineException {
        if (CliUtils.argsForHelp(args)) {
            this.printUsages();
            return 0;
        }
        this.parseCommandLineAndGetRunJobParameters(args);
        ApplicationId applicationId = this.jobSubmitter.submitJob(this.parametersHolder);
        RunJobParameters parameters = (RunJobParameters)this.parametersHolder.getParameters();
        this.storeJobInformation(parameters, applicationId, args);
        if (parameters.isWaitJobFinish()) {
            this.jobMonitor.waitTrainingFinal(parameters.getName());
        }
        return 0;
    }

    @VisibleForTesting
    public JobSubmitter getJobSubmitter() {
        return this.jobSubmitter;
    }

    @VisibleForTesting
    public RunJobParameters getRunJobParameters() {
        return (RunJobParameters)this.parametersHolder.getParameters();
    }
}

