/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param.runjob;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.CliUtils;
import org.apache.hadoop.yarn.submarine.client.cli.param.ParametersHolder;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.RoleParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.api.TensorFlowRole;
import org.apache.hadoop.yarn.submarine.common.resource.ResourceUtils;

public class TensorFlowRunJobParameters
extends RunJobParameters {
    private boolean tensorboardEnabled;
    private RoleParameters psParameters = RoleParameters.createEmpty(TensorFlowRole.PS);
    private RoleParameters tensorBoardParameters = RoleParameters.createEmpty(TensorFlowRole.TENSORBOARD);

    @Override
    public void updateParameters(ParametersHolder parametersHolder, ClientContext clientContext) throws ParseException, IOException, YarnException {
        super.updateParameters(parametersHolder, clientContext);
        String input = parametersHolder.getOptionValue("input_path");
        this.workerParameters = this.getWorkerParameters(clientContext, parametersHolder, input);
        this.psParameters = this.getPSParameters(clientContext, parametersHolder);
        this.distributed = this.determineIfDistributed(this.workerParameters.getReplicas(), this.psParameters.getReplicas());
        if (parametersHolder.hasOption("tensorboard")) {
            this.tensorboardEnabled = true;
            this.tensorBoardParameters = this.getTensorBoardParameters(parametersHolder, clientContext);
        }
        this.executePostOperations(clientContext);
    }

    @Override
    void executePostOperations(ClientContext clientContext) throws IOException {
        this.setDefaultDirs(clientContext);
        this.replacePatternsInParameters(clientContext);
    }

    private void replacePatternsInParameters(ClientContext clientContext) throws IOException {
        String afterReplace;
        if (StringUtils.isNotEmpty((CharSequence)this.getPSLaunchCmd())) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getPSLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setPSLaunchCmd(afterReplace);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getWorkerLaunchCmd())) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getWorkerLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setWorkerLaunchCmd(afterReplace);
        }
    }

    @Override
    public List<String> getLaunchCommands() {
        return Lists.newArrayList((Object[])new String[]{this.getWorkerLaunchCmd(), this.getPSLaunchCmd()});
    }

    private boolean determineIfDistributed(int nWorkers, int nPS) throws ParseException {
        if (nWorkers >= 2 && nPS > 0) {
            return true;
        }
        if (nWorkers <= 1 && nPS > 0) {
            throw new ParseException("Only specified one worker but non-zero PS, please double check.");
        }
        return false;
    }

    private RoleParameters getPSParameters(ClientContext clientContext, ParametersHolder parametersHolder) throws YarnException, IOException, ParseException {
        int nPS = this.getNumberOfPS(parametersHolder);
        Resource psResource = this.determinePSResource(parametersHolder, nPS, clientContext);
        String psDockerImage = parametersHolder.getOptionValue("ps_docker_image");
        String psLaunchCommand = parametersHolder.getOptionValue("ps_launch_cmd");
        return new RoleParameters(TensorFlowRole.PS, nPS, psLaunchCommand, psDockerImage, psResource);
    }

    private Resource determinePSResource(ParametersHolder parametersHolder, int nPS, ClientContext clientContext) throws ParseException, YarnException, IOException {
        if (nPS > 0) {
            String psResourceStr = parametersHolder.getOptionValue("ps_resources");
            if (psResourceStr == null) {
                throw new ParseException("--ps_resources is absent.");
            }
            return ResourceUtils.createResourceFromString(psResourceStr);
        }
        return null;
    }

    private int getNumberOfPS(ParametersHolder parametersHolder) throws YarnException {
        int nPS = 0;
        if (parametersHolder.getOptionValue("num_ps") != null) {
            nPS = Integer.parseInt(parametersHolder.getOptionValue("num_ps"));
        }
        return nPS;
    }

    private RoleParameters getTensorBoardParameters(ParametersHolder parametersHolder, ClientContext clientContext) throws YarnException, IOException {
        String tensorboardResourceStr = parametersHolder.getOptionValue("tensorboard_resources");
        if (tensorboardResourceStr == null || tensorboardResourceStr.isEmpty()) {
            tensorboardResourceStr = "memory=4G,vcores=1";
        }
        Resource tensorboardResource = ResourceUtils.createResourceFromString(tensorboardResourceStr);
        String tensorboardDockerImage = parametersHolder.getOptionValue("tensorboard_docker_image");
        return new RoleParameters(TensorFlowRole.TENSORBOARD, 1, null, tensorboardDockerImage, tensorboardResource);
    }

    public int getNumPS() {
        return this.psParameters.getReplicas();
    }

    public void setNumPS(int numPS) {
        this.psParameters.setReplicas(numPS);
    }

    public Resource getPsResource() {
        return this.psParameters.getResource();
    }

    public void setPsResource(Resource resource) {
        this.psParameters.setResource(resource);
    }

    public String getPsDockerImage() {
        return this.psParameters.getDockerImage();
    }

    public void setPsDockerImage(String image) {
        this.psParameters.setDockerImage(image);
    }

    public String getPSLaunchCmd() {
        return this.psParameters.getLaunchCommand();
    }

    public void setPSLaunchCmd(String launchCmd) {
        this.psParameters.setLaunchCommand(launchCmd);
    }

    public boolean isTensorboardEnabled() {
        return this.tensorboardEnabled;
    }

    public Resource getTensorboardResource() {
        return this.tensorBoardParameters.getResource();
    }

    public void setTensorboardResource(Resource resource) {
        this.tensorBoardParameters.setResource(resource);
    }

    public String getTensorboardDockerImage() {
        return this.tensorBoardParameters.getDockerImage();
    }

    public void setTensorboardDockerImage(String image) {
        this.tensorBoardParameters.setDockerImage(image);
    }
}

