/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param.runjob;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.CliUtils;
import org.apache.hadoop.yarn.submarine.client.cli.param.Localization;
import org.apache.hadoop.yarn.submarine.client.cli.param.ParametersHolder;
import org.apache.hadoop.yarn.submarine.client.cli.param.Quicklink;
import org.apache.hadoop.yarn.submarine.client.cli.param.RunParameters;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.RoleParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.api.TensorFlowRole;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.common.resource.ResourceUtils;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public abstract class RunJobParameters
extends RunParameters {
    private String input;
    private String checkpointPath;
    private List<Quicklink> quicklinks = new ArrayList<Quicklink>();
    private List<Localization> localizations = new ArrayList<Localization>();
    private boolean waitJobFinish = false;
    protected boolean distributed = false;
    private boolean securityDisabled = false;
    private String keytab;
    private String principal;
    private boolean distributeKeytab = false;
    private List<String> confPairs = new ArrayList<String>();
    RoleParameters workerParameters = RoleParameters.createEmpty(TensorFlowRole.WORKER);

    @Override
    public void updateParameters(ParametersHolder parametersHolder, ClientContext clientContext) throws ParseException, IOException, YarnException {
        List<String> localizationsStr;
        List<String> quicklinkStrs;
        String input = parametersHolder.getOptionValue("input_path");
        String jobDir = parametersHolder.getOptionValue("checkpoint_path");
        if (parametersHolder.hasOption("insecure")) {
            this.setSecurityDisabled(true);
        }
        String kerberosKeytab = parametersHolder.getOptionValue("keytab");
        String kerberosPrincipal = parametersHolder.getOptionValue("principal");
        CliUtils.doLoginIfSecure(kerberosKeytab, kerberosPrincipal);
        if (parametersHolder.hasOption("wait_job_finish")) {
            this.waitJobFinish = true;
        }
        if ((quicklinkStrs = parametersHolder.getOptionValues("quicklink")) != null) {
            for (String string : quicklinkStrs) {
                Quicklink quicklink = new Quicklink();
                quicklink.parse(string);
                this.quicklinks.add(quicklink);
            }
        }
        if (null != (localizationsStr = parametersHolder.getOptionValues("localization"))) {
            for (String loc : localizationsStr) {
                Localization localization = new Localization();
                localization.parse(loc);
                this.localizations.add(localization);
            }
        }
        boolean bl = parametersHolder.hasOption("distribute_keytab");
        List<String> configPairs = parametersHolder.getOptionValues("conf");
        this.setInputPath(input).setCheckpointPath(jobDir).setKeytab(kerberosKeytab).setPrincipal(kerberosPrincipal).setDistributeKeytab(bl).setConfPairs(configPairs);
        super.updateParameters(parametersHolder, clientContext);
    }

    abstract void executePostOperations(ClientContext var1) throws IOException;

    void setDefaultDirs(ClientContext clientContext) throws IOException {
        String savedModelDir;
        String jobDir = this.getCheckpointPath();
        if (jobDir == null) {
            jobDir = this.getJobDir(clientContext);
            this.setCheckpointPath(jobDir);
        }
        if (this.getNumWorkers() > 0 && (savedModelDir = this.getSavedModelPath()) == null) {
            savedModelDir = jobDir;
            this.setSavedModelPath(savedModelDir);
        }
    }

    private String getJobDir(ClientContext clientContext) throws IOException {
        RemoteDirectoryManager rdm = clientContext.getRemoteDirectoryManager();
        if (this.getNumWorkers() > 0) {
            return rdm.getJobCheckpointDir(this.getName(), true).toString();
        }
        return rdm.getUserRootFolder().toString();
    }

    public abstract List<String> getLaunchCommands();

    public String getInputPath() {
        return this.input;
    }

    public RunJobParameters setInputPath(String input) {
        this.input = input;
        return this;
    }

    public String getCheckpointPath() {
        return this.checkpointPath;
    }

    public RunJobParameters setCheckpointPath(String checkpointPath) {
        this.checkpointPath = checkpointPath;
        return this;
    }

    public boolean isWaitJobFinish() {
        return this.waitJobFinish;
    }

    public List<Quicklink> getQuicklinks() {
        return this.quicklinks;
    }

    public List<Localization> getLocalizations() {
        return this.localizations;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public RunJobParameters setKeytab(String kerberosKeytab) {
        this.keytab = kerberosKeytab;
        return this;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public RunJobParameters setPrincipal(String kerberosPrincipal) {
        this.principal = kerberosPrincipal;
        return this;
    }

    public boolean isSecurityDisabled() {
        return this.securityDisabled;
    }

    public void setSecurityDisabled(boolean securityDisabled) {
        this.securityDisabled = securityDisabled;
    }

    public boolean isDistributeKeytab() {
        return this.distributeKeytab;
    }

    public RunJobParameters setDistributeKeytab(boolean distributeKerberosKeytab) {
        this.distributeKeytab = distributeKerberosKeytab;
        return this;
    }

    public List<String> getConfPairs() {
        return this.confPairs;
    }

    public RunJobParameters setConfPairs(List<String> confPairs) {
        this.confPairs = confPairs;
        return this;
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    RoleParameters getWorkerParameters(ClientContext clientContext, ParametersHolder parametersHolder, String input) throws ParseException, YarnException, IOException {
        int nWorkers = this.getNumberOfWorkers(parametersHolder, input);
        Resource workerResource = this.determineWorkerResource(parametersHolder, nWorkers, clientContext);
        String workerDockerImage = parametersHolder.getOptionValue("worker_docker_image");
        String workerLaunchCmd = parametersHolder.getOptionValue("worker_launch_cmd");
        return new RoleParameters(TensorFlowRole.WORKER, nWorkers, workerLaunchCmd, workerDockerImage, workerResource);
    }

    private Resource determineWorkerResource(ParametersHolder parametersHolder, int nWorkers, ClientContext clientContext) throws ParseException, YarnException, IOException {
        if (nWorkers > 0) {
            String workerResourceStr = parametersHolder.getOptionValue("worker_resources");
            if (workerResourceStr == null) {
                throw new ParseException("--worker_resources is absent.");
            }
            return ResourceUtils.createResourceFromString(workerResourceStr);
        }
        return null;
    }

    private int getNumberOfWorkers(ParametersHolder parametersHolder, String input) throws ParseException, YarnException {
        int nWorkers = 1;
        if (parametersHolder.getOptionValue("num_workers") != null) {
            nWorkers = Integer.parseInt(parametersHolder.getOptionValue("num_workers"));
            if (null == input && 0 != nWorkers) {
                throw new ParseException("\"--input_path\" is absent");
            }
        }
        return nWorkers;
    }

    public String getWorkerLaunchCmd() {
        return this.workerParameters.getLaunchCommand();
    }

    public void setWorkerLaunchCmd(String launchCmd) {
        this.workerParameters.setLaunchCommand(launchCmd);
    }

    public int getNumWorkers() {
        return this.workerParameters.getReplicas();
    }

    public void setNumWorkers(int numWorkers) {
        this.workerParameters.setReplicas(numWorkers);
    }

    public Resource getWorkerResource() {
        return this.workerParameters.getResource();
    }

    public void setWorkerResource(Resource resource) {
        this.workerParameters.setResource(resource);
    }

    public String getWorkerDockerImage() {
        return this.workerParameters.getDockerImage();
    }

    public void setWorkerDockerImage(String image) {
        this.workerParameters.setDockerImage(image);
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    @VisibleForTesting
    public static class UnderscoreConverterPropertyUtils
    extends PropertyUtils {
        public Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
            if (name.indexOf(95) > -1) {
                name = UnderscoreConverterPropertyUtils.convertName(name);
            }
            return super.getProperty(type, name);
        }

        private static String convertName(String name) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
    }
}

