/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param.runjob;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.CliUtils;
import org.apache.hadoop.yarn.submarine.client.cli.param.ParametersHolder;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;

public class PyTorchRunJobParameters
extends RunJobParameters {
    private static final String CANNOT_BE_DEFINED_FOR_PYTORCH = "cannot be defined for PyTorch jobs!";

    @Override
    public void updateParameters(ParametersHolder parametersHolder, ClientContext clientContext) throws ParseException, IOException, YarnException {
        this.checkArguments(parametersHolder);
        super.updateParameters(parametersHolder, clientContext);
        String input = parametersHolder.getOptionValue("input_path");
        this.workerParameters = this.getWorkerParameters(clientContext, parametersHolder, input);
        this.distributed = this.determineIfDistributed(this.workerParameters.getReplicas());
        this.executePostOperations(clientContext);
    }

    private void checkArguments(ParametersHolder parametersHolder) throws YarnException, ParseException {
        if (parametersHolder.getOptionValue("num_ps") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("num_ps"));
        }
        if (parametersHolder.getOptionValue("ps_resources") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("ps_resources"));
        }
        if (parametersHolder.getOptionValue("ps_docker_image") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("ps_docker_image"));
        }
        if (parametersHolder.getOptionValue("ps_launch_cmd") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("ps_launch_cmd"));
        }
        if (parametersHolder.hasOption("tensorboard")) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("tensorboard"));
        }
        if (parametersHolder.getOptionValue("tensorboard_resources") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("tensorboard_resources"));
        }
        if (parametersHolder.getOptionValue("tensorboard_docker_image") != null) {
            throw new ParseException(this.getParamCannotBeDefinedErrorMessage("tensorboard_docker_image"));
        }
    }

    private String getParamCannotBeDefinedErrorMessage(String cliName) {
        return String.format("Parameter '%s' cannot be defined for PyTorch jobs!", cliName);
    }

    @Override
    void executePostOperations(ClientContext clientContext) throws IOException {
        this.setDefaultDirs(clientContext);
        this.replacePatternsInParameters(clientContext);
    }

    private void replacePatternsInParameters(ClientContext clientContext) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)this.getWorkerLaunchCmd())) {
            String afterReplace = CliUtils.replacePatternsInLaunchCommand(this.getWorkerLaunchCmd(), this, clientContext.getRemoteDirectoryManager());
            this.setWorkerLaunchCmd(afterReplace);
        }
    }

    @Override
    public List<String> getLaunchCommands() {
        return Lists.newArrayList((Object[])new String[]{this.getWorkerLaunchCmd()});
    }

    private boolean determineIfDistributed(int nWorkers) {
        return false;
    }
}

