/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.Command;
import org.apache.hadoop.yarn.submarine.client.cli.param.BaseParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.ConfigType;
import org.apache.hadoop.yarn.submarine.client.cli.param.ShowJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.PyTorchRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.Configs;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.Role;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.Roles;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.Scheduling;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.Security;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.TensorBoard;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.YamlConfigFile;
import org.apache.hadoop.yarn.submarine.client.cli.param.yaml.YamlParseException;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.Framework;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParametersHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ParametersHolder.class);
    public static final String SUPPORTED_FRAMEWORKS_MESSAGE = "TensorFlow and PyTorch are the only supported frameworks for now!";
    public static final String SUPPORTED_COMMANDS_MESSAGE = "'Show job' and 'run job' are the only supported commands for now!";
    private final CommandLine parsedCommandLine;
    private final Map<String, String> yamlStringConfigs;
    private final Map<String, List<String>> yamlListConfigs;
    private final ConfigType configType;
    private Command command;
    private final Set onlyDefinedWithCliArgs = ImmutableSet.of((Object)"verbose");
    private final Framework framework;
    private final BaseParameters parameters;

    private ParametersHolder(CommandLine parsedCommandLine, YamlConfigFile yamlConfig, ConfigType configType, Command command) throws ParseException, YarnException {
        this.parsedCommandLine = parsedCommandLine;
        this.yamlStringConfigs = this.initStringConfigValues(yamlConfig);
        this.yamlListConfigs = this.initListConfigValues(yamlConfig);
        this.configType = configType;
        this.command = command;
        this.framework = this.determineFrameworkType();
        this.ensureOnlyValidSectionsAreDefined(yamlConfig);
        this.parameters = this.createParameters();
    }

    private BaseParameters createParameters() {
        if (this.command == Command.RUN_JOB) {
            if (this.framework == Framework.TENSORFLOW) {
                return new TensorFlowRunJobParameters();
            }
            if (this.framework == Framework.PYTORCH) {
                return new PyTorchRunJobParameters();
            }
            throw new UnsupportedOperationException(SUPPORTED_FRAMEWORKS_MESSAGE);
        }
        if (this.command == Command.SHOW_JOB) {
            return new ShowJobParameters();
        }
        throw new UnsupportedOperationException(SUPPORTED_COMMANDS_MESSAGE);
    }

    private void ensureOnlyValidSectionsAreDefined(YamlConfigFile yamlConfig) {
        if (this.isCommandRunJob() && this.isFrameworkPyTorch() && this.isPsSectionDefined(yamlConfig)) {
            throw new YamlParseException("PS section should not be defined when PyTorch is the selected framework!");
        }
        if (this.isCommandRunJob() && this.isFrameworkPyTorch() && this.isTensorboardSectionDefined(yamlConfig)) {
            throw new YamlParseException("TensorBoard section should not be defined when PyTorch is the selected framework!");
        }
    }

    private boolean isCommandRunJob() {
        return this.command == Command.RUN_JOB;
    }

    private boolean isFrameworkPyTorch() {
        return this.framework == Framework.PYTORCH;
    }

    private boolean isPsSectionDefined(YamlConfigFile yamlConfig) {
        return yamlConfig != null && yamlConfig.getRoles() != null && yamlConfig.getRoles().getPs() != null;
    }

    private boolean isTensorboardSectionDefined(YamlConfigFile yamlConfig) {
        return yamlConfig != null && yamlConfig.getTensorBoard() != null;
    }

    private Framework determineFrameworkType() throws ParseException, YarnException {
        if (!this.isCommandRunJob()) {
            return null;
        }
        String frameworkStr = this.getOptionValue("framework");
        if (frameworkStr == null) {
            LOG.info("Framework is not defined in config, falling back to TensorFlow as a default.");
            return Framework.TENSORFLOW;
        }
        Framework framework = Framework.parseByValue(frameworkStr);
        if (framework == null) {
            if (this.getConfigType() == ConfigType.CLI) {
                throw new ParseException("Failed to parse Framework type! Valid values are: " + Framework.getValues());
            }
            throw new YamlParseException("Failed to parse YAML config, framework should is defined, but it has an invalid value! Valid values are: " + Framework.getValues());
        }
        return framework;
    }

    private Map<String, String> initStringConfigValues(YamlConfigFile yamlConfig) {
        if (yamlConfig == null) {
            return Collections.emptyMap();
        }
        HashMap yamlConfigValues = Maps.newHashMap();
        Roles roles = yamlConfig.getRoles();
        this.initGenericConfigs(yamlConfig, yamlConfigValues);
        this.initPs(yamlConfigValues, roles.getPs());
        this.initWorker(yamlConfigValues, roles.getWorker());
        this.initScheduling(yamlConfigValues, yamlConfig.getScheduling());
        this.initSecurity(yamlConfigValues, yamlConfig.getSecurity());
        this.initTensorBoard(yamlConfigValues, yamlConfig.getTensorBoard());
        return yamlConfigValues;
    }

    private Map<String, List<String>> initListConfigValues(YamlConfigFile yamlConfig) {
        if (yamlConfig == null) {
            return Collections.emptyMap();
        }
        HashMap yamlConfigValues = Maps.newHashMap();
        Configs configs = yamlConfig.getConfigs();
        yamlConfigValues.put("localization", configs.getLocalizations());
        yamlConfigValues.put("env", this.convertToEnvsList(configs.getEnvs()));
        yamlConfigValues.put("quicklink", configs.getQuicklinks());
        return yamlConfigValues;
    }

    private void initGenericConfigs(YamlConfigFile yamlConfig, Map<String, String> yamlConfigs) {
        yamlConfigs.put("name", yamlConfig.getSpec().getName());
        yamlConfigs.put("framework", yamlConfig.getSpec().getFramework());
        Configs configs = yamlConfig.getConfigs();
        yamlConfigs.put("input_path", configs.getInputPath());
        yamlConfigs.put("checkpoint_path", configs.getCheckpointPath());
        yamlConfigs.put("saved_model_path", configs.getSavedModelPath());
        yamlConfigs.put("docker_image", configs.getDockerImage());
        yamlConfigs.put("wait_job_finish", configs.getWaitJobFinish());
    }

    private void initPs(Map<String, String> yamlConfigs, Role ps) {
        if (ps == null) {
            return;
        }
        yamlConfigs.put("num_ps", String.valueOf(ps.getReplicas()));
        yamlConfigs.put("ps_resources", ps.getResources());
        yamlConfigs.put("ps_docker_image", ps.getDockerImage());
        yamlConfigs.put("ps_launch_cmd", ps.getLaunchCmd());
    }

    private void initWorker(Map<String, String> yamlConfigs, Role worker) {
        if (worker == null) {
            return;
        }
        yamlConfigs.put("num_workers", String.valueOf(worker.getReplicas()));
        yamlConfigs.put("worker_resources", worker.getResources());
        yamlConfigs.put("worker_docker_image", worker.getDockerImage());
        yamlConfigs.put("worker_launch_cmd", worker.getLaunchCmd());
    }

    private void initScheduling(Map<String, String> yamlConfigValues, Scheduling scheduling) {
        if (scheduling == null) {
            return;
        }
        yamlConfigValues.put("queue", scheduling.getQueue());
    }

    private void initSecurity(Map<String, String> yamlConfigValues, Security security) {
        if (security == null) {
            return;
        }
        yamlConfigValues.put("keytab", security.getKeytab());
        yamlConfigValues.put("principal", security.getPrincipal());
        yamlConfigValues.put("distribute_keytab", String.valueOf(security.isDistributeKeytab()));
    }

    private void initTensorBoard(Map<String, String> yamlConfigValues, TensorBoard tensorBoard) {
        if (tensorBoard == null) {
            return;
        }
        yamlConfigValues.put("tensorboard", Boolean.TRUE.toString());
        yamlConfigValues.put("tensorboard_docker_image", tensorBoard.getDockerImage());
        yamlConfigValues.put("tensorboard_resources", tensorBoard.getResources());
    }

    private List<String> convertToEnvsList(Map<String, String> envs) {
        if (envs == null) {
            return Collections.emptyList();
        }
        return envs.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.toList());
    }

    public static ParametersHolder createWithCmdLine(CommandLine cli, Command command) throws ParseException, YarnException {
        return new ParametersHolder(cli, null, ConfigType.CLI, command);
    }

    public static ParametersHolder createWithCmdLineAndYaml(CommandLine cli, YamlConfigFile yamlConfig, Command command) throws ParseException, YarnException {
        return new ParametersHolder(cli, yamlConfig, ConfigType.YAML, command);
    }

    public String getOptionValue(String option) throws YarnException {
        this.ensureConfigIsDefinedOnce(option, true);
        if (this.onlyDefinedWithCliArgs.contains(option) || this.parsedCommandLine.hasOption(option)) {
            return this.getValueFromCLI(option);
        }
        return this.getValueFromYaml(option);
    }

    public List<String> getOptionValues(String option) throws YarnException {
        this.ensureConfigIsDefinedOnce(option, false);
        if (this.onlyDefinedWithCliArgs.contains(option) || this.parsedCommandLine.hasOption(option)) {
            return this.getValuesFromCLI(option);
        }
        return this.getValuesFromYaml(option);
    }

    private void ensureConfigIsDefinedOnce(String option, boolean stringValue) throws YarnException {
        boolean definedWithYaml = stringValue ? this.yamlStringConfigs.containsKey(option) : this.yamlListConfigs.containsKey(option);
        if (this.parsedCommandLine.hasOption(option) && definedWithYaml) {
            throw new YarnException("Config '%s' is defined both with YAML config and with CLI argument, please only use either way!");
        }
    }

    private String getValueFromCLI(String option) {
        String value = this.parsedCommandLine.getOptionValue(option);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found config value {} for key {} from CLI configuration.", (Object)value, (Object)option);
        }
        return value;
    }

    private List<String> getValuesFromCLI(String option) {
        String[] optionValues = this.parsedCommandLine.getOptionValues(option);
        if (optionValues != null) {
            List<String> values = Arrays.asList(optionValues);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found config values {} for key {} from CLI configuration.", values, (Object)option);
            }
            return values;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No config values found for key {} from CLI configuration.", (Object)option);
        }
        return Lists.newArrayList();
    }

    private String getValueFromYaml(String option) {
        String value = this.yamlStringConfigs.get(option);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found config value {} for key {} from YAML configuration.", (Object)value, (Object)option);
        }
        return value;
    }

    private List<String> getValuesFromYaml(String option) {
        List<String> values = this.yamlListConfigs.get(option);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found config values {} for key {} from YAML configuration.", values, (Object)option);
        }
        return values;
    }

    public boolean hasOption(String option) {
        if (this.onlyDefinedWithCliArgs.contains(option)) {
            boolean value = this.parsedCommandLine.hasOption(option);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found boolean config with value {} for key {} from CLI configuration.", (Object)value, (Object)option);
            }
            return value;
        }
        if (this.parsedCommandLine.hasOption(option)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found boolean config value for key {} from CLI configuration.", (Object)option);
            }
            return true;
        }
        return this.getBooleanValueFromYaml(option);
    }

    private boolean getBooleanValueFromYaml(String option) {
        String stringValue = this.yamlStringConfigs.get(option);
        boolean result = stringValue != null && Boolean.valueOf(stringValue).equals(Boolean.TRUE);
        LOG.debug("Found config value {} for key {} from YAML configuration.", (Object)result, (Object)option);
        return result;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void updateParameters(ClientContext clientContext) throws ParseException, YarnException, IOException {
        this.parameters.updateParameters(this, clientContext);
    }

    public BaseParameters getParameters() {
        return this.parameters;
    }
}

