/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli.param;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.ParseException;

public class Localization {
    private String mountPermissionPattern = "(wr|rw)$";
    private String localPathPattern = "((^\\.$)|(^\\./$)|(^\\./[^/]+)|(^/.*))";
    private String remoteUri;
    private String localPath;
    private String mountPermission = "rw";
    private static final List<String> SUPPORTED_SCHEME = Arrays.asList("hdfs", "oss", "s3a", "s3n", "wasb", "wasbs", "abfs", "abfss", "adl", "har", "ftp", "http", "https", "viewfs", "swebhdfs", "webhdfs", "swift");

    public void parse(String arg) throws ParseException {
        String[] tokens = arg.split(":");
        int minimum = "a:b".split(":").length;
        int minimumWithPermission = "a:b:rw".split(":").length;
        int minimumParts = minimum;
        int miniPartsWithRemoteScheme = "scheme://a:b".split(":").length;
        int maximumParts = "scheme://a:b:rw".split(":").length;
        if (this.isSupportedScheme(tokens[0])) {
            minimumParts = miniPartsWithRemoteScheme;
        }
        if (tokens.length < minimumParts || tokens.length > maximumParts) {
            throw new ParseException("Invalid parameter,should be \"remoteUri:localPath[:rw|:wr]\" format for --localizations");
        }
        if (minimumParts == miniPartsWithRemoteScheme) {
            tokens[0] = tokens[0] + ":" + tokens[1];
            tokens[1] = tokens[2];
            if (tokens.length == maximumParts) {
                this.mountPermission = tokens[maximumParts - 1];
            }
        }
        if (minimumParts == minimum && tokens.length == minimumWithPermission) {
            this.mountPermission = tokens[minimumWithPermission - 1];
        }
        this.remoteUri = tokens[0];
        this.localPath = tokens[1];
        if (!this.localPath.matches(this.localPathPattern)) {
            throw new ParseException("Invalid local file path:" + this.localPath + ", it only support \".\", \"./\", \"./name\" and absolute path.");
        }
        if (!this.mountPermission.matches(this.mountPermissionPattern)) {
            throw new ParseException("Invalid mount permission (ro is not supported yet), " + this.mountPermission);
        }
    }

    public String getRemoteUri() {
        return this.remoteUri;
    }

    public void setRemoteUri(String rUti) {
        this.remoteUri = rUti;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String lPath) {
        this.localPath = lPath;
    }

    public String getMountPermission() {
        return this.mountPermission;
    }

    public void setMountPermission(String mPermission) {
        this.mountPermission = mPermission;
    }

    private boolean isSupportedScheme(String scheme) {
        return SUPPORTED_SCHEME.contains(scheme);
    }
}

