/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.AbstractCli;
import org.apache.hadoop.yarn.submarine.client.cli.CliUtils;
import org.apache.hadoop.yarn.submarine.client.cli.Command;
import org.apache.hadoop.yarn.submarine.client.cli.param.ParametersHolder;
import org.apache.hadoop.yarn.submarine.client.cli.param.ShowJobParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.exception.SubmarineException;
import org.apache.hadoop.yarn.submarine.runtimes.common.SubmarineStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowJobCli
extends AbstractCli {
    private static final Logger LOG = LoggerFactory.getLogger(ShowJobCli.class);
    private Options options = this.generateOptions();
    private ParametersHolder parametersHolder;

    public ShowJobCli(ClientContext cliContext) {
        super(cliContext);
    }

    public void printUsages() {
        new HelpFormatter().printHelp("job show", this.options);
    }

    private Options generateOptions() {
        Options options = new Options();
        options.addOption("name", true, "Name of the job");
        options.addOption("h", "help", false, "Print help");
        return options;
    }

    private void parseCommandLineAndGetShowJobParameters(String[] args) throws IOException, YarnException {
        GnuParser parser = new GnuParser();
        try {
            CommandLine cli = parser.parse(this.options, args);
            this.parametersHolder = ParametersHolder.createWithCmdLine(cli, Command.SHOW_JOB);
            this.parametersHolder.updateParameters(this.clientContext);
        }
        catch (ParseException e) {
            this.printUsages();
        }
    }

    private void printIfNotNull(String keyForPrint, String keyInStorage, Map<String, String> jobInfo) {
        if (jobInfo.containsKey(keyInStorage)) {
            System.out.println("\t" + keyForPrint + ": " + jobInfo.get(keyInStorage));
        }
    }

    private void printJobInfo(Map<String, String> jobInfo) {
        System.out.println("Job Meta Info:");
        this.printIfNotNull("Application Id", "APPLICATION_ID", jobInfo);
        this.printIfNotNull("Input Path", "INPUT_PATH", jobInfo);
        this.printIfNotNull("Saved Model Path", "SAVED_MODEL_PATH", jobInfo);
        this.printIfNotNull("Checkpoint Path", "CHECKPOINT_PATH", jobInfo);
        this.printIfNotNull("Run Parameters", "JOB_RUN_ARGS", jobInfo);
    }

    @VisibleForTesting
    protected void getAndPrintJobInfo() throws IOException {
        SubmarineStorage storage = this.clientContext.getRuntimeFactory().getSubmarineStorage();
        Map<String, String> jobInfo = null;
        try {
            jobInfo = storage.getJobInfoByName(this.getParameters().getName());
        }
        catch (IOException e) {
            LOG.error("Failed to retrieve job info", (Throwable)e);
            throw e;
        }
        this.printJobInfo(jobInfo);
    }

    @VisibleForTesting
    public ShowJobParameters getParameters() {
        return (ShowJobParameters)this.parametersHolder.getParameters();
    }

    @Override
    public int run(String[] args) throws ParseException, IOException, YarnException, InterruptedException, SubmarineException {
        if (CliUtils.argsForHelp(args)) {
            this.printUsages();
            return 0;
        }
        this.parseCommandLineAndGetShowJobParameters(args);
        this.getAndPrintJobInfo();
        return 0;
    }
}

