/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.exception.SubmarineRuntimeException;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CliUtils.class);

    public static String replacePatternsInLaunchCommand(String specifiedCli, RunJobParameters jobRunParameters, RemoteDirectoryManager directoryManager) throws IOException {
        String input = jobRunParameters.getInputPath();
        String jobDir = jobRunParameters.getCheckpointPath();
        String savedModelDir = jobRunParameters.getSavedModelPath();
        HashMap<String, String> replacePattern = new HashMap<String, String>();
        if (jobDir != null) {
            replacePattern.put("%checkpoint_path%", jobDir);
        }
        if (input != null) {
            replacePattern.put("%input_path%", input);
        }
        if (savedModelDir != null) {
            replacePattern.put("%saved_model_path%", savedModelDir);
        }
        String newCli = specifiedCli;
        for (Map.Entry replace : replacePattern.entrySet()) {
            newCli = newCli.replace((CharSequence)replace.getKey(), (CharSequence)replace.getValue());
        }
        return newCli;
    }

    public static boolean argsForHelp(String[] args) {
        if (args == null || args.length == 0) {
            return true;
        }
        if (args.length == 1) {
            return args[0].equals("-h") || args[0].equals("--help");
        }
        return false;
    }

    public static void doLoginIfSecure(String keytab, String principal) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)keytab) || StringUtils.isEmpty((CharSequence)principal)) {
            if (StringUtils.isNotEmpty((CharSequence)keytab)) {
                SubmarineRuntimeException e = new SubmarineRuntimeException("The parameter of principal is missing.");
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            if (StringUtils.isNotEmpty((CharSequence)principal)) {
                SubmarineRuntimeException e = new SubmarineRuntimeException("The parameter of keytab is missing.");
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            UserGroupInformation user = UserGroupInformation.getCurrentUser();
            if (user == null || user.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.SIMPLE) {
                SubmarineRuntimeException e = new SubmarineRuntimeException("Failed to authenticate in secure environment. Please run kinit command in advance or use --keytab/--principal parameters");
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            LOG.info("Submarine job is submitted by user: " + user.getUserName());
            return;
        }
        File keytabFile = new File(keytab);
        if (!keytabFile.exists()) {
            SubmarineRuntimeException e = new SubmarineRuntimeException("No keytab localized at  " + keytab);
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
    }
}

