/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(ZipUtilities.class);

    private ZipUtilities() {
        throw new UnsupportedOperationException("This class should not be instantiated!");
    }

    @VisibleForTesting
    public static String zipDir(String srcDir, String dstFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(dstFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        File srcFile = new File(srcDir);
        LOG.info("Compressing directory {}", (Object)srcDir);
        ZipUtilities.addDirToZip(zos, srcFile, srcFile);
        zos.close();
        LOG.info("Compressed directory {} to file: {}", (Object)srcDir, (Object)dstFile);
        return dstFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDirToZip(ZipOutputStream zos, File srcFile, File base) throws IOException {
        File[] files = srcFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ZipUtilities.addDirToZip(zos, file, base);
                continue;
            }
            byte[] buffer = new byte[1024];
            try (FileInputStream fis = new FileInputStream(file);){
                int length;
                String name = base.toURI().relativize(file.toURI()).getPath();
                LOG.info("Adding file {} to zip", (Object)name);
                zos.putNextEntry(new ZipEntry(name));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.flush();
            }
            finally {
                zos.closeEntry();
            }
        }
    }
}

