/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.submarine.client.cli.param.Localization;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.utils.EnvironmentUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localizer {
    private static final Logger LOG = LoggerFactory.getLogger(Localizer.class);
    private final FileSystemOperations fsOperations;
    private final RemoteDirectoryManager remoteDirectoryManager;
    private final RunJobParameters parameters;

    public Localizer(FileSystemOperations fsOperations, RemoteDirectoryManager remoteDirectoryManager, RunJobParameters parameters) {
        this.fsOperations = fsOperations;
        this.remoteDirectoryManager = remoteDirectoryManager;
        this.parameters = parameters;
    }

    public void handleLocalizations(Service service) throws IOException {
        String remoteUri;
        Path stagingDir = this.remoteDirectoryManager.getJobStagingArea(this.parameters.getName(), true);
        List localizations = this.parameters.getLocalizations();
        for (Localization loc : localizations) {
            File localFile;
            remoteUri = loc.getRemoteUri();
            Path resourceToLocalize = new Path(remoteUri);
            if (this.remoteDirectoryManager.isRemote(remoteUri) ? !this.remoteDirectoryManager.existsRemoteFile(resourceToLocalize) : !(localFile = new File(remoteUri)).exists()) {
                throw new FileNotFoundException("File " + remoteUri + " doesn't exists.");
            }
            this.fsOperations.validFileSize(remoteUri);
        }
        for (Localization loc : localizations) {
            remoteUri = loc.getRemoteUri();
            String containerLocalPath = loc.getLocalPath();
            String srcFileStr = remoteUri;
            ConfigFile.TypeEnum destFileType = ConfigFile.TypeEnum.STATIC;
            Path resourceToLocalize = new Path(remoteUri);
            boolean needUploadToHDFS = true;
            boolean needDeleteTempFile = false;
            if (this.remoteDirectoryManager.isDir(remoteUri)) {
                destFileType = ConfigFile.TypeEnum.ARCHIVE;
                srcFileStr = this.fsOperations.downloadAndZip(remoteUri, this.getLastNameFromPath(srcFileStr), true);
            } else if (this.remoteDirectoryManager.isRemote(remoteUri)) {
                if (!FileSystemOperations.needHdfs(remoteUri)) {
                    srcFileStr = this.fsOperations.downloadAndZip(remoteUri, this.getLastNameFromPath(srcFileStr), false);
                    needDeleteTempFile = true;
                } else {
                    needUploadToHDFS = false;
                }
            }
            if (needUploadToHDFS) {
                resourceToLocalize = this.fsOperations.uploadToRemoteFile(stagingDir, srcFileStr);
            }
            if (needDeleteTempFile) {
                this.fsOperations.deleteFiles(srcFileStr);
            }
            if (destFileType == ConfigFile.TypeEnum.ARCHIVE && srcFileStr.endsWith(".zip")) {
                this.fsOperations.deleteFiles(srcFileStr);
                int suffixIndex = srcFileStr.lastIndexOf(95);
                srcFileStr = srcFileStr.substring(0, suffixIndex);
            }
            if (!containerLocalPath.equals(".") && !containerLocalPath.equals("./")) {
                srcFileStr = this.getLastNameFromPath(containerLocalPath);
            }
            String localizedName = this.getLastNameFromPath(srcFileStr);
            LOG.info("The file/dir to be localized is {}", (Object)resourceToLocalize.toString());
            LOG.info("Its localized file name will be {}", (Object)localizedName);
            service.getConfiguration().getFiles().add(new ConfigFile().srcFile(resourceToLocalize.toUri().toString()).destFile(localizedName).type(destFileType));
            if (!containerLocalPath.startsWith("/")) continue;
            String mountStr = this.getLastNameFromPath(srcFileStr) + ":" + containerLocalPath + ":" + loc.getMountPermission();
            LOG.info("Add bind-mount string {}", (Object)mountStr);
            EnvironmentUtilities.appendToEnv(service, "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", mountStr, ",");
        }
    }

    private String getLastNameFromPath(String srcFileStr) {
        return new Path(srcFileStr).getName();
    }
}

