/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.utils;

import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.service.api.records.KerberosPrincipal;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KerberosPrincipalFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosPrincipalFactory.class);

    private KerberosPrincipalFactory() {
        throw new UnsupportedOperationException("This class should not be instantiated!");
    }

    public static KerberosPrincipal create(FileSystemOperations fsOperations, RemoteDirectoryManager remoteDirectoryManager, RunJobParameters parameters) throws IOException {
        Objects.requireNonNull(fsOperations, "FileSystemOperations must not be null!");
        Objects.requireNonNull(remoteDirectoryManager, "RemoteDirectoryManager must not be null!");
        Objects.requireNonNull(parameters, "Parameters must not be null!");
        if (StringUtils.isNotBlank((CharSequence)parameters.getKeytab()) && StringUtils.isNotBlank((CharSequence)parameters.getPrincipal())) {
            String keytab = parameters.getKeytab();
            String principal = parameters.getPrincipal();
            if (parameters.isDistributeKeytab()) {
                return KerberosPrincipalFactory.handleDistributedKeytab(fsOperations, remoteDirectoryManager, parameters, keytab, principal);
            }
            return KerberosPrincipalFactory.handleNormalKeytab(keytab, principal);
        }
        LOG.debug("Principal and keytab was null or empty, returning null KerberosPrincipal!");
        return null;
    }

    private static KerberosPrincipal handleDistributedKeytab(FileSystemOperations fsOperations, RemoteDirectoryManager remoteDirectoryManager, RunJobParameters parameters, String keytab, String principal) throws IOException {
        Path stagingDir = remoteDirectoryManager.getJobStagingArea(parameters.getName(), true);
        Path remoteKeytabPath = fsOperations.uploadToRemoteFile(stagingDir, keytab);
        fsOperations.setPermission(remoteKeytabPath, FsPermission.createImmutable((short)((short)Integer.parseInt("400", 8))));
        return new KerberosPrincipal().keytab(remoteKeytabPath.toString()).principalName(principal);
    }

    private static KerberosPrincipal handleNormalKeytab(String keytab, String principal) {
        if (!keytab.startsWith("file")) {
            keytab = "file://" + keytab;
        }
        return new KerberosPrincipal().keytab(keytab).principalName(principal);
    }
}

