/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.utils;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvironmentUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentUtilities.class);
    static final String ENV_DOCKER_MOUNTS_FOR_CONTAINER_RUNTIME = "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS";
    private static final String MOUNTS_DELIM = ",";
    private static final String ENV_SEPARATOR = "=";
    private static final String ETC_PASSWD_MOUNT_STRING = "/etc/passwd:/etc/passwd:ro";
    private static final String KERBEROS_CONF_MOUNT_STRING = "/etc/krb5.conf:/etc/krb5.conf:ro";
    private static final String ENV_VAR_DELIM = ":";

    private EnvironmentUtilities() {
        throw new UnsupportedOperationException("This class should not be instantiated!");
    }

    public static String getValueOfEnvironment(String envVar) {
        if (envVar == null || !envVar.contains(ENV_SEPARATOR)) {
            return "";
        }
        return envVar.substring(envVar.indexOf(ENV_SEPARATOR) + 1);
    }

    public static void handleServiceEnvs(Service service, Configuration yarnConfig, List<String> envVars) {
        if (envVars != null) {
            for (String envVarPair : envVars) {
                String value;
                String key;
                if (envVarPair.contains(ENV_SEPARATOR)) {
                    int idx = envVarPair.indexOf(ENV_SEPARATOR);
                    key = envVarPair.substring(0, idx);
                    value = envVarPair.substring(idx + 1);
                } else {
                    LOG.warn("Found environment variable with unusual format: '{}'", (Object)envVarPair);
                    key = envVarPair;
                    value = "";
                }
                EnvironmentUtilities.appendToEnv(service, key, value, ENV_VAR_DELIM);
            }
        }
        EnvironmentUtilities.appendOtherConfigs(service, yarnConfig);
    }

    private static void appendOtherConfigs(Service service, Configuration yarnConfig) {
        EnvironmentUtilities.appendToEnv(service, ENV_DOCKER_MOUNTS_FOR_CONTAINER_RUNTIME, ETC_PASSWD_MOUNT_STRING, MOUNTS_DELIM);
        String authentication = yarnConfig.get("hadoop.security.authentication");
        if (authentication != null && authentication.equals("kerberos")) {
            EnvironmentUtilities.appendToEnv(service, ENV_DOCKER_MOUNTS_FOR_CONTAINER_RUNTIME, KERBEROS_CONF_MOUNT_STRING, MOUNTS_DELIM);
        }
    }

    static void appendToEnv(Service service, String key, String value, String delim) {
        Map env = service.getConfiguration().getEnv();
        if (!env.containsKey(key)) {
            env.put(key, value);
        } else if (!value.isEmpty()) {
            String existingValue = (String)env.get(key);
            if (!existingValue.endsWith(delim)) {
                env.put(key, existingValue + delim + value);
            } else {
                env.put(key, existingValue + value);
            }
        }
    }
}

