/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.utils;

import java.io.File;
import java.util.StringTokenizer;

public final class ClassPathUtilities {
    private ClassPathUtilities() {
        throw new UnsupportedOperationException("This class should not be instantiated!");
    }

    public static File findFileOnClassPath(String fileName) {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File target;
            String pathElement = tokenizer.nextToken();
            File directoryOrJar = new File(pathElement);
            File absoluteDirectoryOrJar = directoryOrJar.getAbsoluteFile();
            if (!(absoluteDirectoryOrJar.isFile() ? (target = new File(absoluteDirectoryOrJar.getParent(), fileName)).exists() : (target = new File(directoryOrJar, fileName)).exists())) continue;
            return target;
        }
        return null;
    }
}

