/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.component;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.api.TensorFlowRole;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.AbstractComponent;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.TensorFlowLaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.TensorFlowCommons;
import org.apache.hadoop.yarn.submarine.utils.DockerUtilities;
import org.apache.hadoop.yarn.submarine.utils.SubmarineResourceUtils;

public class TensorFlowPsComponent
extends AbstractComponent {
    public TensorFlowPsComponent(FileSystemOperations fsOperations, RemoteDirectoryManager remoteDirectoryManager, TensorFlowLaunchCommandFactory launchCommandFactory, RunJobParameters parameters, Configuration yarnConfig) {
        super(fsOperations, remoteDirectoryManager, parameters, (Role)TensorFlowRole.PS, yarnConfig, launchCommandFactory);
    }

    @Override
    public Component createComponent() throws IOException {
        TensorFlowRunJobParameters tensorFlowParams = (TensorFlowRunJobParameters)this.parameters;
        Objects.requireNonNull(tensorFlowParams.getPsResource(), "PS resource must not be null!");
        if (tensorFlowParams.getNumPS() < 1) {
            throw new IllegalArgumentException("Number of PS should be at least 1!");
        }
        Component component = new Component();
        component.setName(this.role.getComponentName());
        component.setNumberOfContainers(Long.valueOf(tensorFlowParams.getNumPS()));
        component.setRestartPolicy(Component.RestartPolicyEnum.NEVER);
        component.setResource(SubmarineResourceUtils.convertYarnResourceToServiceResource(tensorFlowParams.getPsResource()));
        if (tensorFlowParams.getPsDockerImage() != null) {
            component.setArtifact(DockerUtilities.getDockerArtifact(tensorFlowParams.getPsDockerImage()));
        }
        TensorFlowCommons.addCommonEnvironments(component, this.role);
        this.generateLaunchCommand(component);
        return component;
    }
}

