/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.component;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.api.TensorFlowRole;
import org.apache.hadoop.yarn.submarine.common.fs.RemoteDirectoryManager;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.AbstractComponent;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.YarnServiceUtils;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.TensorFlowLaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.TensorFlowCommons;
import org.apache.hadoop.yarn.submarine.utils.DockerUtilities;
import org.apache.hadoop.yarn.submarine.utils.SubmarineResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorBoardComponent
extends AbstractComponent {
    private static final Logger LOG = LoggerFactory.getLogger(TensorBoardComponent.class);
    public static final String TENSORBOARD_QUICKLINK_LABEL = "Tensorboard";
    private static final int DEFAULT_PORT = 6006;
    private String tensorboardLink;

    public TensorBoardComponent(FileSystemOperations fsOperations, RemoteDirectoryManager remoteDirectoryManager, RunJobParameters parameters, TensorFlowLaunchCommandFactory launchCommandFactory, Configuration yarnConfig) {
        super(fsOperations, remoteDirectoryManager, parameters, (Role)TensorFlowRole.TENSORBOARD, yarnConfig, launchCommandFactory);
    }

    @Override
    public Component createComponent() throws IOException {
        TensorFlowRunJobParameters tensorFlowParams = (TensorFlowRunJobParameters)this.parameters;
        Objects.requireNonNull(tensorFlowParams.getTensorboardResource(), "TensorBoard resource must not be null!");
        Component component = new Component();
        component.setName(this.role.getComponentName());
        component.setNumberOfContainers(Long.valueOf(1L));
        component.setRestartPolicy(Component.RestartPolicyEnum.NEVER);
        component.setResource(SubmarineResourceUtils.convertYarnResourceToServiceResource(tensorFlowParams.getTensorboardResource()));
        if (tensorFlowParams.getTensorboardDockerImage() != null) {
            component.setArtifact(DockerUtilities.getDockerArtifact(tensorFlowParams.getTensorboardDockerImage()));
        }
        TensorFlowCommons.addCommonEnvironments(component, this.role);
        this.generateLaunchCommand(component);
        this.tensorboardLink = "http://" + YarnServiceUtils.getDNSName(this.parameters.getName(), this.role.getComponentName() + "-" + 0, TensorFlowCommons.getUserName(), TensorFlowCommons.getDNSDomain(this.yarnConfig), 6006);
        LOG.info("Link to tensorboard:" + this.tensorboardLink);
        return component;
    }

    public String getTensorboardLink() {
        return this.tensorboardLink;
    }
}

