/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.command;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineLogs;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.HadoopEnvironmentSetup;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.command.TensorFlowLaunchCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorFlowPsLaunchCommand
extends TensorFlowLaunchCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TensorFlowPsLaunchCommand.class);
    private final String launchCommand;

    public TensorFlowPsLaunchCommand(HadoopEnvironmentSetup hadoopEnvSetup, Role role, Component component, TensorFlowRunJobParameters parameters, Configuration yarnConfig) throws IOException {
        super(hadoopEnvSetup, role, component, parameters, yarnConfig);
        this.launchCommand = parameters.getPSLaunchCmd();
        if (StringUtils.isEmpty((CharSequence)this.launchCommand)) {
            throw new IllegalArgumentException("LaunchCommand must not be null or empty!");
        }
    }

    @Override
    public String createLaunchCommand() {
        if (SubmarineLogs.isVerbose()) {
            LOG.info("PS command =[" + this.launchCommand + "]");
        }
        return this.launchCommand + '\n';
    }
}

