/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.command;

import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.HadoopEnvironmentSetup;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.AbstractLaunchCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorBoardLaunchCommand
extends AbstractLaunchCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TensorBoardLaunchCommand.class);
    private final String checkpointPath;

    public TensorBoardLaunchCommand(HadoopEnvironmentSetup hadoopEnvSetup, Role role, Component component, RunJobParameters parameters) throws IOException {
        super(hadoopEnvSetup, component, parameters, role.getName());
        Objects.requireNonNull(parameters.getCheckpointPath(), "CheckpointPath must not be null as it is part of the tensorboard command!");
        if (StringUtils.isEmpty((CharSequence)parameters.getCheckpointPath())) {
            throw new IllegalArgumentException("CheckpointPath must not be empty!");
        }
        this.checkpointPath = parameters.getCheckpointPath();
    }

    @Override
    public String generateLaunchScript() throws IOException {
        return this.getBuilder().withLaunchCommand(this.createLaunchCommand()).build();
    }

    @Override
    public String createLaunchCommand() {
        String tbCommand = String.format("export LC_ALL=C && tensorboard --logdir=%s%n", this.checkpointPath);
        LOG.info("Tensorboard command=" + tbCommand);
        return tbCommand;
    }
}

