/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow;

import java.io.IOException;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.Framework;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.AbstractServiceSpec;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.ServiceWrapper;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.TensorFlowLaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.component.TensorBoardComponent;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.component.TensorFlowPsComponent;
import org.apache.hadoop.yarn.submarine.utils.Localizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorFlowServiceSpec
extends AbstractServiceSpec {
    private static final Logger LOG = LoggerFactory.getLogger(TensorFlowServiceSpec.class);
    private final TensorFlowRunJobParameters tensorFlowParameters;

    public TensorFlowServiceSpec(TensorFlowRunJobParameters parameters, ClientContext clientContext, FileSystemOperations fsOperations, TensorFlowLaunchCommandFactory launchCommandFactory, Localizer localizer) {
        super((RunJobParameters)parameters, clientContext, fsOperations, launchCommandFactory, localizer);
        this.tensorFlowParameters = parameters;
    }

    @Override
    public ServiceWrapper create() throws IOException {
        LOG.info("Creating TensorFlow service spec");
        ServiceWrapper serviceWrapper = this.createServiceSpecWrapper();
        if (this.tensorFlowParameters.getNumWorkers() > 0) {
            this.addWorkerComponents(serviceWrapper, Framework.TENSORFLOW);
        }
        if (this.tensorFlowParameters.getNumPS() > 0) {
            this.addPsComponent(serviceWrapper);
        }
        if (this.tensorFlowParameters.isTensorboardEnabled()) {
            this.createTensorBoardComponent(serviceWrapper);
        }
        this.handleQuicklinks(serviceWrapper.getService());
        return serviceWrapper;
    }

    private void createTensorBoardComponent(ServiceWrapper serviceWrapper) throws IOException {
        TensorBoardComponent tbComponent = new TensorBoardComponent(this.fsOperations, this.remoteDirectoryManager, this.parameters, (TensorFlowLaunchCommandFactory)this.launchCommandFactory, this.yarnConfig);
        serviceWrapper.addComponent(tbComponent);
        TensorFlowServiceSpec.addQuicklink(serviceWrapper.getService(), "Tensorboard", tbComponent.getTensorboardLink());
    }

    private void addPsComponent(ServiceWrapper serviceWrapper) throws IOException {
        serviceWrapper.addComponent(new TensorFlowPsComponent(this.fsOperations, this.remoteDirectoryManager, (TensorFlowLaunchCommandFactory)this.launchCommandFactory, this.parameters, this.yarnConfig));
    }
}

