/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.ServiceApiConstants;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.YarnServiceUtils;

public final class TensorFlowCommons {
    private TensorFlowCommons() {
        throw new UnsupportedOperationException("This class should not be instantiated!");
    }

    public static void addCommonEnvironments(Component component, Role role) {
        Map envs = component.getConfiguration().getEnv();
        envs.put("_TASK_INDEX", ServiceApiConstants.COMPONENT_ID);
        envs.put("_TASK_TYPE", role.getName());
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getDNSDomain(Configuration yarnConfig) {
        return yarnConfig.get("hadoop.registry.dns.domain-name");
    }

    public static String getScriptFileName(Role role) {
        return "run-" + role.getName() + ".sh";
    }

    public static String getTFConfigEnv(String componentName, int nWorkers, int nPs, String serviceName, String userName, String domain) {
        String commonEndpointSuffix = YarnServiceUtils.getDNSNameCommonSuffix(serviceName, userName, domain, 8000);
        String json = "{\\\"cluster\\\":{";
        String master = TensorFlowCommons.getComponentArrayJson("master", 1, commonEndpointSuffix) + ",";
        String worker = TensorFlowCommons.getComponentArrayJson("worker", nWorkers - 1, commonEndpointSuffix) + ",";
        String ps = TensorFlowCommons.getComponentArrayJson("ps", nPs, commonEndpointSuffix) + "},";
        StringBuilder sb = new StringBuilder();
        sb.append("\\\"task\\\":{");
        sb.append(" \\\"type\\\":\\\"");
        sb.append(componentName);
        sb.append("\\\",");
        sb.append(" \\\"index\\\":");
        sb.append('$');
        sb.append("_TASK_INDEX},");
        String task = sb.toString();
        String environment = "\\\"environment\\\":\\\"cloud\\\"}";
        sb = new StringBuilder();
        sb.append(json);
        sb.append(master);
        sb.append(worker);
        sb.append(ps);
        sb.append(task);
        sb.append(environment);
        return sb.toString();
    }

    private static String getComponentArrayJson(String componentName, int count, String endpointSuffix) {
        String component = "\\\"" + componentName + "\\\":";
        StringBuilder array = new StringBuilder();
        array.append("[");
        for (int i = 0; i < count; ++i) {
            array.append("\\\"");
            array.append(componentName);
            array.append("-");
            array.append(i);
            array.append(endpointSuffix);
            array.append("\\\"");
            if (i == count - 1) continue;
            array.append(",");
        }
        array.append("]");
        return component + array.toString();
    }
}

