/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.pytorch.command;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.PyTorchRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.conf.SubmarineLogs;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.HadoopEnvironmentSetup;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.AbstractLaunchCommand;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.LaunchScriptBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyTorchWorkerLaunchCommand
extends AbstractLaunchCommand {
    private static final Logger LOG = LoggerFactory.getLogger(PyTorchWorkerLaunchCommand.class);
    private final Configuration yarnConfig;
    private final boolean distributed;
    private final int numberOfWorkers;
    private final String name;
    private final Role role;
    private final String launchCommand;

    public PyTorchWorkerLaunchCommand(HadoopEnvironmentSetup hadoopEnvSetup, Role role, Component component, PyTorchRunJobParameters parameters, Configuration yarnConfig) throws IOException {
        super(hadoopEnvSetup, component, (RunJobParameters)parameters, role.getName());
        this.role = role;
        this.name = parameters.getName();
        this.distributed = parameters.isDistributed();
        this.numberOfWorkers = parameters.getNumWorkers();
        this.yarnConfig = yarnConfig;
        this.logReceivedParameters();
        this.launchCommand = parameters.getWorkerLaunchCmd();
        if (StringUtils.isEmpty((CharSequence)this.launchCommand)) {
            throw new IllegalArgumentException("LaunchCommand must not be null or empty!");
        }
    }

    private void logReceivedParameters() {
        if (this.numberOfWorkers <= 0) {
            LOG.warn("Received number of workers: {}", (Object)this.numberOfWorkers);
        }
    }

    @Override
    public String generateLaunchScript() throws IOException {
        LaunchScriptBuilder builder = this.getBuilder();
        return builder.withLaunchCommand(this.createLaunchCommand()).build();
    }

    @Override
    public String createLaunchCommand() {
        if (SubmarineLogs.isVerbose()) {
            LOG.info("PyTorch Worker command =[" + this.launchCommand + "]");
        }
        return this.launchCommand + '\n';
    }
}

