/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.pytorch;

import java.io.IOException;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.PyTorchRunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.runjob.Framework;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.AbstractServiceSpec;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.FileSystemOperations;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.ServiceWrapper;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.PyTorchLaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.utils.Localizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyTorchServiceSpec
extends AbstractServiceSpec {
    private static final Logger LOG = LoggerFactory.getLogger(PyTorchServiceSpec.class);
    private final PyTorchRunJobParameters pyTorchParameters;

    public PyTorchServiceSpec(PyTorchRunJobParameters parameters, ClientContext clientContext, FileSystemOperations fsOperations, PyTorchLaunchCommandFactory launchCommandFactory, Localizer localizer) {
        super((RunJobParameters)parameters, clientContext, fsOperations, launchCommandFactory, localizer);
        this.pyTorchParameters = parameters;
    }

    @Override
    public ServiceWrapper create() throws IOException {
        LOG.info("Creating PyTorch service spec");
        ServiceWrapper serviceWrapper = this.createServiceSpecWrapper();
        if (this.parameters.getNumWorkers() > 0) {
            this.addWorkerComponents(serviceWrapper, Framework.PYTORCH);
        }
        this.handleQuicklinks(serviceWrapper.getService());
        return serviceWrapper;
    }
}

