/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.common.api.TensorFlowRole;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.HadoopEnvironmentSetup;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.AbstractLaunchCommand;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.LaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.command.TensorBoardLaunchCommand;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.command.TensorFlowPsLaunchCommand;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.tensorflow.command.TensorFlowWorkerLaunchCommand;

public class TensorFlowLaunchCommandFactory
implements LaunchCommandFactory {
    private final HadoopEnvironmentSetup hadoopEnvSetup;
    private final TensorFlowRunJobParameters parameters;
    private final Configuration yarnConfig;

    public TensorFlowLaunchCommandFactory(HadoopEnvironmentSetup hadoopEnvSetup, TensorFlowRunJobParameters parameters, Configuration yarnConfig) {
        this.hadoopEnvSetup = hadoopEnvSetup;
        this.parameters = parameters;
        this.yarnConfig = yarnConfig;
    }

    @Override
    public AbstractLaunchCommand createLaunchCommand(Role role, Component component) throws IOException {
        Objects.requireNonNull(role, "Role must not be null!");
        if (role == TensorFlowRole.WORKER || role == TensorFlowRole.PRIMARY_WORKER) {
            return new TensorFlowWorkerLaunchCommand(this.hadoopEnvSetup, role, component, this.parameters, this.yarnConfig);
        }
        if (role == TensorFlowRole.PS) {
            return new TensorFlowPsLaunchCommand(this.hadoopEnvSetup, role, component, this.parameters, this.yarnConfig);
        }
        if (role == TensorFlowRole.TENSORBOARD) {
            return new TensorBoardLaunchCommand(this.hadoopEnvSetup, role, component, (RunJobParameters)this.parameters);
        }
        throw new IllegalStateException("Unknown task type: " + role);
    }
}

