/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.PyTorchRunJobParameters;
import org.apache.hadoop.yarn.submarine.common.api.PyTorchRole;
import org.apache.hadoop.yarn.submarine.common.api.Role;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.HadoopEnvironmentSetup;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.AbstractLaunchCommand;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command.LaunchCommandFactory;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.pytorch.command.PyTorchWorkerLaunchCommand;

public class PyTorchLaunchCommandFactory
implements LaunchCommandFactory {
    private final HadoopEnvironmentSetup hadoopEnvSetup;
    private final PyTorchRunJobParameters parameters;
    private final Configuration yarnConfig;

    public PyTorchLaunchCommandFactory(HadoopEnvironmentSetup hadoopEnvSetup, PyTorchRunJobParameters parameters, Configuration yarnConfig) {
        this.hadoopEnvSetup = hadoopEnvSetup;
        this.parameters = parameters;
        this.yarnConfig = yarnConfig;
    }

    @Override
    public AbstractLaunchCommand createLaunchCommand(Role role, Component component) throws IOException {
        Objects.requireNonNull(role, "Role must not be null!");
        if (role == PyTorchRole.WORKER || role == PyTorchRole.PRIMARY_WORKER) {
            return new PyTorchWorkerLaunchCommand(this.hadoopEnvSetup, role, component, this.parameters, this.yarnConfig);
        }
        throw new IllegalStateException("Unknown task type: " + role);
    }
}

