/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.submarine.client.cli.param.runjob.RunJobParameters;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.HadoopEnvironmentSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchScriptBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchScriptBuilder.class);
    private final File file;
    private final HadoopEnvironmentSetup hadoopEnvSetup;
    private final RunJobParameters parameters;
    private final Component component;
    private final OutputStreamWriter writer;
    private final StringBuilder scriptBuffer;
    private String launchCommand;

    LaunchScriptBuilder(String launchScriptPrefix, HadoopEnvironmentSetup hadoopEnvSetup, RunJobParameters parameters, Component component) throws IOException {
        this.file = File.createTempFile(launchScriptPrefix + "-launch-script", ".sh");
        this.hadoopEnvSetup = hadoopEnvSetup;
        this.parameters = parameters;
        this.component = component;
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);
        this.scriptBuffer = new StringBuilder();
    }

    public void append(String s) {
        this.scriptBuffer.append(s);
    }

    public LaunchScriptBuilder withLaunchCommand(String command) {
        this.launchCommand = command;
        return this;
    }

    public String build() throws IOException {
        if (this.launchCommand != null) {
            this.append(this.launchCommand);
        } else {
            LOG.warn("LaunchScript object was null!");
            if (LOG.isDebugEnabled()) {
                LOG.debug("LaunchScript's Builder object: {}", (Object)this);
            }
        }
        try (PrintWriter pw = new PrintWriter(this.writer);){
            this.writeBashHeader(pw);
            this.hadoopEnvSetup.addHdfsClassPath(this.parameters, pw, this.component);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Appending command to launch script: {}", (Object)this.scriptBuffer);
            }
            pw.append(this.scriptBuffer);
        }
        return this.file.getAbsolutePath();
    }

    public String toString() {
        return "LaunchScriptBuilder{file=" + this.file + ", hadoopEnvSetup=" + this.hadoopEnvSetup + ", parameters=" + this.parameters + ", component=" + this.component + ", writer=" + this.writer + ", scriptBuffer=" + this.scriptBuffer + ", launchCommand='" + this.launchCommand + '\'' + '}';
    }

    private void writeBashHeader(PrintWriter pw) {
        pw.append("#!/bin/bash\n");
    }
}

