/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.api.AppAdminClient;

public final class YarnServiceUtils {
    private static AppAdminClient stubServiceClient = null;

    private YarnServiceUtils() {
    }

    static AppAdminClient createServiceClient(Configuration yarnConfiguration) {
        if (stubServiceClient != null) {
            return stubServiceClient;
        }
        return AppAdminClient.createAppAdminClient((String)"yarn-service", (Configuration)yarnConfiguration);
    }

    @VisibleForTesting
    public static void setStubServiceClient(AppAdminClient stubServiceClient) {
        YarnServiceUtils.stubServiceClient = stubServiceClient;
    }

    public static String getDNSName(String serviceName, String componentInstanceName, String userName, String domain, int port) {
        return componentInstanceName + YarnServiceUtils.getDNSNameCommonSuffix(serviceName, userName, domain, port);
    }

    public static String getDNSNameCommonSuffix(String serviceName, String userName, String domain, int port) {
        return "." + serviceName + "." + userName + "." + domain + ":" + port;
    }
}

